/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.CategorySelector;
import org.netbeans.modules.form.palette.PaletteItemDataObject;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

public final class BeanInstaller {
    private static WeakReference wizardRef;

    private BeanInstaller() {
    }

    public static void installBeans(String sourceType) {
        AddToPaletteWizard wizard = BeanInstaller.getAddWizard();
        if (wizard.show(sourceType)) {
            BeanInstaller.createPaletteItems(sourceType, wizard.getSelectedBeans(), wizard.getSelectedCategory());
        }
    }

    public static void installBeans(Node[] nodes) {
        final LinkedList beans = new LinkedList();
        final LinkedList unableToInstall = new LinkedList();
        for (int i = 0; i < nodes.length; ++i) {
            DataObject dobj = (DataObject)nodes[i].getCookie(DataObject.class);
            if (dobj == null) continue;
            final FileObject fo = dobj.getPrimaryFile();
            JavaClassHandler handler = new JavaClassHandler(){

                public void handle(String className) {
                    ClassSource classSource = ClassPathUtils.getProjectClassSource(fo, className);
                    if (classSource == null) {
                        unableToInstall.add(className);
                    } else {
                        beans.add(classSource);
                    }
                }
            };
            BeanInstaller.scanFileObject(fo.getParent(), fo, handler);
        }
        if (unableToInstall.size() > 0) {
            Iterator iter = unableToInstall.iterator();
            StringBuffer sb = new StringBuffer();
            while (iter.hasNext()) {
                sb.append(iter.next() + ", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            String messageFormat = PaletteUtils.getBundleString("MSG_cannotInstallBeans");
            String message = MessageFormat.format(messageFormat, sb.toString());
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (beans.size() == 0) {
                return;
            }
        }
        if (beans.size() == 0) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)PaletteUtils.getBundleString("MSG_noBeansUnderNodes"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        String category = CategorySelector.selectCategory();
        if (category == null) {
            return;
        }
        final FileObject categoryFolder = PaletteUtils.getPaletteFolder().getFileObject(category);
        try {
            Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    for (ClassSource classSource : beans) {
                        try {
                            PaletteItemDataObject.createFile(categoryFolder, classSource);
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    static List findJavaBeansInJar(File[] jarFiles) {
        HashMap<String, ItemInfo> beans = null;
        for (int i = 0; i < jarFiles.length; ++i) {
            Manifest manifest;
            try {
                manifest = new JarFile(jarFiles[i]).getManifest();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                continue;
            }
            if (manifest == null) continue;
            String jarPath = jarFiles[i].getAbsolutePath();
            Map<String, Attributes> entries = manifest.getEntries();
            for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
                String value;
                String key = entry.getKey();
                if (!key.endsWith(".class") || !"True".equalsIgnoreCase(value = entry.getValue().getValue("Java-Bean"))) continue;
                String classname = key.substring(0, key.length() - 6).replace('\\', '/').replace('/', '.');
                if (classname.startsWith(".")) {
                    classname = classname.substring(1);
                }
                ItemInfo ii = new ItemInfo();
                ii.classname = classname;
                ii.source = jarPath;
                if (beans == null) {
                    beans = new HashMap<String, ItemInfo>(100);
                }
                beans.put(ii.classname, ii);
            }
        }
        return beans != null ? new ArrayList(beans.values()) : null;
    }

    static List findJavaBeans(File[] roots) {
        HashMap beans = new HashMap(100);
        for (int i = 0; i < roots.length; ++i) {
            FileObject foRoot = FileUtil.toFileObject((File)roots[i]);
            if (foRoot == null) continue;
            if (FileUtil.isArchiveFile((FileObject)foRoot)) {
                foRoot = FileUtil.getArchiveRoot((FileObject)foRoot);
            }
            if (foRoot == null || !foRoot.isFolder()) continue;
            BeanInstaller.scanFolderForBeans(foRoot, beans, roots[i].getAbsolutePath());
        }
        return new ArrayList(beans.values());
    }

    private static void createPaletteItems(final String sourceType, final ItemInfo[] beans, String category) {
        if (beans.length == 0) {
            return;
        }
        final FileObject categoryFolder = PaletteUtils.getPaletteFolder().getFileObject(category);
        if (categoryFolder == null) {
            return;
        }
        try {
            Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    String[] cpTypes = new String[]{sourceType};
                    for (int i = 0; i < beans.length; ++i) {
                        try {
                            PaletteItemDataObject.createFile(categoryFolder, new ClassSource(beans[i].classname, cpTypes, new String[]{beans[i].source}));
                            continue;
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private static void scanFolderForBeans(FileObject folder, final Map beans, final String root) {
        JavaClassHandler handler = new JavaClassHandler(){

            public void handle(String className) {
                ItemInfo ii = new ItemInfo();
                ii.classname = className;
                ii.source = root;
                beans.put(ii.classname, ii);
            }
        };
        FileObject[] files = folder.getChildren();
        for (int i = 0; i < files.length; ++i) {
            FileObject fo = files[i];
            if (fo.isFolder()) {
                BeanInstaller.scanFolderForBeans(fo, beans, root);
                continue;
            }
            try {
                if (!"class".equals(fo.getExt()) || DataObject.find((FileObject)fo) == null) continue;
                BeanInstaller.scanFileObject(folder, fo, handler);
                continue;
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
    }

    private static void scanFileObject(FileObject folder, FileObject fileObject, JavaClassHandler handler) {
        if ("class".equals(fileObject.getExt())) {
            BeanInstaller.processClassFile(fileObject, handler);
        } else if ("java".equals(fileObject.getExt())) {
            BeanInstaller.processJavaFile(fileObject, handler);
        }
    }

    public static String findJavaBeanName(FileObject file) {
        final String[] fqn = new String[1];
        BeanInstaller.scanFileObject(null, file, new JavaClassHandler(){

            public void handle(String className) {
                fqn[0] = className;
            }
        });
        return fqn[0];
    }

    private static void processJavaFile(final FileObject javaFO, final JavaClassHandler handler) {
        try {
            JavaSource js = JavaSource.forFileObject((FileObject)javaFO);
            js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController ctrl) throws Exception {
                    ctrl.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement clazz = BeanInstaller.findClass(ctrl, javaFO.getName());
                    if (clazz != null && BeanInstaller.isDeclaredAsJavaBean(clazz)) {
                        handler.handle(clazz.getQualifiedName().toString());
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Logger.getLogger(BeanInstaller.class.getClass().getName()).log(Level.SEVERE, javaFO.toString(), ex);
        }
    }

    private static TypeElement findClass(CompilationController ctrl, String className) {
        for (Tree tree : ctrl.getCompilationUnit().getTypeDecls()) {
            if (!className.equals(((ClassTree)tree).getSimpleName().toString())) continue;
            TreePath path = ctrl.getTrees().getPath(ctrl.getCompilationUnit(), tree);
            TypeElement clazz = (TypeElement)ctrl.getTrees().getElement(path);
            return clazz;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processClassFile(FileObject classFO, JavaClassHandler handler) {
        try {
            ClassFile clazz;
            InputStream is = null;
            try {
                is = classFO.getInputStream();
                clazz = new ClassFile(is, false);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            if (clazz != null && BeanInstaller.isDeclaredAsJavaBean(clazz)) {
                handler.handle(clazz.getName().getExternalName());
            }
        }
        catch (IOException ex) {
            Logger.getLogger(BeanInstaller.class.getClass().getName()).log(Level.SEVERE, classFO.toString(), ex);
        }
    }

    public static boolean isDeclaredAsJavaBean(TypeElement clazz) {
        Set<javax.lang.model.element.Modifier> mods = clazz.getModifiers();
        if (ElementKind.CLASS != clazz.getKind() || !mods.contains((Object)javax.lang.model.element.Modifier.PUBLIC) || mods.contains((Object)javax.lang.model.element.Modifier.ABSTRACT)) {
            return false;
        }
        for (Element element : clazz.getEnclosedElements()) {
            mods = element.getModifiers();
            if (ElementKind.CONSTRUCTOR != element.getKind() || !mods.contains((Object)javax.lang.model.element.Modifier.PUBLIC) || !((ExecutableElement)element).getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeclaredAsJavaBean(ClassFile clazz) {
        int access = clazz.getAccess();
        if (!Modifier.isPublic(access) || Modifier.isAbstract(access) || Modifier.isInterface(access) || clazz.isAnnotation() || clazz.isEnum() || clazz.isSynthetic()) {
            return false;
        }
        for (Method omethod : clazz.getMethods()) {
            Method method = omethod;
            if (!method.isPublic() || !method.getParameters().isEmpty() || !"<init>".equals(method.getName())) continue;
            return true;
        }
        return false;
    }

    private static AddToPaletteWizard getAddWizard() {
        AddToPaletteWizard wizard = null;
        if (wizardRef != null) {
            wizard = (AddToPaletteWizard)((Object)wizardRef.get());
        }
        if (wizard == null) {
            wizard = new AddToPaletteWizard();
            wizardRef = new WeakReference<AddToPaletteWizard>(wizard);
        }
        return wizard;
    }

    static class ItemInfo
    implements Comparable {
        String classname;
        String source;

        ItemInfo() {
        }

        public int compareTo(Object o) {
            ItemInfo ii = (ItemInfo)o;
            int i = this.classname.lastIndexOf(46);
            String name1 = i >= 0 ? this.classname.substring(i + 1) : this.classname;
            i = ii.classname.lastIndexOf(46);
            String name2 = i >= 0 ? ii.classname.substring(i + 1) : ii.classname;
            return name1.compareTo(name2);
        }
    }

    private static interface JavaClassHandler {
        public void handle(String var1);
    }
}

