/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

class ChooseJARWizardPanel
implements WizardDescriptor.Panel {
    private JFileChooser fileChooser;
    private static String lastDirectoryUsed;
    private AddToPaletteWizard wizard;
    private EventListenerList listenerList;

    ChooseJARWizardPanel() {
    }

    public Component getComponent() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(lastDirectoryUsed);
            this.fileChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.fileChooser.setName(PaletteUtils.getBundleString("CTL_SelectJAR_Caption"));
            this.fileChooser.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            this.fileChooser.setControlButtonsAreShown(false);
            this.fileChooser.setMultiSelectionEnabled(true);
            this.fileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".jar");
                }

                public String getDescription() {
                    return PaletteUtils.getBundleString("CTL_JarArchivesMask");
                }
            });
            this.fileChooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    if ("ApproveSelection".equals(ev.getActionCommand())) {
                        ChooseJARWizardPanel.this.wizard.stepToNext();
                    } else if ("CancelSelection".equals(ev.getActionCommand())) {
                        ChooseJARWizardPanel.this.fileChooser.getTopLevelAncestor().setVisible(false);
                    }
                }
            });
            this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent ev) {
                    if ("SelectedFilesChangedProperty".equals(ev.getPropertyName())) {
                        ChooseJARWizardPanel.this.fireStateChanged();
                    }
                }
            });
        }
        return this.fileChooser;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        if (this.fileChooser != null && this.fileChooser.getSelectedFiles().length > 0) {
            lastDirectoryUsed = this.fileChooser.getCurrentDirectory().getAbsolutePath();
            return true;
        }
        return false;
    }

    public void readSettings(Object settings) {
        this.wizard = (AddToPaletteWizard)((Object)settings);
    }

    public void storeSettings(Object settings) {
        if (this.fileChooser != null) {
            ((AddToPaletteWizard)((Object)settings)).setJARFiles(this.fileChooser.getSelectedFiles());
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, listener);
        }
    }

    void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }
}

