/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.project;

import java.io.InputStream;
import java.net.URL;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

final class FormClassLoader
extends ClassLoader {
    private ClassLoader systemClassLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
    private ClassLoader projectClassLoader;

    FormClassLoader(ClassLoader projectClassLoader) {
        this.projectClassLoader = projectClassLoader;
    }

    ClassLoader getProjectClassLoader() {
        return this.projectClassLoader;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        int type = ClassPathUtils.getClassLoadingType(name);
        if (type == 0) {
            if (this.projectClassLoader == null) {
                throw new ClassNotFoundException(ClassPathUtils.getBundleString("MSG_NullClassPath"));
            }
            return this.projectClassLoader.loadClass(name);
        }
        if (type == 1) {
            return this.systemClassLoader.loadClass(name);
        }
        Class<?> c = null;
        String filename = name.replace('.', '/').concat(".class");
        URL url = this.systemClassLoader.getResource(filename);
        if (url == null && this.projectClassLoader != null) {
            url = this.projectClassLoader.getResource(filename);
        }
        if (url != null) {
            try {
                String packageName;
                Package pakcage;
                int first;
                InputStream is = url.openStream();
                byte[] data = null;
                int available = is.available();
                while ((first = is.read()) != -1) {
                    int count;
                    int read;
                    int length = is.available();
                    if (length != available) {
                        ++length;
                    }
                    byte[] b = new byte[length];
                    b[0] = (byte)first;
                    for (count = 1; count < length; count += read) {
                        read = is.read(b, count, length - count);
                        assert (read != -1);
                    }
                    if (data == null) {
                        data = b;
                        continue;
                    }
                    byte[] temp = new byte[data.length + count];
                    System.arraycopy(data, 0, temp, 0, data.length);
                    System.arraycopy(b, 0, temp, data.length, count);
                    data = temp;
                }
                int dot = name.lastIndexOf(46);
                if (dot != -1 && (pakcage = this.getPackage(packageName = name.substring(0, dot))) == null) {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                c = this.defineClass(name, data, 0, data.length);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    public URL getResource(String name) {
        URL url;
        URL uRL = url = this.projectClassLoader != null ? this.projectClassLoader.getResource(name) : null;
        if (url == null) {
            url = this.systemClassLoader.getResource(name);
        }
        return url;
    }
}

