/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.netbeans.modules.options.keymap.CompoundAction;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeymapModel {
    private static final Logger LOG = Logger.getLogger(KeymapModel.class.getName());
    private static ArrayList<KeymapManager> al = new ArrayList();
    private Map<String, Set<ShortcutAction>> categoryToActions = new HashMap<String, Set<ShortcutAction>>();
    private Map<String, Map<ShortcutAction, Set<String>>> keyMaps = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private Map<String, Map<ShortcutAction, Set<String>>> keyMapDefaults = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private Map<ShortcutAction, CompoundAction> sharedActions = new HashMap<ShortcutAction, CompoundAction>();

    public KeymapModel() {
        Iterator<String> it = this.getActionCategories().iterator();
        while (it.hasNext()) {
            this.getActions(it.next());
        }
    }

    public static Collection<? extends KeymapManager> getKeymapManagerInstances() {
        if (!al.isEmpty()) {
            return al;
        }
        al.addAll(Lookup.getDefault().lookupAll(KeymapManager.class));
        return al;
    }

    public Set<String> getActionCategories() {
        HashSet<String> result = new HashSet<String>();
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            result.addAll(keymapManager.getActions().keySet());
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<ShortcutAction> getActions(String category) {
        if (!this.categoryToActions.containsKey(category)) {
            Set<ShortcutAction> actions = new HashSet<ShortcutAction>();
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                Set<ShortcutAction> s = keymapManager.getActions().get(category);
                if (s == null) continue;
                actions = this.mergeActions(actions, s, keymapManager.getName());
            }
            this.categoryToActions.put(category, actions);
        }
        return this.categoryToActions.get(category);
    }

    public void refreshActions() {
        this.categoryToActions = new HashMap<String, Set<ShortcutAction>>();
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            keymapManager.refreshActions();
        }
    }

    public String getCurrentProfile() {
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            String res = keymapManager.getCurrentProfile();
            if (res == null) continue;
            return res;
        }
        return "NetBeans";
    }

    public void setCurrentProfile(String profile) {
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            keymapManager.setCurrentProfile(profile);
        }
    }

    public List getProfiles() {
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            List<String> l = keymapManager.getProfiles();
            if (l == null) continue;
            return l;
        }
        return null;
    }

    public boolean isCustomProfile(String profile) {
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            boolean res = keymapManager.isCustomProfile(profile);
            if (!res) continue;
            return true;
        }
        return false;
    }

    public Map<ShortcutAction, Set<String>> getKeymap(String profile) {
        if (!this.keyMaps.containsKey(profile)) {
            Map<ShortcutAction, Set<String>> res = new HashMap<ShortcutAction, Set<String>>();
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                Map<ShortcutAction, Set<String>> mm = keymapManager.getKeymap(profile);
                res = this.mergeShortcuts(res, mm);
            }
            this.keyMaps.put(profile, res);
        }
        return this.keyMaps.get(profile);
    }

    public Map<ShortcutAction, Set<String>> getKeymapDefaults(String profile) {
        if (!this.keyMapDefaults.containsKey(profile)) {
            Map<ShortcutAction, Set<String>> res = new HashMap<ShortcutAction, Set<String>>();
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                Map<ShortcutAction, Set<String>> mm = keymapManager.getKeymap(profile);
                res = this.mergeShortcuts(res, mm);
            }
            this.keyMapDefaults.put(profile, res);
        }
        return this.keyMapDefaults.get(profile);
    }

    public void deleteProfile(String profile) {
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            keymapManager.deleteProfile(profile);
        }
    }

    public void changeKeymap(String profile, Map<ShortcutAction, Set<String>> actionToShortcuts) {
        this.log("changeKeymap.actionToShortcuts", actionToShortcuts.entrySet());
        HashMap<ShortcutAction, Set<String>> m = new HashMap<ShortcutAction, Set<String>>(this.getKeymap(profile));
        m.putAll(actionToShortcuts);
        this.keyMaps.put(profile, m);
        this.log("changeKeymap.m", m.entrySet());
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            keymapManager.saveKeymap(profile, m);
        }
    }

    private void log(String name, Collection items) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        LOG.fine(name);
        for (Object item : items) {
            LOG.fine("  " + item);
        }
    }

    Set<ShortcutAction> mergeActions(Collection<ShortcutAction> res, Collection<ShortcutAction> adding, String name) {
        String id;
        HashSet<ShortcutAction> result = new HashSet<ShortcutAction>();
        HashMap<String, ShortcutAction> idToAction = new HashMap<String, ShortcutAction>();
        HashMap<String, ShortcutAction> delegateIdToAction = new HashMap<String, ShortcutAction>();
        for (ShortcutAction action : res) {
            id = action.getId();
            idToAction.put(id, action);
            String delegate = action.getDelegatingActionId();
            if (delegate == null) continue;
            delegateIdToAction.put(delegate, action);
        }
        for (ShortcutAction action : adding) {
            String delegatingId;
            id = action.getId();
            if (delegateIdToAction.containsKey(id)) {
                ShortcutAction origAction = (ShortcutAction)delegateIdToAction.remove(id);
                idToAction.remove(origAction.getId());
                KeymapManager origActionKeymapManager = this.findOriginator(origAction);
                HashMap<String, ShortcutAction> ss = new HashMap<String, ShortcutAction>();
                ss.put(origActionKeymapManager.getName(), origAction);
                ss.put(name, action);
                CompoundAction compoundAction = new CompoundAction(ss);
                result.add(compoundAction);
                this.sharedActions.put(origAction, compoundAction);
                this.sharedActions.put(action, compoundAction);
                result.add(compoundAction);
            }
            if (idToAction.containsKey(delegatingId = action.getDelegatingActionId())) {
                ShortcutAction origAction = (ShortcutAction)idToAction.remove(delegatingId);
                KeymapManager origActionKeymapManager = this.findOriginator(origAction);
                HashMap<String, ShortcutAction> ss = new HashMap<String, ShortcutAction>();
                ss.put(origActionKeymapManager.getName(), origAction);
                ss.put(name, action);
                CompoundAction compoundAction = new CompoundAction(ss);
                result.add(compoundAction);
                this.sharedActions.put(origAction, compoundAction);
                this.sharedActions.put(action, compoundAction);
                result.add(compoundAction);
            }
            if (this.sharedActions.containsKey(action)) continue;
            result.add(action);
        }
        result.addAll(idToAction.values());
        return result;
    }

    private KeymapManager findOriginator(ShortcutAction a) {
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            if (a.getKeymapManagerInstance(keymapManager.getName()) == null) continue;
            return keymapManager;
        }
        return null;
    }

    Map<ShortcutAction, Set<String>> mergeShortcuts(Map<ShortcutAction, Set<String>> res, Map<ShortcutAction, Set<String>> adding) {
        for (ShortcutAction action : adding.keySet()) {
            Set<String> shortcuts = adding.get(action);
            if (shortcuts.isEmpty()) continue;
            if (this.sharedActions.containsKey(action)) {
                action = this.sharedActions.get(action);
            }
            res.put(action, shortcuts);
        }
        return res;
    }
}

