/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.modules.options.keymap.KeymapListRenderer;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class KeymapPanel
extends JPanel
implements ActionListener,
TreeSelectionListener,
ListSelectionListener {
    private boolean listen = false;
    private JButton bAdd;
    private JButton bDelete;
    private JButton bDuplicate;
    private JButton bRemove;
    private JComboBox cbProfile;
    private JLabel lActions;
    private JLabel lProfile;
    private JLabel lShortcuts;
    private JList liShortcuts;
    private JScrollPane spActions;
    private JScrollPane spShortcuts;
    private JTree tActions;
    private boolean initialized = false;
    private KeymapViewModel model;

    public KeymapPanel() {
        this.initComponents();
        KeymapPanel.loc(this.bDuplicate, "Duplicate");
        KeymapPanel.loc(this.bDelete, "Delete");
        this.liShortcuts.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_Shortcuts"));
        this.liShortcuts.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_Shortcuts"));
        this.tActions.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_Actions"));
        this.tActions.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_Actions"));
        this.cbProfile.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_Profiles"));
        this.cbProfile.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_Profiles"));
        this.bDuplicate.addActionListener(this);
        this.bDelete.addActionListener(this);
        this.tActions.setRootVisible(false);
        this.tActions.setShowsRootHandles(true);
        this.tActions.addTreeSelectionListener(this);
        this.cbProfile.addActionListener(this);
        KeymapPanel.loc(this.bAdd, "Add_Shortcut");
        KeymapPanel.loc(this.bRemove, "Remove_Shortcut");
        this.bAdd.addActionListener(this);
        this.bRemove.addActionListener(this);
        this.liShortcuts.addListSelectionListener(this);
        this.bAdd.setEnabled(false);
        this.bRemove.setEnabled(false);
        KeymapPanel.loc(this.lShortcuts, "Shortcuts");
        this.lShortcuts.setLabelFor(this.liShortcuts);
        KeymapPanel.loc(this.lActions, "Actions");
        this.lActions.setLabelFor(this.tActions);
    }

    private void initComponents() {
        this.lProfile = new JLabel();
        this.cbProfile = new JComboBox();
        this.bDuplicate = new JButton();
        this.bDelete = new JButton();
        this.lActions = new JLabel();
        this.spActions = new JScrollPane();
        this.tActions = new JTree();
        this.lShortcuts = new JLabel();
        this.spShortcuts = new JScrollPane();
        this.liShortcuts = new JList();
        this.bAdd = new JButton();
        this.bRemove = new JButton();
        this.lProfile.setText("Profile:");
        this.bDuplicate.setText("Duplicate...");
        this.bDelete.setText("Delete");
        this.lActions.setText("Actions:");
        this.spActions.setViewportView(this.tActions);
        this.lShortcuts.setText("Shortcuts:");
        this.spShortcuts.setViewportView(this.liShortcuts);
        this.bAdd.setText("Add...");
        this.bRemove.setText("Remove");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lProfile).addPreferredGap(0).add((Component)this.cbProfile, 0, 139, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bDuplicate)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.spShortcuts, -2, 175, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.bRemove).add((Component)this.bAdd)))).addPreferredGap(0).add((Component)this.bDelete)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lActions).addContainerGap()).add((Component)this.spActions, -1, 367, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lShortcuts).addContainerGap()));
        layout.linkSize(new Component[]{this.bAdd, this.bRemove}, 1);
        layout.linkSize(new Component[]{this.bDelete, this.bDuplicate}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.bDelete).add((Component)this.bDuplicate).add((Component)this.lProfile).add((Component)this.cbProfile, -2, -1, -2)).addPreferredGap(0).add((Component)this.lActions).addPreferredGap(0).add((Component)this.spActions, -1, 168, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lShortcuts).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bAdd).addPreferredGap(0).add((Component)this.bRemove)).add((Component)this.spShortcuts, 0, 52, Short.MAX_VALUE))));
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        Object source = e.getSource();
        if (source == this.bAdd) {
            Object action = this.tActions.getSelectionPath().getLastPathComponent();
            String shortcut = this.getModel().showShortcutsDialog();
            if (shortcut == null) {
                return;
            }
            this.getModel().addShortcut(this.tActions.getSelectionPath(), shortcut);
            this.selectAction(action);
            if (this.liShortcuts.getModel().getSize() > 0) {
                this.liShortcuts.setSelectedIndex(0);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KeymapPanel.this.liShortcuts.requestFocus();
                }
            });
        } else if (source == this.bRemove) {
            int index = this.liShortcuts.getSelectedIndex();
            Object action = this.tActions.getSelectionPath().getLastPathComponent();
            String shortcut = (String)this.liShortcuts.getSelectedValue();
            this.getModel().removeShortcut(this.tActions.getSelectionPath(), shortcut);
            this.selectAction(action);
            if (this.liShortcuts.getModel().getSize() > index) {
                this.liShortcuts.setSelectedIndex(index);
            } else if (this.liShortcuts.getModel().getSize() > 0) {
                this.liShortcuts.setSelectedIndex(0);
            }
        } else if (source == this.bDelete) {
            this.deleteCurrentProfile();
        } else if (source == this.cbProfile) {
            String profile = (String)this.cbProfile.getSelectedItem();
            this.getModel().setCurrentProfile(profile);
            if (this.getModel().isCustomProfile(profile)) {
                KeymapPanel.loc(this.bDelete, "Delete");
            } else {
                KeymapPanel.loc(this.bDelete, "Restore");
            }
            this.refreshAction();
        } else if (source == this.bDuplicate) {
            NotifyDescriptor.InputLine il = new NotifyDescriptor.InputLine(KeymapPanel.loc("CTL_Create_New_Profile_Message"), KeymapPanel.loc("CTL_Create_New_Profile_Title"));
            il.setInputText((String)this.cbProfile.getSelectedItem());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)il);
            if (il.getValue() == NotifyDescriptor.OK_OPTION) {
                String newProfile = il.getInputText();
                Iterator it = this.getModel().getProfiles().iterator();
                while (it.hasNext()) {
                    if (!newProfile.equals(it.next())) continue;
                    NotifyDescriptor.Message md = new NotifyDescriptor.Message((Object)KeymapPanel.loc("CTL_Duplicate_Profile_Name"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)md);
                    return;
                }
                this.getModel().cloneProfile(newProfile);
                this.cbProfile.addItem(il.getInputText());
                this.cbProfile.setSelectedItem(il.getInputText());
            }
            return;
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (!this.listen) {
            return;
        }
        this.refreshAction();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.listen) {
            return;
        }
        int i = this.liShortcuts.getSelectedIndex();
        if (i < 0) {
            this.bRemove.setEnabled(false);
            return;
        }
        this.bRemove.setEnabled(true);
    }

    void update() {
        if (!this.initialized) {
            this.initialized = true;
            this.listen = false;
            this.tActions.setCellRenderer(new KeymapListRenderer(this.getModel()));
            this.tActions.setModel(this.getModel());
            List keymaps = this.getModel().getProfiles();
            this.cbProfile.removeAllItems();
            int k = keymaps.size();
            for (int i = 0; i < k; ++i) {
                this.cbProfile.addItem(keymaps.get(i));
            }
            this.listen = true;
        }
        this.cbProfile.setSelectedItem(this.getModel().getCurrentProfile());
    }

    private void deleteCurrentProfile() {
        String currentProfile = (String)this.cbProfile.getSelectedItem();
        this.getModel().deleteProfile(currentProfile);
        if (this.getModel().isCustomProfile(currentProfile)) {
            this.cbProfile.removeItem(currentProfile);
            this.cbProfile.setSelectedIndex(0);
        }
    }

    void applyChanges() {
        if (!this.initialized) {
            return;
        }
        this.getModel().apply();
    }

    void cancel() {
        if (this.model == null) {
            return;
        }
        this.model.cancel();
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.getModel().isChanged();
    }

    synchronized KeymapViewModel getModel() {
        if (this.model == null) {
            this.model = new KeymapViewModel();
        }
        return this.model;
    }

    private static String loc(String key) {
        return NbBundle.getMessage(KeymapPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_" + key));
            c.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)KeymapPanel.loc("CTL_" + key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)KeymapPanel.loc("CTL_" + key));
        }
    }

    void refreshAction() {
        Object action = this.tActions.getSelectionPath() == null ? null : this.tActions.getSelectionPath().getLastPathComponent();
        this.selectAction(action);
        if (this.liShortcuts.getModel().getSize() > 0) {
            this.liShortcuts.setSelectedIndex(0);
        }
    }

    void selectAction(Object action) {
        if (action == null || action instanceof String) {
            this.liShortcuts.setModel(new DefaultListModel());
            this.bAdd.setEnabled(false);
            this.bRemove.setEnabled(false);
            return;
        }
        this.bAdd.setEnabled(true);
        this.bRemove.setEnabled(false);
        final String[] shortcuts = this.getModel().getShortcuts((ShortcutAction)action);
        this.liShortcuts.setModel(new AbstractListModel(){

            public int getSize() {
                return shortcuts.length;
            }

            public Object getElementAt(int i) {
                return shortcuts[i];
            }
        });
    }
}

