/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.modules.options.keymap.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ShortcutsDialog
extends JPanel {
    private Listener listener = null;
    private JButton bTab = new JButton();
    private JButton bClear = new JButton();
    private ShortcutsFinder f = null;
    private JLabel lConflict;
    private JLabel lShortcut;
    private JTextField tfShortcut;

    void init(ShortcutsFinder f) {
        this.f = f;
        ShortcutsDialog.loc(this.lShortcut, "Shortcut");
        this.lConflict.setForeground(Color.red);
        ShortcutsDialog.loc(this.bTab, "CTL_Tab");
        ShortcutsDialog.loc(this.bClear, "CTL_Clear");
        this.tfShortcut.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        this.tfShortcut.setFocusTraversalKeys(3, Collections.EMPTY_SET);
        this.tfShortcut.setFocusTraversalKeys(2, Collections.EMPTY_SET);
        this.listener = new Listener();
        this.tfShortcut.addKeyListener(this.listener);
    }

    private static String loc(String key) {
        return NbBundle.getMessage(ShortcutsDialog.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)ShortcutsDialog.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)ShortcutsDialog.loc(key));
        }
    }

    public ShortcutsDialog() {
        this.initComponents();
    }

    public Listener getListener() {
        return this.listener;
    }

    public JLabel getLShortcut() {
        return this.lShortcut;
    }

    public JTextField getTfShortcut() {
        return this.tfShortcut;
    }

    private void initComponents() {
        this.lShortcut = new JLabel();
        this.tfShortcut = new JTextField();
        this.lConflict = new JLabel();
        this.lShortcut.setText("Shortcut:");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lConflict, -1, 449, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lShortcut).addPreferredGap(0).add((Component)this.tfShortcut, -1, 400, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lShortcut).add((Component)this.tfShortcut, -2, -1, -2)).addPreferredGap(0).add((Component)this.lConflict).addContainerGap(25, Short.MAX_VALUE)));
    }

    public JButton getBTab() {
        return this.bTab;
    }

    public JButton getBClear() {
        return this.bClear;
    }

    class Listener
    implements ActionListener,
    KeyListener {
        private KeyStroke backspaceKS = KeyStroke.getKeyStroke(8, 0);
        private KeyStroke tabKS = KeyStroke.getKeyStroke(9, 0);
        private String key = "";

        Listener() {
        }

        public void keyTyped(KeyEvent e) {
            e.consume();
        }

        /*
         * Unable to fully structure code
         */
        public void keyPressed(KeyEvent e) {
            keyStroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
            if (e.getKeyCode() == 16) ** GOTO lbl-1000
            if (e.getKeyCode() == 17) ** GOTO lbl-1000
            if (e.getKeyCode() == 18) ** GOTO lbl-1000
            if (e.getKeyCode() == 157) ** GOTO lbl-1000
            if (e.getKeyCode() != 65406) {
                v0 = true;
            } else lbl-1000:
            // 5 sources

            {
                v0 = add = false;
            }
            if (keyStroke.equals(this.backspaceKS) && !this.key.equals("")) {
                i = this.key.lastIndexOf(32);
                this.key = i < 0 ? "" : this.key.substring(0, i);
                ShortcutsDialog.this.getTfShortcut().setText(this.key);
            } else {
                this.addKeyStroke(keyStroke, add);
            }
            if (add) {
                this.updateWarning();
            }
            e.consume();
        }

        public void keyReleased(KeyEvent e) {
            e.consume();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ShortcutsDialog.this.getBClear()) {
                this.key = "";
                ShortcutsDialog.this.getTfShortcut().setText(this.key);
            } else if (e.getSource() == ShortcutsDialog.this.getBTab()) {
                this.addKeyStroke(this.tabKS, true);
            }
        }

        private void updateWarning() {
            ShortcutAction action = ShortcutsDialog.this.f.findActionForShortcut(ShortcutsDialog.this.getTfShortcut().getText());
            if (action != null) {
                ShortcutsDialog.this.lConflict.setText(MessageFormat.format(ShortcutsDialog.loc("Shortcut_Conflict"), action.getDisplayName()));
            } else {
                ShortcutsDialog.this.lConflict.setText("");
            }
        }

        private void addKeyStroke(KeyStroke keyStroke, boolean add) {
            String k = Utils.getKeyStrokeAsText(keyStroke);
            if (this.key.equals("")) {
                ShortcutsDialog.this.getTfShortcut().setText(k);
                if (add) {
                    this.key = k;
                }
            } else {
                ShortcutsDialog.this.getTfShortcut().setText(this.key + " " + k);
                if (add) {
                    this.key = this.key + " " + k;
                }
            }
        }
    }
}

