/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.NbLocalizer;
import org.netbeans.modules.editor.options.AllOptions;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.AnnotationTypesFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.cookies.EditorCookie;
import org.openide.modules.ModuleInstall;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openidex.search.SearchHistory;
import org.openidex.search.SearchPattern;

public class EditorModule
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger(EditorModule.class.getName());
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.kits");
    private PropertyChangeListener searchSelectedPatternListener;
    private PropertyChangeListener editorHistoryChangeListener;

    public void restored() {
        LocaleSupport.addLocalizer((LocaleSupport.Localizer)new NbLocalizer(AllOptions.class));
        LocaleSupport.addLocalizer((LocaleSupport.Localizer)new NbLocalizer(BaseKit.class));
        AnnotationTypes.getTypes().registerLoader(new AnnotationTypes.Loader(){

            public void loadTypes() {
                AnnotationTypesFolder.getAnnotationTypesFolder();
            }

            public void loadSettings() {
                Boolean b;
                BaseOptions bo = (BaseOptions)BaseOptions.findObject(BaseOptions.class, (boolean)true);
                Integer i = (Integer)bo.getSettingValue("backgroundGlyphAlpha");
                if (i != null) {
                    AnnotationTypes.getTypes().setBackgroundGlyphAlpha(i.intValue());
                }
                if ((b = (Boolean)bo.getSettingValue("backgroundDrawing")) != null) {
                    AnnotationTypes.getTypes().setBackgroundDrawing(b);
                }
                if ((b = (Boolean)bo.getSettingValue("combineGlyphs")) != null) {
                    AnnotationTypes.getTypes().setCombineGlyphs(b);
                }
                if ((b = (Boolean)bo.getSettingValue("glyphsOverLineNumbers")) != null) {
                    AnnotationTypes.getTypes().setGlyphsOverLineNumbers(b);
                }
                if ((b = (Boolean)bo.getSettingValue("showGlyphGutter")) != null) {
                    AnnotationTypes.getTypes().setShowGlyphGutter(b);
                }
            }

            public void saveType(AnnotationType type) {
                AnnotationTypesFolder.getAnnotationTypesFolder().saveAnnotationType(type);
            }

            public void saveSetting(String settingName, Object value) {
                BaseOptions bo = (BaseOptions)BaseOptions.findObject(BaseOptions.class, (boolean)true);
                bo.setSettingValue(settingName, value);
            }
        });
        this.initAndCheckEditorKitTypeRegistry("text/plain", null);
        this.initAndCheckEditorKitTypeRegistry("text/html", HTMLEditorKit.class.getName());
        this.initAndCheckEditorKitTypeRegistry("text/rtf", RTFEditorKit.class.getName());
        this.initAndCheckEditorKitTypeRegistry("application/rtf", RTFEditorKit.class.getName());
        try {
            Field keyField = JEditorPane.class.getDeclaredField("kitRegistryKey");
            keyField.setAccessible(true);
            Object key = keyField.get(JEditorPane.class);
            Class<?> appContextClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("sun.awt.AppContext");
            Method getAppContext = appContextClass.getDeclaredMethod("getAppContext", new Class[0]);
            Method get = appContextClass.getDeclaredMethod("get", Object.class);
            Method put = appContextClass.getDeclaredMethod("put", Object.class, Object.class);
            Object appContext = getAppContext.invoke(null, new Object[0]);
            Hashtable kitMapping = (Hashtable)get.invoke(appContext, key);
            put.invoke(appContext, key, new HackMap(kitMapping));
        }
        catch (Throwable t) {
            if (debug) {
                LOG.log(Level.WARNING, "Can't hack in to the JEditorPane's registry for kits.", t);
            }
            LOG.log(Level.WARNING, "Can't hack in to the JEditorPane's registry for kits.");
        }
        this.searchSelectedPatternListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null) {
                    return;
                }
                FindSupport fs = FindSupport.getFindSupport();
                if ("last-selected".equals(evt.getPropertyName())) {
                    SearchPattern sp = SearchHistory.getDefault().getLastSelected();
                    if (sp == null) {
                        return;
                    }
                    FindSupport.SearchPatternWrapper spw = new FindSupport.SearchPatternWrapper(sp.getSearchExpression(), sp.isWholeWords(), sp.isMatchCase(), sp.isRegExp());
                    fs.setLastSelected(spw);
                } else if ("add-to-history".equals(evt.getPropertyName())) {
                    List searchPatterns = SearchHistory.getDefault().getSearchPatterns();
                    ArrayList<FindSupport.SearchPatternWrapper> history = new ArrayList<FindSupport.SearchPatternWrapper>();
                    for (int i = 0; i < searchPatterns.size(); ++i) {
                        SearchPattern sptr = (SearchPattern)searchPatterns.get(i);
                        FindSupport.SearchPatternWrapper spwrap = new FindSupport.SearchPatternWrapper(sptr.getSearchExpression(), sptr.isWholeWords(), sptr.isMatchCase(), sptr.isRegExp());
                        history.add(spwrap);
                    }
                    fs.setHistory(history);
                }
            }
        };
        this.editorHistoryChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null || !"find-history-prop".equals(evt.getPropertyName())) {
                    return;
                }
                FindSupport.SearchPatternWrapper spw = (FindSupport.SearchPatternWrapper)evt.getNewValue();
                SearchPattern spLast = SearchHistory.getDefault().getLastSelected();
                if (spw == null || spw.getSearchExpression() == null || "".equals(spw.getSearchExpression())) {
                    return;
                }
                SearchPattern sp = SearchPattern.create((String)spw.getSearchExpression(), (boolean)spw.isWholeWords(), (boolean)spw.isMatchCase(), (boolean)spw.isRegExp());
                if (sp == null || sp.equals((Object)spLast)) {
                    return;
                }
                SearchHistory.getDefault().add(sp);
                SearchHistory.getDefault().setLastSelected(sp);
            }
        };
        SearchHistory.getDefault().addPropertyChangeListener(this.searchSelectedPatternListener);
        FindSupport.getFindSupport().addPropertyChangeListener(this.editorHistoryChangeListener);
    }

    public void uninstalled() {
        AllOptionsFolder.unregisterModuleRegListener();
        try {
            Field keyField = JEditorPane.class.getDeclaredField("kitRegistryKey");
            keyField.setAccessible(true);
            Object key = keyField.get(JEditorPane.class);
            Class<?> appContextClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("sun.awt.AppContext");
            Method getAppContext = appContextClass.getDeclaredMethod("getAppContext", new Class[0]);
            Method get = appContextClass.getDeclaredMethod("get", Object.class);
            Method put = appContextClass.getDeclaredMethod("put", Object.class, Object.class);
            Method remove = appContextClass.getDeclaredMethod("remove", Object.class, Object.class);
            Object appContext = getAppContext.invoke(null, new Object[0]);
            Hashtable kitMapping = (Hashtable)get.invoke(appContext, key);
            if (kitMapping instanceof HackMap) {
                if (((HackMap)kitMapping).getOriginal() != null) {
                    put.invoke(appContext, key, new HackMap(kitMapping));
                } else {
                    remove.invoke(appContext, key);
                }
            }
        }
        catch (Throwable t) {
            if (debug) {
                LOG.log(Level.WARNING, "Can't release the hack from the JEditorPane's registry for kits.", t);
            }
            LOG.log(Level.WARNING, "Can't release the hack from the JEditorPane's registry for kits.");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HashSet set = new HashSet();
                set.addAll(TopComponent.getRegistry().getOpened());
                for (TopComponent topComp : set) {
                    Node[] arr;
                    if (!(topComp instanceof CloneableEditor) || (arr = topComp.getActivatedNodes()) == null) continue;
                    for (int i = 0; i < arr.length; ++i) {
                        JEditorPane[] pane;
                        EditorCookie ec = (EditorCookie)arr[i].getCookie(EditorCookie.class);
                        if (ec == null || (pane = ec.getOpenedPanes()) == null) continue;
                        for (int j = 0; j < pane.length; ++j) {
                            if (!(pane[j].getEditorKit() instanceof BaseKit)) continue;
                            topComp.close();
                        }
                    }
                }
            }
        });
    }

    private void initAndCheckEditorKitTypeRegistry(String mimeType, String expectedKitClass) {
        String kitClass = JEditorPane.getEditorKitClassNameForContentType(mimeType);
        if (kitClass == null) {
            LOG.log(Level.WARNING, "Can't find JDK editor kit class for " + mimeType);
        } else if (expectedKitClass != null && !expectedKitClass.equals(kitClass)) {
            LOG.log(Level.WARNING, "Wrong JDK editor kit class for " + mimeType + ". Expecting: " + expectedKitClass + ", but was: " + kitClass);
        }
    }

    private static final class DebugHashtable
    extends Hashtable {
        DebugHashtable(Hashtable h) {
            if (h != null) {
                this.putAll(h);
                LOG.log(Level.INFO, "Existing kit classNames mappings: " + this);
            }
        }

        public Object put(Object key, Object value) {
            Object ret = super.put(key, value);
            LOG.log(Level.INFO, "registering mimeType=" + key + " -> kitClassName=" + value + " original was " + ret);
            return ret;
        }

        public Object remove(Object key) {
            Object ret = super.remove(key);
            LOG.log(Level.INFO, "removing kitClassName=" + ret + " for mimeType=" + key);
            return ret;
        }
    }

    private static class HackMap
    extends Hashtable {
        private Hashtable delegate;

        HackMap(Hashtable h) {
            this.delegate = h;
            if (debug) {
                LOG.log(Level.INFO, "Original kit mappings: " + h);
                try {
                    Field keyField = JEditorPane.class.getDeclaredField("kitTypeRegistryKey");
                    keyField.setAccessible(true);
                    Object key = keyField.get(JEditorPane.class);
                    Class<?> appContextClass = this.getClass().getClassLoader().loadClass("sun.awt.AppContext");
                    Method getAppContext = appContextClass.getDeclaredMethod("getAppContext", new Class[0]);
                    Method get = appContextClass.getDeclaredMethod("get", Object.class);
                    Method put = appContextClass.getDeclaredMethod("put", Object.class, Object.class);
                    Object appContext = getAppContext.invoke(null, new Object[0]);
                    Hashtable kitTypeMapping = (Hashtable)get.invoke(appContext, key);
                    if (kitTypeMapping != null) {
                        put.invoke(appContext, key, new DebugHashtable(kitTypeMapping));
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Can't hack in to the JEditorPane's registry for kit types.", t);
                }
            }
        }

        private String getKitClassName(String type) {
            try {
                Field keyField = JEditorPane.class.getDeclaredField("kitTypeRegistryKey");
                keyField.setAccessible(true);
                Object key = keyField.get(JEditorPane.class);
                Class<?> appContextClass = this.getClass().getClassLoader().loadClass("sun.awt.AppContext");
                Method getAppContext = appContextClass.getDeclaredMethod("getAppContext", new Class[0]);
                Method get = appContextClass.getDeclaredMethod("get", Object.class);
                Object appContext = getAppContext.invoke(null, new Object[0]);
                Hashtable kitTypeMapping = (Hashtable)get.invoke(appContext, key);
                if (kitTypeMapping != null) {
                    return (String)kitTypeMapping.get(type);
                }
            }
            catch (Throwable t) {
                if (debug) {
                    LOG.log(Level.WARNING, "Can't hack in to the JEditorPane's registry for kit types.", t);
                }
                LOG.log(Level.WARNING, "Can't hack in to the JEditorPane's registry for kit types.");
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object key) {
            Class<Settings> clazz = Settings.class;
            synchronized (Settings.class) {
                if (debug) {
                    LOG.log(Level.INFO, "HackMap.get key=" + key);
                }
                Object retVal = null;
                if (this.delegate != null) {
                    retVal = this.delegate.get(key);
                    if (debug && retVal != null) {
                        LOG.log(Level.INFO, "Found cached instance kit=" + retVal + " for mimeType=" + key);
                    }
                }
                if (key instanceof String) {
                    String mimeType = (String)key;
                    if (retVal == null || this.shouldUseNbKit(retVal.getClass().getName(), mimeType)) {
                        EditorKit kit;
                        String kitClassName = this.getKitClassName(mimeType);
                        if (debug) {
                            LOG.log(Level.INFO, "Found kitClassName=" + kitClassName + " for mimeType=" + mimeType);
                        }
                        if ((kitClassName == null || this.shouldUseNbKit(kitClassName, mimeType)) && (kit = this.findKit(mimeType)) != null) {
                            retVal = kit;
                            if (debug) {
                                LOG.log(Level.INFO, "Found kit=" + retVal + " in xml layers for mimeType=" + mimeType);
                            }
                        }
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return retVal;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object key, Object value) {
            Class<Settings> clazz = Settings.class;
            synchronized (Settings.class) {
                if (debug) {
                    LOG.log(Level.INFO, "HackMap.put key=" + key + " value=" + value);
                }
                if (this.delegate == null) {
                    this.delegate = new Hashtable();
                }
                Object ret = this.delegate.put(key, value);
                if (debug) {
                    LOG.log(Level.INFO, "registering mimeType=" + key + " -> kitInstance=" + value + " original was " + ret);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object key) {
            Class<Settings> clazz = Settings.class;
            synchronized (Settings.class) {
                Object ret;
                if (debug) {
                    LOG.log(Level.INFO, "HackMap.remove key=" + key);
                }
                Object v0 = ret = this.delegate != null ? this.delegate.remove(key) : null;
                if (debug) {
                    LOG.log(Level.INFO, "removing kitInstance=" + ret + " for mimeType=" + key);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ret;
            }
        }

        Hashtable getOriginal() {
            return this.delegate;
        }

        private boolean shouldUseNbKit(String kitClass, String mimeType) {
            if (mimeType.startsWith("text/html") || mimeType.startsWith("text/rtf") || mimeType.startsWith("application/rtf")) {
                return false;
            }
            return kitClass.startsWith("javax.swing.");
        }

        private EditorKit findKit(String mimeType) {
            Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType));
            EditorKit kit = (EditorKit)lookup.lookup(EditorKit.class);
            return kit == null ? null : (EditorKit)kit.clone();
        }
    }
}

