/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.impl.ToolbarActionsProvider;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class NbEditorToolBar
extends JToolBar
implements SettingsChangeListener {
    private static final boolean debugSort = Boolean.getBoolean("netbeans.debug.editor.toolbar.sort");
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final Lookup NO_ACTION_CONTEXT = Lookups.fixed((Object[])new Object[0]);
    private FileChangeListener moduleRegListener;
    private static final Runnable returnFocusRunnable = new Runnable(){

        public void run() {
            JTextComponent c = Utilities.getLastActiveComponent();
            if (c != null) {
                ((Component)c).requestFocus();
            }
        }
    };
    private static final ActionListener sharedActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            SwingUtilities.invokeLater(returnFocusRunnable);
        }
    };
    private static final MouseListener sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

        public void mouseEntered(MouseEvent evt) {
            AbstractButton button;
            Object src = evt.getSource();
            if (src instanceof AbstractButton && (button = (AbstractButton)evt.getSource()).isEnabled()) {
                button.setContentAreaFilled(true);
                button.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent evt) {
            Object src = evt.getSource();
            if (src instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)evt.getSource();
                button.setContentAreaFilled(false);
                button.setBorderPainted(false);
            }
        }

        protected void showPopup(MouseEvent evt) {
        }
    };
    private Reference componentRef;
    private boolean presentersAdded;
    private boolean addListener = true;
    private static final String NOOP_ACTION_KEY = "noop-action-key";
    private static final Action NOOP_ACTION = new NoOpAction();

    public NbEditorToolBar(JTextComponent component) {
        this.componentRef = new WeakReference<JTextComponent>(component);
        this.setFloatable(false);
        this.addMouseListener(sharedMouseListener);
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.settingsChange(null);
        this.installModulesInstallationListener();
        this.installNoOpActionMappings();
    }

    private void installNoOpActionMappings() {
        int i;
        InputMap im = this.getInputMap(1);
        KeyStroke[] keys = this.findEditorKeys("cut-to-clipboard", KeyStroke.getKeyStroke(88, 2));
        for (i = 0; i < keys.length; ++i) {
            im.put(keys[i], NOOP_ACTION_KEY);
        }
        keys = this.findEditorKeys("copy-to-clipboard", KeyStroke.getKeyStroke(67, 2));
        for (i = 0; i < keys.length; ++i) {
            im.put(keys[i], NOOP_ACTION_KEY);
        }
        keys = this.findEditorKeys("delete-next", KeyStroke.getKeyStroke(127, 0));
        for (i = 0; i < keys.length; ++i) {
            im.put(keys[i], NOOP_ACTION_KEY);
        }
        keys = this.findEditorKeys("paste-from-clipboard", KeyStroke.getKeyStroke(86, 2));
        for (i = 0; i < keys.length; ++i) {
            im.put(keys[i], NOOP_ACTION_KEY);
        }
        this.getActionMap().put(NOOP_ACTION_KEY, NOOP_ACTION);
    }

    private void installModulesInstallationListener() {
        this.moduleRegListener = new FileChangeAdapter(){

            public void fileChanged(FileEvent fe) {
                Runnable r = new Runnable(){

                    public void run() {
                        if (AllOptionsFolder.getDefault().isToolbarVisible()) {
                            NbEditorToolBar.this.checkPresentersRemoved();
                            NbEditorToolBar.this.checkPresentersAdded();
                        }
                    }
                };
                Utilities.runInEventDispatchThread((Runnable)r);
            }
        };
        FileObject moduleRegistry = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
        if (moduleRegistry != null) {
            moduleRegistry.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.moduleRegListener, (Object)moduleRegistry));
        }
    }

    public String getUIClassID() {
        if (UIManager.get("Nb.Toolbar.ui") != null) {
            return "Nb.Toolbar.ui";
        }
        return super.getUIClassID();
    }

    public String getName() {
        return "editorToolbar";
    }

    public void setUI(ToolBarUI ui) {
        this.addListener = false;
        super.setUI(ui);
        this.addListener = true;
    }

    public synchronized void addMouseListener(MouseListener l) {
        if (this.addListener) {
            super.addMouseListener(l);
        }
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        if (this.addListener) {
            super.addMouseMotionListener(l);
        }
    }

    public void settingsChange(SettingsChangeEvent evt) {
        final boolean visible = NbEditorToolBar.isToolBarVisible();
        final JTextComponent c = this.getComponent();
        final boolean keyBindingsChanged = evt != null && "key-bindings".equals(evt.getSettingName()) && c != null && evt.getKitClass() == Utilities.getKitClass((JTextComponent)c);
        Runnable r = new Runnable(){

            public void run() {
                if (visible) {
                    NbEditorToolBar.this.checkPresentersAdded();
                    if (keyBindingsChanged) {
                        NbEditorToolBar.this.installNoOpActionMappings();
                        int componentCount = NbEditorToolBar.this.getComponentCount();
                        String mimeType = NbEditorUtilities.getMimeType(c);
                        Map keybsMap = NbEditorToolBar.getKeyBindingMap(mimeType);
                        Component[] comps = NbEditorToolBar.this.getComponents();
                        for (int i = 0; i < comps.length; ++i) {
                            MultiKeyBinding mkb;
                            int index;
                            String actionName;
                            JButton button;
                            Action action;
                            Component comp = comps[i];
                            if (!(comp instanceof JButton) || (action = (button = (JButton)comp).getAction()) == null || (actionName = (String)action.getValue("Name")) == null) continue;
                            String tooltipText = button.getToolTipText();
                            if (tooltipText != null && (index = tooltipText.indexOf("(")) > 0) {
                                tooltipText = tooltipText.substring(0, index - 1);
                            }
                            if ((mkb = (MultiKeyBinding)keybsMap.get(actionName)) != null) {
                                button.setToolTipText(tooltipText + " (" + NbEditorToolBar.getMnemonic(mkb) + ")");
                                continue;
                            }
                            button.setToolTipText(tooltipText);
                        }
                    }
                } else {
                    NbEditorToolBar.this.checkPresentersRemoved();
                }
                NbEditorToolBar.this.setVisible(visible);
            }
        };
        Utilities.runInEventDispatchThread((Runnable)r);
    }

    private void checkPresentersAdded() {
        if (!this.presentersAdded) {
            this.presentersAdded = true;
            this.addPresenters();
        }
    }

    private void checkPresentersRemoved() {
        this.presentersAdded = false;
        this.removeAll();
    }

    private static boolean isToolBarVisible() {
        return AllOptionsFolder.getDefault().isToolbarVisible();
    }

    private static String getMnemonic(MultiKeyBinding binding) {
        StringBuffer sb = new StringBuffer();
        if (binding.keys != null) {
            for (int i = 0; i < binding.keys.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(NbEditorToolBar.getKeyMnemonic(binding.keys[i]));
            }
        } else {
            sb.append(NbEditorToolBar.getKeyMnemonic(binding.key));
        }
        return sb.toString();
    }

    private static String getKeyMnemonic(KeyStroke key) {
        int i;
        String sk = org.openide.util.Utilities.keyToString((KeyStroke)key);
        StringBuffer sb = new StringBuffer();
        int mods = key.getModifiers();
        if ((mods & 2) != 0) {
            sb.append("Ctrl+");
        }
        if ((mods & 8) != 0) {
            sb.append("Alt+");
        }
        if ((mods & 1) != 0) {
            sb.append("Shift+");
        }
        if ((mods & 4) != 0) {
            sb.append("Meta+");
        }
        if ((i = sk.indexOf(45)) != -1) {
            sk = sk.substring(i + 1);
        }
        sb.append(sk);
        return sb.toString();
    }

    private static Map getKeyBindingMap(String mimeType) {
        HashMap<String, MultiKeyBinding> retMap = new HashMap<String, MultiKeyBinding>();
        List keybList = NbEditorToolBar.getKeyBindingList(mimeType);
        for (Object obj : keybList) {
            if (!(obj instanceof MultiKeyBinding)) continue;
            MultiKeyBinding keyb = (MultiKeyBinding)obj;
            retMap.put(keyb.actionName, keyb);
        }
        return retMap;
    }

    private static List getKeyBindingList(String mimeType) {
        List kbl;
        BaseOptions options;
        List gkbl;
        ArrayList keyBindingsList = new ArrayList();
        AllOptionsFolder aof = AllOptionsFolder.getDefault();
        if (aof != null && (gkbl = aof.getKeyBindingList()) != null) {
            keyBindingsList.addAll(gkbl);
        }
        if (mimeType != null && (options = (BaseOptions)((Object)MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType)).lookup(BaseOptions.class))) != null && (kbl = options.getKeyBindingList()) != null) {
            keyBindingsList.addAll(kbl);
        }
        return keyBindingsList;
    }

    private JTextComponent getComponent() {
        return (JTextComponent)this.componentRef.get();
    }

    /*
     * WARNING - void declaration
     */
    private void addPresenters() {
        String mimeType;
        JTextComponent c = this.getComponent();
        String string = mimeType = c == null ? null : NbEditorUtilities.getMimeType(c);
        if (mimeType == null) {
            return;
        }
        List keybindings = null;
        Lookup actionContext = null;
        ArrayList<JSeparator> items = ToolbarActionsProvider.getToolbarItems(mimeType);
        List oldTextBaseItems = ToolbarActionsProvider.getToolbarItems("text/base");
        if (oldTextBaseItems.size() > 0) {
            items = new ArrayList<JSeparator>(items);
            items.add(new JSeparator());
            items.addAll(oldTextBaseItems);
        }
        for (Object e : items) {
            void var8_8;
            void var8_15;
            Component presenter;
            void var8_13;
            void var8_11;
            EditorKit kit;
            if (e instanceof JSeparator) {
                this.addSeparator();
                continue;
            }
            if (e instanceof String && (kit = c.getUI().getEditorKit(c)) instanceof BaseKit) {
                Action a = ((BaseKit)kit).getActionByName((String)e);
                if (a == null) continue;
                Action action = a;
            }
            if (var8_11 instanceof ContextAwareAction) {
                Action caa;
                if (actionContext == null) {
                    Lookup context = NbEditorToolBar.createActionContext(c);
                    Lookup lookup = actionContext = context == null ? NO_ACTION_CONTEXT : context;
                }
                if (actionContext != NO_ACTION_CONTEXT && ((caa = ((ContextAwareAction)var8_11).createContextAwareInstance(actionContext)) instanceof Presenter.Toolbar || caa instanceof Component)) {
                    Action action = caa;
                }
            }
            if (var8_13 instanceof Presenter.Toolbar && (presenter = ((Presenter.Toolbar)var8_13).getToolbarPresenter()) != null) {
                Component component = presenter;
            }
            if (var8_15 instanceof Component) {
                this.add((Component)var8_15);
            } else {
                if (!(var8_15 instanceof Action)) continue;
                WrapperAction a = new WrapperAction(this.componentRef, (Action)var8_15);
                NbEditorToolBar.updateIcon(a);
                JButton jButton = this.add(a);
            }
            if (!(var8_8 instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)var8_8;
            this.processButton(button);
            if (keybindings == null) {
                List l = NbEditorToolBar.getKeyBindingList(mimeType);
                keybindings = l == null ? Collections.emptyList() : l;
            }
            NbEditorToolBar.updateTooltip(button, keybindings);
        }
    }

    private static void updateIcon(Action a) {
        Object icon = a.getValue("SmallIcon");
        if (icon == null) {
            Image img;
            String resourceId = (String)a.getValue("IconResource");
            if (resourceId == null) {
                resourceId = "org/netbeans/modules/editor/resources/default.gif";
            }
            if ((img = org.openide.util.Utilities.loadImage((String)resourceId)) != null) {
                a.putValue("SmallIcon", new ImageIcon(img));
            }
        }
    }

    private static void updateTooltip(AbstractButton b, List keybindings) {
        String actionName;
        Action a = b.getAction();
        String string = actionName = a == null ? null : (String)a.getValue("Name");
        if (actionName == null) {
            return;
        }
        for (Object o : keybindings) {
            if (!(o instanceof MultiKeyBinding)) continue;
            MultiKeyBinding binding = (MultiKeyBinding)o;
            if (!actionName.equals(binding.actionName)) continue;
            b.setToolTipText(b.getToolTipText() + " (" + NbEditorToolBar.getMnemonic(binding) + ")");
            break;
        }
    }

    static Lookup createActionContext(JTextComponent c) {
        DataObject dobj;
        Lookup nodeLookup = null;
        DataObject dataObject = dobj = c != null ? NbEditorUtilities.getDataObject(c.getDocument()) : null;
        if (dobj != null && dobj.isValid()) {
            nodeLookup = dobj.getNodeDelegate().getLookup();
        }
        Lookup ancestorLookup = null;
        for (Container comp = c; comp != null; comp = comp.getParent()) {
            Lookup lookup;
            if (!(comp instanceof Lookup.Provider) || (lookup = ((Lookup.Provider)comp).getLookup()) == null) continue;
            ancestorLookup = lookup;
            break;
        }
        if (nodeLookup == null) {
            return ancestorLookup;
        }
        if (ancestorLookup == null) {
            return nodeLookup;
        }
        assert (nodeLookup != null && ancestorLookup != null);
        Node node = (Node)nodeLookup.lookup(Node.class);
        boolean ancestorLookupContainsNode = ancestorLookup.lookup(new Lookup.Template(Node.class)).allInstances().contains(node);
        if (ancestorLookupContainsNode) {
            return ancestorLookup;
        }
        return new ProxyLookup(new Lookup[]{nodeLookup, ancestorLookup});
    }

    private void processButton(AbstractButton button) {
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.addActionListener(sharedActionListener);
        button.setMargin(BUTTON_INSETS);
        if (button instanceof AbstractButton) {
            button.addMouseListener(sharedMouseListener);
        }
        button.setFocusable(false);
    }

    private KeyStroke[] findEditorKeys(String editorActionName, KeyStroke defaultKey) {
        KeyStroke[] ret = new KeyStroke[]{defaultKey};
        JTextComponent comp = this.getComponent();
        if (editorActionName != null && comp != null) {
            Action a;
            EditorKit kit;
            TextUI ui = comp.getUI();
            Keymap km = comp.getKeymap();
            if (ui != null && km != null && (kit = ui.getEditorKit(comp)) instanceof BaseKit && (a = ((BaseKit)kit).getActionByName(editorActionName)) != null) {
                KeyStroke[] keys = km.getKeyStrokesForAction(a);
                if (keys != null && keys.length > 0) {
                    ret = keys;
                } else {
                    MultiKeymap km2 = ((BaseKit)kit).getKeymap();
                    KeyStroke[] keys2 = km2.getKeyStrokesForAction(a);
                    if (keys2 != null && keys2.length > 0) {
                        ret = keys2;
                    }
                }
            }
        }
        return ret;
    }

    private static final class NoOpAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static final class WrapperAction
    implements Action {
        private final Reference componentRef;
        private final Action delegate;

        WrapperAction(Reference componentRef, Action delegate) {
            this.componentRef = componentRef;
            assert (delegate != null);
            this.delegate = delegate;
        }

        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        public void putValue(String key, Object value) {
            this.delegate.putValue(key, value);
        }

        public void setEnabled(boolean b) {
            this.delegate.setEnabled(b);
        }

        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.delegate.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.delegate.removePropertyChangeListener(listener);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent c = (JTextComponent)this.componentRef.get();
            if (c != null) {
                e = new ActionEvent(c, e.getID(), e.getActionCommand());
            }
            this.delegate.actionPerformed(e);
        }
    }
}

