/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.actions.SystemAction;

public class ActionsList {
    private static final Logger LOG = Logger.getLogger(ActionsList.class.getName());
    private final List all;
    private final List actions;

    protected ActionsList(List keys) {
        this(keys, false);
    }

    protected ActionsList(List keys, boolean ignoreFolders) {
        List[] lists = ActionsList.convertImpl(keys == null ? Collections.emptyList() : keys, ignoreFolders);
        this.all = lists[0];
        this.actions = lists[1];
    }

    public List getAllInstances() {
        return this.all;
    }

    public List getActionsOnly() {
        return this.actions;
    }

    public static List convert(List keys) {
        List[] lists = ActionsList.convertImpl(keys, false);
        return lists[0];
    }

    private static List[] convertImpl(List keys, boolean ignoreFolders) {
        ArrayList<Object> all = new ArrayList<Object>();
        ArrayList<Object> actions = new ArrayList<Object>();
        for (int i = 0; i < keys.size(); ++i) {
            Object item = keys.get(i);
            DataObject dob = null;
            if (item instanceof DataObject) {
                dob = (DataObject)item;
            } else if (item instanceof FileObject) {
                try {
                    dob = DataObject.find((FileObject)((FileObject)item));
                }
                catch (DataObjectNotFoundException dnfe) {
                    // empty catch block
                }
            }
            if (dob != null) {
                InstanceCookie ic = (InstanceCookie)dob.getLookup().lookup(InstanceCookie.class);
                if (ic != null) {
                    try {
                        Object instance;
                        if (Action.class.isAssignableFrom(ic.instanceClass()) || SystemAction.class.isAssignableFrom(ic.instanceClass())) {
                            instance = ic.instanceCreate();
                            all.add(instance);
                            actions.add(instance);
                            continue;
                        }
                        if (DataFolder.class.isAssignableFrom(ic.instanceClass()) && ignoreFolders) continue;
                        instance = ic.instanceCreate();
                        all.add(instance);
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Can't instantiate object", e);
                    }
                    continue;
                }
                if (dob instanceof DataFolder) {
                    all.add(dob);
                    continue;
                }
                all.add(dob.getName());
                continue;
            }
            all.add(item);
            if (!(item instanceof Action) && !(item instanceof SystemAction)) continue;
            actions.add(item);
        }
        return new List[]{all.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(all), actions.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(actions)};
    }
}

