/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.SideBarFactory;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchBar
extends JToolBar {
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final MouseListener sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

        public void mouseEntered(MouseEvent evt) {
            AbstractButton button;
            Object src = evt.getSource();
            if (src instanceof JButton && (button = (AbstractButton)evt.getSource()).isEnabled()) {
                button.setContentAreaFilled(true);
                button.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent evt) {
            Object src = evt.getSource();
            if (src instanceof JButton) {
                AbstractButton button = (AbstractButton)evt.getSource();
                button.setContentAreaFilled(false);
                button.setBorderPainted(false);
            }
        }

        protected void showPopup(MouseEvent evt) {
        }
    };
    private JTextComponent component;
    private JButton closeButton;
    private JLabel findLabel;
    private JTextField incrementalSearchTextField;
    private JButton findNextButton;
    private JButton findPreviousButton;
    private JCheckBox matchCaseCheckBox;
    private Map findProps;

    public SearchBar(JTextComponent component) {
        this.component = component;
        this.setFloatable(false);
        this.addMouseListener(sharedMouseListener);
        Keymap keymap = component.getKeymap();
        if (keymap instanceof MultiKeymap) {
            Action[] actions;
            MultiKeymap multiKeymap = (MultiKeymap)keymap;
            for (Action action : actions = component.getActions()) {
                Action incrementalSearchBackwardAction;
                KeyStroke[] keyStrokes;
                if (action.getValue("Name").equals("incremental-search-forward")) {
                    Action incrementalSearchForwardAction = action;
                    keyStrokes = multiKeymap.getKeyStrokesForAction(incrementalSearchForwardAction);
                    if (keyStrokes == null) continue;
                    this.getInputMap(1).put(keyStrokes[0], "incremental-search-forward");
                    this.getActionMap().put("incremental-search-forward", new AbstractAction(){

                        public void actionPerformed(ActionEvent e) {
                            SearchBar.this.findNext();
                        }
                    });
                    continue;
                }
                if (!action.getValue("Name").equals("incremental-search-backward") || (keyStrokes = multiKeymap.getKeyStrokesForAction(incrementalSearchBackwardAction = action)) == null) continue;
                this.getInputMap(1).put(keyStrokes[0], "incremental-search-backward");
                this.getActionMap().put("incremental-search-backward", new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        SearchBar.this.findPrevious();
                    }
                });
            }
        }
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0, true), "loose-focus");
        this.getActionMap().put("loose-focus", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SearchBar.this.looseFocus();
            }
        });
        this.closeButton = new JButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/editor/resources/find_close.png")));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchBar.this.looseFocus();
            }
        });
        this.closeButton.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_CloseIncrementalSearchSidebar"));
        this.processButton(this.closeButton);
        this.findLabel = new JLabel(NbBundle.getMessage(SearchBar.class, (String)"CTL_Find"));
        this.incrementalSearchTextField = new JTextField(10){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.incrementalSearchTextField.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_IncrementalSearchText"));
        this.incrementalSearchTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                SearchBar.this.incrementalSearch();
            }

            public void removeUpdate(DocumentEvent e) {
                SearchBar.this.incrementalSearch();
            }
        });
        this.incrementalSearchTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SearchBar.this.looseFocus();
            }
        });
        this.incrementalSearchTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findNext();
            }
        });
        this.incrementalSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 1, true), "incremental-find-previous");
        this.incrementalSearchTextField.getActionMap().put("incremental-find-previous", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findPrevious();
            }
        });
        this.findNextButton = new JButton(NbBundle.getMessage(SearchBar.class, (String)"CTL_FindNext"), new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/editor/resources/find_next.png")));
        this.findNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findNext();
            }
        });
        this.processButton(this.findNextButton);
        this.findPreviousButton = new JButton(NbBundle.getMessage(SearchBar.class, (String)"CTL_FindPrevious"), new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/editor/resources/find_previous.png")));
        this.findPreviousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findPrevious();
            }
        });
        this.processButton(this.findPreviousButton);
        this.matchCaseCheckBox = new JCheckBox(NbBundle.getMessage(SearchBar.class, (String)"CTL_MatchCase"), false);
        this.matchCaseCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchBar.this.incrementalSearchTextField.requestFocusInWindow();
            }
        });
        this.processButton(this.matchCaseCheckBox);
        this.findProps = new HashMap();
        this.findProps.put("find-highlight-search", Boolean.TRUE);
        this.findProps.put("find-whole-words", Boolean.FALSE);
        this.findProps.put("find-wrap-search", Boolean.TRUE);
        this.add(this.closeButton);
        this.addSeparator();
        this.add(this.findLabel);
        this.add(this.incrementalSearchTextField);
        this.addSeparator();
        this.add(this.findPreviousButton);
        this.add(this.findNextButton);
        this.add(this.matchCaseCheckBox);
        JPanel padding = new JPanel();
        padding.setOpaque(false);
        this.add(padding);
        this.setVisible(false);
    }

    @Override
    public String getUIClassID() {
        if (UIManager.get("Nb.Toolbar.ui") != null) {
            return "Nb.Toolbar.ui";
        }
        return super.getUIClassID();
    }

    @Override
    public String getName() {
        return "editorSearchBar";
    }

    private void gainFocus() {
        this.setVisible(true);
        this.incrementalSearchTextField.requestFocusInWindow();
        if (this.incrementalSearchTextField.getText().length() > 0) {
            this.incrementalSearchTextField.selectAll();
        }
    }

    private void looseFocus() {
        this.setVisible(false);
        if (this.component.isEnabled()) {
            this.component.requestFocusInWindow();
        }
    }

    private void incrementalSearch() {
        String incrementalSearchText = this.incrementalSearchTextField.getText();
        FindSupport findSupport = FindSupport.getFindSupport();
        this.findProps.put("find-what", incrementalSearchText);
        this.findProps.put("find-match-case", this.matchCaseCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        this.findProps.put("find-backward-search", Boolean.FALSE);
        this.findProps.put("find-inc-search", Boolean.TRUE);
        int caretPosition = this.component.getCaretPosition();
        if (findSupport.incSearch(this.findProps, caretPosition)) {
            this.incrementalSearchTextField.setForeground(null);
        } else {
            this.incrementalSearchTextField.setForeground(Color.red);
        }
    }

    private void findNext() {
        this.find(true);
    }

    private void findPrevious() {
        this.find(false);
    }

    private void find(boolean next) {
        String incrementalSearchText = this.incrementalSearchTextField.getText();
        FindSupport findSupport = FindSupport.getFindSupport();
        this.findProps.put("find-what", incrementalSearchText);
        this.findProps.put("find-match-case", this.matchCaseCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        this.findProps.put("find-backward-search", Boolean.FALSE);
        this.findProps.put("find-inc-search", Boolean.FALSE);
        if (findSupport.find(this.findProps, !next)) {
            this.incrementalSearchTextField.setForeground(null);
        } else {
            this.incrementalSearchTextField.setForeground(Color.red);
        }
    }

    private void processButton(AbstractButton button) {
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setMargin(BUTTON_INSETS);
        if (button instanceof JButton) {
            button.addMouseListener(sharedMouseListener);
        }
        button.setFocusable(false);
    }

    private static <T> T findComponent(Container container, Class<T> componentClass, int depth) {
        if (depth > 0) {
            for (Component c : container.getComponents()) {
                Component target;
                if (componentClass.isAssignableFrom(c.getClass())) {
                    target = c;
                    return (T)target;
                }
                if (!(c instanceof Container) || (target = SearchBar.findComponent((Container)c, componentClass, depth - 1)) == null) continue;
                return (T)target;
            }
        }
        return null;
    }

    public static final class Factory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent target) {
            return new SearchBar(target);
        }
    }

    public static class IncrementalSearchBackwardAction
    extends BaseAction {
        public static final String NAME = "incremental-search-backward";
        static final long serialVersionUID = -1L;

        public IncrementalSearchBackwardAction() {
            super(NAME, 32);
            this.putValue("ShortDescription", NbBundle.getMessage(IncrementalSearchBackwardAction.class, (String)NAME));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            SearchBar issb;
            JComponent comp;
            if (target != null && (comp = org.netbeans.editor.Utilities.getEditorUI((JTextComponent)target).getExtComponent()) != null && (issb = (SearchBar)SearchBar.findComponent(comp, SearchBar.class, 5)) != null) {
                issb.gainFocus();
            }
        }
    }

    public static class IncrementalSearchForwardAction
    extends BaseAction {
        public static final String NAME = "incremental-search-forward";
        static final long serialVersionUID = -1L;

        public IncrementalSearchForwardAction() {
            super(NAME, 32);
            this.putValue("ShortDescription", NbBundle.getMessage(IncrementalSearchForwardAction.class, (String)NAME));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            SearchBar issb;
            JComponent comp;
            if (target != null && (comp = org.netbeans.editor.Utilities.getEditorUI((JTextComponent)target).getExtComponent()) != null && (issb = (SearchBar)SearchBar.findComponent(comp, SearchBar.class, 5)) != null) {
                issb.gainFocus();
            }
        }
    }
}

