/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.impl.actions.NavigationHistoryBackAction;
import org.netbeans.modules.editor.lib.NavigationHistory;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class NavigationHistoryForwardAction
extends BaseAction
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(NavigationHistoryForwardAction.class.getName());

    public NavigationHistoryForwardAction() {
        super("jump-list-next");
        this.putValue("IconResource", "org/netbeans/modules/editor/resources/navigate_forward.png");
        this.update();
        NavigationHistory nav = NavigationHistory.getNavigations();
        nav.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)nav));
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        NavigationHistory.Waypoint wpt = NavigationHistory.getNavigations().navigateForward();
        if (wpt != null) {
            NavigationHistoryBackAction.show(wpt);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    private void update() {
        List waypoints = NavigationHistory.getNavigations().getNextWaypoints();
        if (!waypoints.isEmpty()) {
            NavigationHistory.Waypoint wpt = (NavigationHistory.Waypoint)waypoints.get(0);
            String fileName = NavigationHistoryBackAction.getWaypointName(wpt);
            if (fileName != null) {
                this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryForwardAction.class, (String)"NavigationHistoryForwardAction_Tooltip", (Object)fileName));
            } else {
                this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryForwardAction.class, (String)"NavigationHistoryForwardAction_Tooltip_simple"));
            }
            this.setEnabled(true);
        } else {
            this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryForwardAction.class, (String)"NavigationHistoryForwardAction_Tooltip_simple"));
            this.setEnabled(false);
        }
    }
}

