/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.impl.actions.NavigationHistoryBackAction;
import org.netbeans.modules.editor.lib.NavigationHistory;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class NavigationHistoryLastEditAction
extends BaseAction
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(NavigationHistoryLastEditAction.class.getName());

    public NavigationHistoryLastEditAction() {
        super("jump-list-last-edit");
        this.putValue("IconResource", "org/netbeans/modules/editor/resources/navigate_last_edit.png");
        this.update();
        NavigationHistory nav = NavigationHistory.getEdits();
        nav.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)nav));
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        NavigationHistory nav = NavigationHistory.getEdits();
        Object wpt = nav.getCurrentWaypoint();
        if (wpt != null) {
            wpt = this.isStandingThere(target, (NavigationHistory.Waypoint)wpt) ? nav.navigateBack() : null;
        }
        if (wpt == null) {
            wpt = nav.navigateLast();
        }
        if (wpt != null) {
            NavigationHistoryBackAction.show(wpt);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    private void update() {
        NavigationHistory nav = NavigationHistory.getEdits();
        this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryLastEditAction.class, (String)"NavigationHistoryLastEditAction_Tooltip_simple"));
        this.setEnabled(nav.hasNextWaypoints() || nav.hasPreviousWaypoints() || null != nav.getCurrentWaypoint());
    }

    private boolean isStandingThere(JTextComponent target, NavigationHistory.Waypoint wpt) {
        return target == wpt.getComponent() && target.getCaret().getDot() == wpt.getOffset();
    }
}

