/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AbbrevsMIMEOptionFile
extends MIMEOptionFile {
    public static final String TAG_ROOT = "abbrevs";
    public static final String TAG_ABBREV = "abbrev";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_REMOVE = "remove";
    public static final String ATTR_XML_SPACE = "xml:space";
    public static final String VALUE_XML_SPACE = "preserve";
    static final String FILENAME = "abbreviations";

    public AbbrevsMIMEOptionFile(BaseOptions base, Object proc) {
        super(base, proc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettings(boolean propagate) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Document doc = this.dom;
            Element rootElement = doc.getDocumentElement();
            if (!TAG_ROOT.equals(rootElement.getTagName())) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Map abbrevsMap = (Map)Settings.getValue((Class)this.base.getKitClass(), (String)"abbrev-map");
            HashMap mapa = abbrevsMap == null ? new HashMap() : new HashMap(abbrevsMap);
            this.properties.clear();
            NodeList abbr = rootElement.getElementsByTagName(TAG_ABBREV);
            int len = abbr.getLength();
            for (int i = 0; i < len; ++i) {
                Node subNode;
                NodeList textList;
                Node node = abbr.item(i);
                Element FCElement = (Element)node;
                if (FCElement == null) continue;
                String key = FCElement.getAttribute(ATTR_KEY);
                String delete = FCElement.getAttribute(ATTR_REMOVE);
                String expanded = "";
                if (!Boolean.valueOf(delete).booleanValue() && (textList = FCElement.getChildNodes()).getLength() > 0 && (subNode = textList.item(0)) instanceof Text) {
                    Text textNode = (Text)subNode;
                    expanded = textNode.getData();
                }
                this.properties.put(key, expanded);
            }
            if (this.properties.size() > 0) {
                mapa.putAll(this.properties);
                for (String key : this.properties.keySet()) {
                    if (((String)this.properties.get(key)).length() != 0) continue;
                    mapa.remove(key);
                }
                if (propagate) {
                    this.base.setAbbrevMap(mapa, false);
                }
            }
            if (propagate) {
                this.setLoaded(true);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSettings(Map changedProp) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            this.properties.putAll(changedProp);
            Document doc = XMLUtil.createDocument((String)TAG_ROOT, null, (String)this.processor.getPublicID(), (String)this.processor.getSystemID());
            Element rootElem = doc.getDocumentElement();
            ArrayList<String> removed = new ArrayList<String>();
            HashMap defaultAbbrevs = this.base.getDefaultAbbrevMap();
            if (defaultAbbrevs == null) {
                defaultAbbrevs = new HashMap();
            }
            for (String key : this.properties.keySet()) {
                String defValue;
                if (!(this.properties.get(key) instanceof String)) continue;
                String action = (String)this.properties.get(key);
                if (action.length() == 0) {
                    if (!defaultAbbrevs.containsKey(key)) {
                        removed.add(key);
                        continue;
                    }
                } else if (defaultAbbrevs.containsKey(key) && (defValue = (String)defaultAbbrevs.get(key)).equals(action)) {
                    removed.add(key);
                    continue;
                }
                Element abbrevElem = doc.createElement(TAG_ABBREV);
                abbrevElem.setAttribute(ATTR_KEY, key);
                if (action.length() == 0) {
                    abbrevElem.setAttribute(ATTR_REMOVE, Boolean.TRUE.toString());
                } else {
                    abbrevElem.setAttribute(ATTR_XML_SPACE, VALUE_XML_SPACE);
                    abbrevElem.appendChild(doc.createTextNode(action));
                }
                rootElem.appendChild(abbrevElem);
            }
            for (int i = 0; i < removed.size(); ++i) {
                this.properties.remove(removed.get(i));
            }
            doc.getDocumentElement().normalize();
            this.saveSettings(doc);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

