/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.KeySequenceInputPanel;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.options.KeyBindingsEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class KeyBindingsEditorPanel
extends JPanel {
    private ActionDescriptor[] acts;
    private int actionIndex;
    private String kitClassName;
    private KeyBindingsEditor editor;
    private ButtonGroup sortGroup;
    private JList sequencesList;
    private JButton addSequenceButton;
    private JPanel sortButtonsPanel;
    private JPanel actionsPanel;
    private JScrollPane sequencesScrollPane;
    private JRadioButton actionSortRadioButton;
    private JPanel sequencesPanel;
    private JScrollPane actionsScrollPane;
    private JRadioButton nameSortRadioButton;
    private JButton removeSequenceButton;
    private JLabel sequencesLabel;
    private JList actionsList;

    public KeyBindingsEditorPanel(KeyBindingsEditor editor) {
        this.editor = editor;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_Panel"));
        this.sequencesLabel.setDisplayedMnemonic(this.getBundleString("KBEP_Sequences_Mnemonic").charAt(0));
        this.actionsList.getAccessibleContext().setAccessibleName(this.getBundleString("ACSN_KBEP_Actions"));
        this.actionsList.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_Actions"));
        this.sequencesList.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_Sequences"));
        this.nameSortRadioButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_name_sort_button"));
        this.actionSortRadioButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_action_sort_button"));
        this.addSequenceButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_Add"));
        this.removeSequenceButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_Remove"));
        this.sortGroup = new ButtonGroup();
        this.sortGroup.add(this.actionSortRadioButton);
        this.sortGroup.add(this.nameSortRadioButton);
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage(KeyBindingsEditorPanel.class, (String)s);
    }

    public void setValue(List l) {
        if (l == null) {
            return;
        }
        this.kitClassName = (String)l.get(0);
        Class<?> kitClass = null;
        try {
            ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            kitClass = Class.forName(this.kitClassName, true, loader);
        }
        catch (ClassNotFoundException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return;
        }
        Class<Object> actionKitClass = kitClass;
        if (actionKitClass == BaseKit.class) {
            actionKitClass = NbEditorKit.class;
        }
        Action[] actions = BaseKit.getKit(actionKitClass).getActions();
        TreeMap<String, ActionDescriptor> treeMap = new TreeMap<String, ActionDescriptor>();
        for (int i = 0; i < actions.length; ++i) {
            Object internalActionObj;
            if (actions[i] != null && (internalActionObj = actions[i].getValue("no-keybinding")) instanceof Boolean && ((Boolean)internalActionObj).booleanValue()) continue;
            ActionDescriptor val = new ActionDescriptor(actions[i]);
            treeMap.put(val.name, val);
        }
        Class<?> parent = kitClass.getSuperclass();
        Settings.KitAndValue[] kv = Settings.getValueHierarchy(parent, (String)"key-bindings");
        for (int i = kv.length - 1; i >= 0; --i) {
            this.addKeyBindingList(treeMap, ((List)kv[i].value).iterator(), true);
        }
        this.addKeyBindingList(treeMap, l.listIterator(1), false);
        this.acts = treeMap.values().toArray(new ActionDescriptor[0]);
        if (this.acts.length > 0) {
            this.addSequenceButton.setEnabled(true);
        }
        Arrays.sort(this.acts);
        this.actionsList.setListData(this.acts);
        this.actionsList.setSelectedIndex(this.actionIndex);
        this.updateSequences(0);
        if (ActionDescriptor.getSortMode() == 0) {
            this.actionSortRadioButton.setSelected(true);
        } else {
            this.nameSortRadioButton.setSelected(true);
        }
    }

    private void addKeyBindingList(Map target, Iterator source, boolean inherited) {
        while (source.hasNext()) {
            KeySequence sequence;
            MultiKeyBinding b = (MultiKeyBinding)source.next();
            ActionDescriptor ad = (ActionDescriptor)target.get(b.actionName);
            if (ad == null || (sequence = this.getKeySequenceForBinding(inherited, b)) == null) continue;
            ad.sequences.add(sequence);
        }
    }

    private KeySequence getKeySequenceForBinding(boolean inherited, MultiKeyBinding binding) {
        KeyStroke[] sequence = binding.keys;
        if (sequence == null) {
            if (binding.key == null) {
                return null;
            }
            sequence = new KeyStroke[]{binding.key};
        }
        return new KeySequence(inherited, sequence);
    }

    public List getValue() {
        Vector<String> val = new Vector<String>();
        val.add(this.kitClassName);
        for (int i = 0; i < this.acts.length; ++i) {
            String name = this.acts[i].name;
            for (KeySequence seq : this.acts[i].sequences) {
                if (seq.isInherited()) continue;
                val.add((String)new MultiKeyBinding(seq.getKeyStrokes(), name));
            }
        }
        return val;
    }

    private void updateSequences(int index) {
        Vector bindings = this.acts[this.actionIndex].sequences;
        this.sequencesList.setListData(bindings);
        if (bindings.size() > 0) {
            this.sequencesList.setSelectedIndex(index);
        }
    }

    private void updateRemoveButton() {
        int id = this.sequencesList.getSelectedIndex();
        Vector b = this.acts[this.actionIndex].sequences;
        boolean enable = id >= 0 && id < b.size() && !((KeySequence)b.get(id)).isInherited();
        this.removeSequenceButton.setEnabled(enable);
    }

    private void notifyEditor() {
        if (this.editor != null) {
            this.editor.customEditorChange();
        }
    }

    private void sortActionsList() {
        int mode = this.actionSortRadioButton.isSelected() ? 0 : 1;
        ActionDescriptor.setSortMode(mode);
        ActionDescriptor ad = this.acts[this.actionIndex];
        Arrays.sort(this.acts);
        int newIndex = 0;
        for (int x = 0; x < this.acts.length; ++x) {
            if (this.acts[x] != ad) continue;
            newIndex = x;
            break;
        }
        this.actionsList.setListData(this.acts);
        this.actionIndex = newIndex;
        this.actionsList.setSelectedIndex(this.actionIndex);
        this.actionsList.ensureIndexIsVisible(this.actionIndex);
        this.actionsList.requestFocus();
    }

    private void initComponents() {
        this.actionsPanel = new JPanel();
        this.sortButtonsPanel = new JPanel();
        this.nameSortRadioButton = new JRadioButton();
        this.actionSortRadioButton = new JRadioButton();
        this.actionsScrollPane = new JScrollPane();
        this.actionsList = new JList();
        this.sequencesPanel = new JPanel();
        this.sequencesLabel = new JLabel();
        this.sequencesScrollPane = new JScrollPane();
        this.sequencesList = new JList();
        this.addSequenceButton = new JButton();
        this.removeSequenceButton = new JButton();
        this.setLayout(new BorderLayout(0, 12));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.actionsPanel.setLayout(new GridBagLayout());
        this.actionsPanel.setBorder(new TitledBorder(new EmptyBorder(new Insets(0, 0, 0, 0)), this.getBundleString("KBEP_Actions")));
        this.sortButtonsPanel.setLayout(new GridBagLayout());
        this.nameSortRadioButton.setMnemonic(this.getBundleString("KBEP_name_sort_button_mnemonic").charAt(0));
        this.nameSortRadioButton.setText(this.getBundleString("KBEP_name_sort_button"));
        this.nameSortRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KeyBindingsEditorPanel.this.nameSortRadioButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.sortButtonsPanel.add((Component)this.nameSortRadioButton, gridBagConstraints);
        this.actionSortRadioButton.setMnemonic(this.getBundleString("KBEP_action_sort_button_mnemonic").charAt(0));
        this.actionSortRadioButton.setText(this.getBundleString("KBEP_action_sort_button"));
        this.actionSortRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KeyBindingsEditorPanel.this.actionSortRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.sortButtonsPanel.add((Component)this.actionSortRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.actionsPanel.add((Component)this.sortButtonsPanel, gridBagConstraints);
        this.actionsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                KeyBindingsEditorPanel.this.actionsListValueChanged(evt);
            }
        });
        this.actionsScrollPane.setViewportView(this.actionsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.actionsPanel.add((Component)this.actionsScrollPane, gridBagConstraints);
        this.add((Component)this.actionsPanel, "Center");
        this.sequencesPanel.setLayout(new GridBagLayout());
        this.sequencesLabel.setLabelFor(this.sequencesList);
        this.sequencesLabel.setText(this.getBundleString("KBEP_Sequences"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 12);
        this.sequencesPanel.add((Component)this.sequencesLabel, gridBagConstraints);
        this.sequencesScrollPane.setPreferredSize(new Dimension(259, 80));
        this.sequencesList.setCellRenderer(new KeySequenceCellRenderer());
        this.sequencesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                KeyBindingsEditorPanel.this.sequencesListValueChanged(evt);
            }
        });
        this.sequencesScrollPane.setViewportView(this.sequencesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.sequencesPanel.add((Component)this.sequencesScrollPane, gridBagConstraints);
        this.addSequenceButton.setMnemonic(this.getBundleString("KBEP_Add_Mnemonic").charAt(0));
        this.addSequenceButton.setText(this.getBundleString("KBEP_Add"));
        this.addSequenceButton.setEnabled(false);
        this.addSequenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KeyBindingsEditorPanel.this.addSequenceButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.sequencesPanel.add((Component)this.addSequenceButton, gridBagConstraints);
        this.removeSequenceButton.setMnemonic(this.getBundleString("KBEP_Remove_Mnemonic").charAt(0));
        this.removeSequenceButton.setText(this.getBundleString("KBEP_Remove"));
        this.removeSequenceButton.setEnabled(false);
        this.removeSequenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KeyBindingsEditorPanel.this.removeSequenceButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.sequencesPanel.add((Component)this.removeSequenceButton, gridBagConstraints);
        this.add((Component)this.sequencesPanel, "South");
    }

    private void nameSortRadioButtonActionPerformed(ActionEvent evt) {
        this.sortActionsList();
    }

    private void actionSortRadioButtonActionPerformed(ActionEvent evt) {
        this.sortActionsList();
    }

    private void sequencesListValueChanged(ListSelectionEvent evt) {
        this.updateRemoveButton();
    }

    private void addSequenceButtonActionPerformed(ActionEvent evt) {
        KeySequence newSequence = new KeySequenceRequester().getKeySequence();
        if (newSequence == null) {
            return;
        }
        this.acts[this.actionIndex].sequences.add(newSequence);
        this.updateSequences(this.acts[this.actionIndex].sequences.size() - 1);
        this.notifyEditor();
    }

    private void removeSequenceButtonActionPerformed(ActionEvent evt) {
        int index = this.sequencesList.getSelectedIndex();
        if (index >= 0) {
            this.acts[this.actionIndex].sequences.remove(index);
            if (index >= this.acts[this.actionIndex].sequences.size()) {
                --index;
            }
            this.updateSequences(index);
            this.notifyEditor();
        }
    }

    private void actionsListValueChanged(ListSelectionEvent evt) {
        if (this.actionsList.getSelectedIndex() < 0) {
            return;
        }
        this.actionIndex = this.actionsList.getSelectedIndex();
        this.updateSequences(0);
    }

    private static final class ActionDescriptor
    implements Comparable {
        public static final int SORT_BY_ACTION = 0;
        public static final int SORT_BY_NAME = 1;
        private static int sortMode = 1;
        String name;
        String displayName;
        Vector sequences;

        ActionDescriptor(Action a) {
            this.name = (String)a.getValue("Name");
            String shortDesc = (String)a.getValue("ShortDescription");
            this.displayName = shortDesc == null ? this.name : shortDesc + " [" + this.name + "]";
            this.sequences = new Vector();
        }

        public String toString() {
            return this.displayName;
        }

        public int compareTo(Object o) {
            if (sortMode == 0) {
                return this.name.compareTo(((ActionDescriptor)o).name);
            }
            return this.displayName.compareToIgnoreCase(((ActionDescriptor)o).displayName);
        }

        public static void setSortMode(int sMode) {
            sortMode = sMode;
        }

        public static int getSortMode() {
            return sortMode;
        }
    }

    private static final class KeySequence {
        private boolean inherited;
        private KeyStroke[] sequence;

        KeySequence(boolean inherited, KeyStroke[] sequence) {
            this.inherited = inherited;
            this.sequence = sequence;
        }

        KeyStroke[] getKeyStrokes() {
            return this.sequence;
        }

        boolean isInherited() {
            return this.inherited;
        }

        public String toString() {
            return Utilities.keySequenceToString((KeyStroke[])this.sequence);
        }
    }

    private static final class KeySequenceCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public KeySequenceCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            if (value instanceof KeySequence && ((KeySequence)value).isInherited()) {
                this.setForeground(Color.gray);
            } else {
                this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }

    private class KeySequenceRequester {
        KeySequenceInputPanel input;
        DialogDescriptor dd;
        Dialog dial;
        Object[] buttons;
        KeySequence retVal;

        KeySequenceRequester() {
            this.buttons = new Object[]{new JButton(KeyBindingsEditorPanel.this.getBundleString("KBEP_OK_LABEL")), new JButton(KeyBindingsEditorPanel.this.getBundleString("KBEP_CLEAR_LABEL")), DialogDescriptor.CANCEL_OPTION};
            this.retVal = null;
            ((JButton)this.buttons[0]).getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_KBEP_OK"));
            ((JButton)this.buttons[1]).getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_KBEP_CLEAR"));
            ((JButton)this.buttons[1]).setMnemonic(KeyBindingsEditorPanel.this.getBundleString("KBEP_CLEAR_Mnemonic").charAt(0));
            ((JButton)this.buttons[0]).setEnabled(false);
            this.input = new KeySequenceInputPanel();
            this.input.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("keySequence" != evt.getPropertyName()) {
                        return;
                    }
                    KeyStroke[] seq = KeySequenceRequester.this.input.getKeySequence();
                    String warn = KeySequenceRequester.this.getCollisionString(seq);
                    KeySequenceRequester.this.input.setInfoText(warn == null ? "" : warn);
                    ((JButton)KeySequenceRequester.this.buttons[0]).setEnabled(warn == null);
                }
            });
            this.dd = new DialogDescriptor((Object)this.input, KeyBindingsEditorPanel.this.getBundleString("KBEP_AddSequence"), true, this.buttons, this.buttons[0], 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == KeySequenceRequester.this.buttons[1]) {
                        KeySequenceRequester.this.input.clear();
                        KeySequenceRequester.this.input.requestFocus();
                    } else if (evt.getSource() == KeySequenceRequester.this.buttons[0]) {
                        KeySequenceRequester.this.retVal = new KeySequence(false, KeySequenceRequester.this.input.getKeySequence());
                        KeySequenceRequester.this.dial.dispose();
                    }
                }
            });
        }

        KeySequence getKeySequence() {
            this.dial = DialogDisplayer.getDefault().createDialog(this.dd);
            this.input.requestFocus();
            this.dial.setVisible(true);
            return this.retVal;
        }

        String getCollisionString(KeyStroke[] seq) {
            if (seq.length == 0) {
                return "";
            }
            for (int i = 0; i < KeyBindingsEditorPanel.this.acts.length; ++i) {
                Iterator iter = ((KeyBindingsEditorPanel)KeyBindingsEditorPanel.this).acts[i].sequences.iterator();
                while (iter.hasNext()) {
                    KeyStroke[] s1 = ((KeySequence)iter.next()).getKeyStrokes();
                    if (!this.isOverlapingSequence(s1, seq)) continue;
                    Object[] values = new Object[]{Utilities.keySequenceToString((KeyStroke[])s1), KeyBindingsEditorPanel.this.acts[i]};
                    return NbBundle.getMessage(KeyBindingsEditorPanel.class, (String)"KBEP_FMT_Collision", (Object[])values);
                }
            }
            return null;
        }

        private boolean isOverlapingSequence(KeyStroke[] s1, KeyStroke[] s2) {
            int l = Math.min(s1.length, s2.length);
            while (l-- > 0) {
                if (s1[l].equals(s2[l])) continue;
                return false;
            }
            return true;
        }
    }
}

