/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyBindingsMIMEOptionFile
extends MIMEOptionFile {
    public static final String TAG_ROOT = "bindings";
    public static final String TAG_BIND = "bind";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_ACTION_NAME = "actionName";
    public static final String ATTR_REMOVE = "remove";
    static final String FILENAME = "keybindings";

    public KeyBindingsMIMEOptionFile(BaseOptions base, Object proc) {
        super(base, proc);
    }

    private List getKBList() {
        Settings.KitAndValue[] kav = Settings.getValueHierarchy((Class)this.base.getKitClass(), (String)"key-bindings");
        List<MultiKeyBinding> kbList = null;
        for (int i = 0; i < kav.length; ++i) {
            if (kav[i].kitClass != this.base.getKitClass()) continue;
            kbList = (List)kav[i].value;
        }
        if (kbList == null) {
            kbList = new ArrayList();
        }
        int cnt = kbList.size();
        for (int i = 0; i < cnt; ++i) {
            Object o = kbList.get(i);
            if (o instanceof MultiKeyBinding || o == null) continue;
            JTextComponent.KeyBinding b = (JTextComponent.KeyBinding)o;
            kbList.set(i, new MultiKeyBinding(b.key, b.actionName));
        }
        return new ArrayList(kbList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettings(boolean propagate) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (this.base.usesNewOptionsDialog()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Document doc = this.dom;
            Element rootElement = doc.getDocumentElement();
            if (!TAG_ROOT.equals(rootElement.getTagName())) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            List keybs = this.getKBList();
            Map mapa = OptionUtilities.makeKeyBindingsMap(keybs);
            this.properties.clear();
            NodeList bind = rootElement.getElementsByTagName(TAG_BIND);
            int len = bind.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = bind.item(i);
                Element bindElement = (Element)node;
                if (bindElement == null) continue;
                String key = bindElement.getAttribute(ATTR_KEY);
                String delete = bindElement.getAttribute(ATTR_REMOVE);
                String actionName = bindElement.getAttribute(ATTR_ACTION_NAME);
                if (actionName == null) {
                    actionName = "";
                }
                if (actionName.length() != 0 && !Boolean.valueOf(delete).booleanValue()) {
                    MultiKeyBinding mkb;
                    if (key.indexOf(36) > 0) {
                        mkb = new MultiKeyBinding(OptionUtilities.stringToKeys(key), actionName);
                        this.properties.put(key, mkb);
                        continue;
                    }
                    mkb = new MultiKeyBinding(OptionUtilities.stringToKey(key), actionName);
                    this.properties.put(key, mkb);
                    continue;
                }
                this.properties.put(key, "");
            }
            if (this.properties.size() > 0) {
                mapa.putAll(this.properties);
                for (String key : this.properties.keySet()) {
                    if (!(this.properties.get(key) instanceof String)) continue;
                    mapa.remove(key);
                }
                if (propagate) {
                    this.setLoaded(true);
                    this.base.setKeyBindingList(new ArrayList(mapa.values()), false);
                }
            }
            if (propagate) {
                this.setLoaded(true);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSettings(Map changedProp) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (this.base.usesNewOptionsDialog()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.properties.putAll(changedProp);
            Document doc = XMLUtil.createDocument((String)TAG_ROOT, null, (String)this.processor.getPublicID(), (String)this.processor.getSystemID());
            Element rootElem = doc.getDocumentElement();
            ArrayList<String> removed = new ArrayList<String>();
            HashMap defaultKeybs = this.base.getDefaultKeyBindingsMap();
            if (defaultKeybs == null) {
                defaultKeybs = new HashMap();
            }
            for (String key : this.properties.keySet()) {
                if (this.properties.get(key) instanceof String) {
                    String realKey = KeyBindingsMIMEOptionFile.tryRemoveKeyFromMap(doc, this.properties, key, defaultKeybs, rootElem);
                    if (realKey == null) continue;
                    removed.add(realKey);
                    key = realKey;
                    continue;
                }
                if (!(this.properties.get(key) instanceof MultiKeyBinding)) continue;
                MultiKeyBinding mkb = (MultiKeyBinding)this.properties.get(key);
                String curActionName = mkb.actionName;
                if (curActionName == null) {
                    curActionName = "";
                }
                boolean save = true;
                if (defaultKeybs.get(key) instanceof MultiKeyBinding) {
                    String defActionName = ((MultiKeyBinding)defaultKeybs.get((Object)key)).actionName;
                    boolean hasKey = defaultKeybs.containsKey(key);
                    if (!hasKey) {
                        String[] s = KeyBindingsMIMEOptionFile.getPermutations(key);
                        for (int j = 0; j < s.length && !hasKey; ++j) {
                            if (!(hasKey |= defaultKeybs.containsKey(s[j]))) continue;
                            key = s[j];
                            break;
                        }
                    }
                    if (hasKey && curActionName.equals(defActionName)) {
                        save = false;
                    }
                }
                if (!save) continue;
                Element keybElem = doc.createElement(TAG_BIND);
                keybElem.setAttribute(ATTR_KEY, key);
                keybElem.setAttribute(ATTR_ACTION_NAME, curActionName);
                rootElem.appendChild(keybElem);
            }
            for (int i = 0; i < removed.size(); ++i) {
                this.properties.remove(removed.get(i));
            }
            doc.getDocumentElement().normalize();
            this.saveSettings(doc);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static String tryRemoveKeyFromMap(Document doc, Map props, String key, Map defaultKeybs, Element root) {
        if (defaultKeybs.containsKey(key)) {
            KeyBindingsMIMEOptionFile.removeKeyFromMap(doc, props, key, root);
            return key;
        }
        String[] s = KeyBindingsMIMEOptionFile.getPermutations(key);
        for (int i = 0; i < s.length; ++i) {
            if (!defaultKeybs.containsKey(s[i])) continue;
            KeyBindingsMIMEOptionFile.removeKeyFromMap(doc, props, key, root);
            return s[i];
        }
        return null;
    }

    private static void removeKeyFromMap(Document doc, Map props, String key, Element root) {
        Element keybElem = doc.createElement(TAG_BIND);
        keybElem.setAttribute(ATTR_KEY, key);
        keybElem.setAttribute(ATTR_REMOVE, Boolean.TRUE.toString());
        root.appendChild(keybElem);
    }

    static String[] getPermutations(String name) {
        String[] stringArray;
        String key = 4 == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() ? "M" : "C";
        String ctrlWildcard = "D";
        String altKey = System.getProperty("mrj.version") != null ? "C" : "A";
        String altWildcard = "O";
        int pos = name.lastIndexOf("-");
        if (pos == -1) {
            return new String[]{name};
        }
        String keyPart = name.substring(pos);
        String modsPart = Utilities.replaceString((String)name.substring(0, pos), (String)"-", (String)"");
        if (modsPart.length() > 1) {
            StringBuffer sb;
            HashSet<String> perms = new HashSet<String>(modsPart.length() * modsPart.length());
            int idx = name.indexOf(key);
            if (idx != -1) {
                sb = new StringBuffer(modsPart);
                sb.replace(idx, idx + 1, ctrlWildcard);
                perms.add(sb.toString() + keyPart);
                KeyBindingsMIMEOptionFile.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                KeyBindingsMIMEOptionFile.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
                idx = name.indexOf(altKey);
                if (idx != -1) {
                    sb.replace(idx, idx + 1, altWildcard);
                    perms.add(sb.toString() + keyPart);
                    KeyBindingsMIMEOptionFile.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                    KeyBindingsMIMEOptionFile.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
                } else {
                    idx = name.indexOf(altWildcard);
                    if (idx != -1) {
                        sb.replace(idx, idx + 1, altKey);
                        perms.add(sb.toString() + keyPart);
                        KeyBindingsMIMEOptionFile.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                        KeyBindingsMIMEOptionFile.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
                    }
                }
            } else {
                idx = name.indexOf(ctrlWildcard);
                if (idx != -1) {
                    sb = new StringBuffer(modsPart);
                    sb.replace(idx, idx + 1, key);
                    perms.add(sb.toString() + keyPart);
                    KeyBindingsMIMEOptionFile.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                    KeyBindingsMIMEOptionFile.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
                    idx = name.indexOf(altKey);
                    if (idx != -1) {
                        sb.replace(idx, idx + 1, altWildcard);
                        perms.add(sb.toString() + keyPart);
                        KeyBindingsMIMEOptionFile.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                    } else {
                        idx = name.indexOf(altWildcard);
                        if (idx != -1) {
                            sb.replace(idx, idx + 1, altKey);
                            perms.add(sb.toString() + keyPart);
                            KeyBindingsMIMEOptionFile.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                            KeyBindingsMIMEOptionFile.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
                        }
                    }
                }
            }
            idx = name.indexOf(altKey);
            if (idx != -1) {
                sb = new StringBuffer(modsPart);
                sb.replace(idx, idx + 1, altWildcard);
                perms.add(sb.toString() + keyPart);
                KeyBindingsMIMEOptionFile.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                KeyBindingsMIMEOptionFile.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
            } else {
                sb = new StringBuffer(modsPart);
                idx = name.indexOf(altWildcard);
                if (idx != -1) {
                    sb.replace(idx, idx + 1, altKey);
                    perms.add(sb.toString() + keyPart);
                    KeyBindingsMIMEOptionFile.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                    KeyBindingsMIMEOptionFile.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
                }
            }
            KeyBindingsMIMEOptionFile.getAllPossibleOrderings(modsPart, keyPart, perms);
            KeyBindingsMIMEOptionFile.createHyphenatedPermutation(modsPart.toCharArray(), perms, keyPart);
            return perms.toArray(new String[perms.size()]);
        }
        if (key.equals(modsPart)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ctrlWildcard + keyPart;
        } else if (altKey.equals(modsPart)) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = altWildcard + keyPart;
        } else if (altWildcard.equals(modsPart)) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = altKey + keyPart;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    static void getAllPossibleOrderings(String s, String toAppend, Collection store) {
        char[] c = s.toCharArray();
        KeyBindingsMIMEOptionFile.mutate(c, store, 0, toAppend);
        String[] result = store.toArray(new String[store.size()]);
    }

    private static void mutate(char[] c, Collection l, int n, String toAppend) {
        if (n == c.length) {
            l.add(new String(c) + toAppend);
            KeyBindingsMIMEOptionFile.createHyphenatedPermutation(c, l, toAppend);
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            char x = c[i];
            c[i] = c[n];
            c[n] = x;
            if (n >= c.length) continue;
            KeyBindingsMIMEOptionFile.mutate(c, l, n + 1, toAppend);
        }
    }

    static void createHyphenatedPermutation(char[] c, Collection l, String toAppend) {
        if (c.length == 1) {
            return;
        }
        StringBuffer sb = new StringBuffer(new String(c));
        for (int i = c.length - 1; i >= 1; --i) {
            sb.insert(i, '-');
        }
        sb.append(toAppend);
        l.add(sb.toString());
    }
}

