/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.GraphicsEnvironment;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.TopSecurityManager;
import org.netbeans.Util;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.DOMFactoryImpl;
import org.netbeans.core.startup.InstalledFileLocatorImpl;
import org.netbeans.core.startup.ModuleSystem;
import org.netbeans.core.startup.NbRepository;
import org.netbeans.core.startup.NbURLStreamHandlerFactory;
import org.netbeans.core.startup.RunLevel;
import org.netbeans.core.startup.SAXFactoryImpl;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopThreadGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;

public final class Main {
    private static ModuleSystem moduleSystem;
    private static boolean moduleSystemInitialized;
    private static boolean nbFactoryInitialized;

    public static void setStatusText(String msg) {
        Splash.getInstance().print(msg);
        if (moduleSystemInitialized) {
            CoreBridge.conditionallyPrintStatus(msg);
        }
    }

    public static void main(String[] argv) throws Exception {
        TopThreadGroup tg = new TopThreadGroup("IDE Main", argv);
        StartLog.logStart("Forwarding to topThreadGroup");
        tg.start();
        StartLog.logProgress("Main.main finished");
    }

    public static void initializeURLFactory() {
        if (!nbFactoryInitialized) {
            NbURLStreamHandlerFactory fact = new NbURLStreamHandlerFactory();
            try {
                URL.setURLStreamHandlerFactory(fact);
            }
            catch (Error e) {
                fact.registerUsingReflection(e);
            }
            nbFactoryInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initUICustomizations() {
        if (!CLIOptions.isGui()) {
            return;
        }
        URL themeURL = null;
        boolean wantTheme = Boolean.getBoolean("netbeans.useTheme") || CLIOptions.uiClass != null && CLIOptions.uiClass.getName().indexOf("MetalLookAndFeel") >= 0;
        try {
            if (wantTheme) {
                FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("themes.xml");
                if (fo == null) {
                    try {
                        themeURL = new URL("nbresloc:/org/netbeans/core/startup/resources/themes.xml");
                        themeURL.openStream().close();
                    }
                    catch (IOException ex) {
                        themeURL = null;
                    }
                } else {
                    try {
                        themeURL = fo.getURL();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            CoreBridge.getDefault().initializePlaf(CLIOptions.uiClass, CLIOptions.getFontSize(), themeURL);
        }
        if (CLIOptions.getFontSize() > 0 && "GTK".equals(UIManager.getLookAndFeel().getID())) {
            Util.err.warning(NbBundle.getMessage(Main.class, (String)"GTK_FONTSIZE_UNSUPPORTED"));
        }
        StartLog.logProgress("Fonts updated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleSystem getModuleSystem() {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            if (moduleSystem != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return moduleSystem;
            }
            StartLog.logStart("Modules initialization");
            try {
                moduleSystem = new ModuleSystem(Repository.getDefault().getDefaultFileSystem());
            }
            catch (IOException ioe) {
                throw (IllegalStateException)new IllegalStateException("Module system cannot be created").initCause(ioe);
            }
            StartLog.logProgress("ModuleSystem created");
            // ** MonitorExit[var0] (shouldn't be in output)
            moduleSystem.loadBootModules();
            moduleSystem.readList();
            moduleSystem.restore();
            StartLog.logEnd("Modules initialization");
            moduleSystemInitialized = true;
            return moduleSystem;
        }
    }

    public static boolean isInitialized() {
        return moduleSystemInitialized;
    }

    static void start(String[] args) throws SecurityException {
        String jdkHome;
        StartLog.logEnd("Forwarding to topThreadGroup");
        StartLog.logStart("Preparation");
        System.setProperty("org.openide.specification.version", "6.2");
        System.setProperty("org.openide.version", "deprecated");
        System.setProperty("org.openide.major.version", "IDE/1");
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.5")) < 0) {
            System.err.println("The IDE requires JDK 5 or higher to run.");
            TopSecurityManager.exit((int)1);
        }
        if ((jdkHome = System.getProperty("jdk.home")) == null) {
            jdkHome = System.getProperty("java.home");
            if (Utilities.isMac()) {
                jdkHome = jdkHome + File.separator + "..";
            }
            System.setProperty("jdk.home", jdkHome);
        }
        Main.initializeURLFactory();
        if (System.getProperties().get("org.openide.TopManager") == null) {
            System.setProperty("org.openide.TopManager.GUI", "true");
            System.getProperties().put("org.openide.TopManager", "org.netbeans.core.NonGui");
        }
        CLIOptions.initialize();
        StartLog.logProgress("Command line parsed");
        StartLog.logStart("XML Factories");
        SAXFactoryImpl.install();
        DOMFactoryImpl.install();
        if (CLIOptions.isGui()) {
            try {
                GraphicsEnvironment.getLocalGraphicsEnvironment();
            }
            catch (InternalError exc) {
                String s = NbBundle.getMessage(Main.class, (String)"EXC_GraphicsStartFails1", (Object)exc.getMessage());
                System.out.println(s);
                s = NbBundle.getMessage(Main.class, (String)"EXC_GraphicsStartFails2", (Object)(CLIOptions.getUserDir() + "/var/log/messages.log"));
                System.out.println(s);
                throw exc;
            }
        }
        StartLog.logEnd("XML Factories");
        InstalledFileLocatorImpl.prepareCache();
        String[] sysbisp = Introspector.getBeanInfoSearchPath();
        String[] nbbisp = new String[]{"org.netbeans.beaninfo"};
        String[] allbisp = new String[sysbisp.length + nbbisp.length];
        System.arraycopy(nbbisp, 0, allbisp, 0, nbbisp.length);
        System.arraycopy(sysbisp, 0, allbisp, nbbisp.length, sysbisp.length);
        Introspector.setBeanInfoSearchPath(allbisp);
        try {
            if (System.getProperty("netbeans.full.hack") == null && System.getProperty("netbeans.close") == null) {
                if (!Main.handleLicenseCheck()) {
                    TopSecurityManager.exit((int)0);
                }
                if (!Main.handleImportOfUserDir()) {
                    TopSecurityManager.exit((int)0);
                }
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        StartLog.logProgress("License check performed and upgrade wizard consulted");
        Splash.getInstance().setRunning(true);
        Splash.getInstance().print(NbBundle.getMessage(Main.class, (String)"MSG_IDEInit"));
        assert (Repository.getDefault() instanceof NbRepository) : "Has to be NbRepository: " + Repository.getDefault();
        Main.getModuleSystem();
        CoreBridge.getDefault().registerPropertyEditors();
        StartLog.logProgress("PropertyEditors registered");
        CoreBridge.getDefault().loadSettings();
        StartLog.logProgress("IDE settings loaded");
        for (RunLevel level : Lookup.getDefault().lookupAll(RunLevel.class)) {
            level.run();
        }
        org.netbeans.Main.finishInitialization();
        StartLog.logProgress("Ran any delayed command-line options");
        Splash.getInstance().setRunning(false);
        Splash.getInstance().dispose();
        StartLog.logProgress("Splash hidden");
        StartLog.logEnd("Preparation");
    }

    private static final Class getKlass(String cls) {
        try {
            ModuleSystem ms = moduleSystem;
            ClassLoader loader = ms != null ? ms.getManager().getClassLoader() : Main.class.getClassLoader();
            return Class.forName(cls, false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getLocalizedMessage());
        }
    }

    static boolean handleImportOfUserDir() {
        class ImportHandler
        implements Runnable {
            private File installed = new File(new File(CLIOptions.getUserDir(), "var"), "imported");
            private String classname;
            private boolean executedOk;

            ImportHandler() {
            }

            public boolean shouldDoAnImport() {
                this.classname = System.getProperty("netbeans.importclass");
                return this.classname != null && !this.installed.exists();
            }

            public void run() {
                try {
                    Class clazz = Main.getKlass(this.classname);
                    Method showMethod = clazz.getMethod("main", String[].class);
                    showMethod.invoke(null, new Object[]{new String[0]});
                    this.executedOk = true;
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof UserCancelException) {
                        this.executedOk = true;
                    } else {
                        ex.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (LinkageError e) {
                    e.printStackTrace();
                }
            }

            public boolean canContinue() {
                if (this.shouldDoAnImport()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        if (this.executedOk) {
                            this.installed.getParentFile().mkdirs();
                            this.installed.createNewFile();
                            return true;
                        }
                        return false;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return true;
                    }
                    catch (InvocationTargetException ex) {
                        return false;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
                return true;
            }
        }
        ImportHandler handler = new ImportHandler();
        return handler.canContinue();
    }

    static boolean handleLicenseCheck() {
        class LicenseHandler
        implements Runnable {
            private String classname;
            private boolean executedOk;

            LicenseHandler() {
            }

            public boolean shouldDisplayLicense() {
                File f = InstalledFileLocator.getDefault().locate("var/license_accepted", null, false);
                if (f != null) {
                    return false;
                }
                this.classname = System.getProperty("netbeans.accept_license_class");
                return this.classname != null;
            }

            public void run() {
                try {
                    Class clazz = Main.getKlass(this.classname);
                    Method showMethod = clazz.getMethod("showLicensePanel", new Class[0]);
                    showMethod.invoke(null, new Object[0]);
                    this.executedOk = true;
                    File f = new File(new File(CLIOptions.getUserDir(), "var"), "license_accepted");
                    if (!f.exists()) {
                        f.getParentFile().mkdirs();
                        try {
                            f.createNewFile();
                        }
                        catch (IOException exc) {
                            exc.printStackTrace();
                        }
                    }
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof UserCancelException) {
                        this.executedOk = false;
                    } else {
                        ex.printStackTrace();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                catch (LinkageError ex) {
                    ex.printStackTrace();
                }
            }

            public boolean canContinue() {
                if (this.shouldDisplayLicense()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        return this.executedOk;
                    }
                    catch (InvocationTargetException ex) {
                        return false;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
                return true;
            }
        }
        LicenseHandler handler = new LicenseHandler();
        return handler.canContinue();
    }
}

