/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.netbeans.core.startup.ModuleHistory;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ModuleList {
    public static final String PUBLIC_ID = "-//NetBeans//DTD Module Status 1.0//EN";
    public static final String SYSTEM_ID = "http://www.netbeans.org/dtds/module-status-1_0.dtd";
    private static final boolean VALIDATE_XML = true;
    private final ModuleManager mgr;
    private final FileObject folder;
    private final Events ev;
    private final Map<String, DiskStatus> statuses = new HashMap<String, DiskStatus>(100);
    private boolean triggered = false;
    private final Listener listener = new Listener();
    private final Map<String, byte[]> compatibilitySers = new HashMap<String, byte[]>(100);
    private final Set<FileSystem.AtomicAction> myAtomicActions = Collections.synchronizedSet(new WeakSet(100));
    private static final byte[] MODULE_XML_INTRO = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n<module name=\"".getBytes();
    private static final byte[] MODULE_XML_INTRO_END = ">\n".getBytes();
    private static final byte[] MODULE_XML_DIV2 = "   <param name=\"".getBytes();
    private static final byte[] MODULE_XML_DIV3 = "/param>\n".getBytes();
    private static final byte[] MODULE_XML_END = "/module>\n".getBytes();
    private static RequestProcessor rpListener = null;

    public ModuleList(ModuleManager mgr, FileObject folder, Events ev) {
        this.mgr = mgr;
        this.folder = folder;
        this.ev = ev;
        Util.err.fine("ModuleList created, storage in " + folder);
    }

    public Set readInitial() {
        this.ev.log("startRead", new Object[0]);
        final HashSet read = new HashSet();
        try {
            this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileObject[] children = ModuleList.this.folder.getChildren();
                    ModuleList.this.ev.log("modulesFileScanned", new Object[]{children.length});
                    XMLReader reader = null;
                    for (int i = 0; i < children.length; ++i) {
                        if (!children[i].hasExt("ser")) {
                            if (children[i].hasExt("xml")) {
                                try {
                                    File jarFile;
                                    Map props;
                                    String name;
                                    String nameDashes;
                                    block25: {
                                        nameDashes = children[i].getName();
                                        char[] badChars = new char[]{'.', '/', '>', '='};
                                        for (int j = 0; j < 4; ++j) {
                                            if (nameDashes.indexOf(badChars[j]) == -1) continue;
                                            throw new IllegalArgumentException("Bad name: " + nameDashes);
                                        }
                                        name = nameDashes.replace('-', '.').intern();
                                        Dependency.create((int)1, (String)name);
                                        InputStream is = children[i].getInputStream();
                                        try {
                                            props = ModuleList.this.readStatus(new BufferedInputStream(is));
                                            if (props != null) break block25;
                                            Util.err.warning("Note - failed to parse " + children[i] + " the quick way, falling back on XMLReader");
                                            is.close();
                                            is = children[i].getInputStream();
                                            InputSource src = new InputSource(is);
                                            src.setSystemId(children[i].getURL().toExternalForm());
                                            if (reader == null) {
                                                try {
                                                    reader = XMLUtil.createXMLReader();
                                                }
                                                catch (SAXException e) {
                                                    throw (IllegalStateException)new IllegalStateException(e.toString()).initCause(e);
                                                }
                                                reader.setEntityResolver(ModuleList.this.listener);
                                                reader.setErrorHandler(ModuleList.this.listener);
                                            }
                                            props = ModuleList.this.readStatus(src, reader);
                                        }
                                        finally {
                                            is.close();
                                        }
                                    }
                                    if (!name.equals(props.get("name"))) {
                                        throw new IOException("Code name mismatch: " + name + " vs. " + props.get("name"));
                                    }
                                    String jar = (String)props.get("jar");
                                    try {
                                        jarFile = ModuleList.this.findJarByName(jar, name);
                                    }
                                    catch (FileNotFoundException fnfe) {
                                        ModuleList.this.ev.log("missingJarFile", new Object[]{new File(fnfe.getMessage())});
                                        try {
                                            children[i].delete();
                                        }
                                        catch (IOException ioe) {
                                            Util.err.log(Level.WARNING, null, ioe);
                                        }
                                        continue;
                                    }
                                    ModuleHistory history = new ModuleHistory(jar);
                                    Integer prevReleaseI = (Integer)props.get("release");
                                    int prevRelease = prevReleaseI == null ? -1 : prevReleaseI;
                                    SpecificationVersion prevSpec = (SpecificationVersion)props.get("specversion");
                                    history.upgrade(prevRelease, prevSpec);
                                    Boolean reloadableB = (Boolean)props.get("reloadable");
                                    boolean reloadable = reloadableB != null ? reloadableB : false;
                                    Boolean enabledB = (Boolean)props.get("enabled");
                                    boolean enabled = enabledB != null ? enabledB : false;
                                    Boolean autoloadB = (Boolean)props.get("autoload");
                                    boolean autoload = autoloadB != null ? autoloadB : false;
                                    Boolean eagerB = (Boolean)props.get("eager");
                                    boolean eager = eagerB != null ? eagerB : false;
                                    String installer = (String)props.get("installer");
                                    if (installer != null) {
                                        if (!installer.equals(nameDashes + ".ser")) {
                                            throw new IOException("Incorrect installer ser name: " + installer);
                                        }
                                        FileObject installerSer = ModuleList.this.folder.getFileObject(nameDashes, "ser");
                                        if (installerSer == null) {
                                            throw new IOException("No such install ser: " + installer + "; I see only: " + Arrays.asList(children));
                                        }
                                        byte[] buf = new byte[(int)installerSer.getSize()];
                                        InputStream is2 = installerSer.getInputStream();
                                        try {
                                            is2.read(buf);
                                        }
                                        finally {
                                            is2.close();
                                        }
                                        history.setInstallerState(buf);
                                        props.put("installerState", buf);
                                    }
                                    Module m = ModuleList.this.mgr.create(jarFile, (Object)history, reloadable, autoload, eager);
                                    read.add(m);
                                    DiskStatus status = new DiskStatus();
                                    status.module = m;
                                    status.file = children[i];
                                    status.pendingInstall = enabled;
                                    status.diskProps = props;
                                    ModuleList.this.statuses.put(name, status);
                                }
                                catch (Exception e) {
                                    Util.err.log(Level.WARNING, "Error encountered while reading " + children[i], e);
                                }
                            } else {
                                Util.err.fine("Strange file encountered in modules folder: " + children[i]);
                            }
                        }
                        ModuleList.this.ev.log("modulesFileProcessed", new Object[]{children[i]});
                    }
                    if (Util.err.isLoggable(Level.FINE)) {
                        Util.err.fine("read initial XML files: statuses=" + ModuleList.this.statuses);
                    }
                    ModuleList.this.ev.log("finishRead", new Object[]{read});
                    ModuleList.this.folder.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)ModuleList.this.listener, (Object)ModuleList.this.folder));
                }
            });
        }
        catch (IOException ioe) {
            Util.err.log(Level.WARNING, null, ioe);
        }
        return read;
    }

    private File findJarByName(String jar, String name) throws IOException {
        File f = new File(jar);
        if (f.isAbsolute()) {
            if (!f.isFile()) {
                throw new FileNotFoundException(f.getAbsolutePath());
            }
            return f;
        }
        f = InstalledFileLocator.getDefault().locate(jar, name, false);
        if (f != null) {
            return f;
        }
        throw new FileNotFoundException(jar);
    }

    public void trigger(Set<Module> boot) {
        this.ev.log("perfStart", new Object[]{"ModuleList.trigger"});
        if (this.triggered) {
            throw new IllegalStateException("Duplicate call to trigger()");
        }
        HashSet<Module> maybeEnable = new HashSet<Module>(boot);
        for (DiskStatus status : this.statuses.values()) {
            if (!status.pendingInstall) continue;
            status.pendingInstall = false;
            Module m = status.module;
            if (m.isEnabled() || m.isAutoload() || m.isEager()) {
                throw new IllegalStateException();
            }
            maybeEnable.add(m);
        }
        this.ev.log("perfTick", new Object[]{"modules to enable prepared"});
        if (!maybeEnable.isEmpty()) {
            this.ev.log("startAutoRestore", new Object[]{maybeEnable});
            this.installNew(maybeEnable);
            this.ev.log("finishAutoRestore", new Object[]{maybeEnable});
        }
        Util.err.fine("ModuleList.trigger: enabled new modules, flushing changes...");
        this.triggered = true;
        this.flushInitial();
        this.ev.log("perfEnd", new Object[]{"ModuleList.trigger"});
    }

    private void installNew(Set<Module> modules) {
        if (modules.isEmpty()) {
            return;
        }
        this.ev.log("perfStart", new Object[]{"ModuleList.installNew"});
        Iterator<Object> it = modules.iterator();
        while (it.hasNext()) {
            Module m = it.next();
            if (m.isAutoload() || m.isEager()) {
                it.remove();
                continue;
            }
            if (m.isEnabled()) {
                Util.err.fine("#17295 fix active for " + m.getCodeNameBase());
                it.remove();
                continue;
            }
            if (m.isValid()) continue;
            Util.err.fine("#17471 fix active for " + m.getCodeNameBase());
            it.remove();
        }
        List toEnable = this.mgr.simulateEnable(modules);
        for (Module m : toEnable) {
            if (m.isAutoload() || m.isEager() || modules.contains(m)) continue;
            modules.add(m);
        }
        HashSet<Module> missing = new HashSet<Module>(modules);
        missing.removeAll(toEnable);
        if (!missing.isEmpty()) {
            Util.transitiveClosureModuleDependencies((ModuleManager)this.mgr, missing);
            it = missing.iterator();
            while (it.hasNext()) {
                Module m;
                m = (Module)it.next();
                if (!m.getProblems().isEmpty()) continue;
                it.remove();
            }
            this.ev.log("failedInstallNew", new Object[]{missing});
            modules.removeAll(missing);
        }
        try {
            this.mgr.enable(modules);
        }
        catch (InvalidException ie) {
            Util.err.log(Level.WARNING, null, ie);
            Module bad = ie.getModule();
            if (bad == null) {
                throw new IllegalStateException();
            }
            this.ev.log("failedInstallNewUnexpected", new Object[]{bad, ie});
            modules.remove(bad);
            this.installNew(modules);
        }
        this.ev.log("perfEnd", new Object[]{"ModuleList.installNew"});
    }

    void installPrepare(Module m, ModuleInstall inst) {
        if (!(m.getHistory() instanceof ModuleHistory)) {
            Util.err.fine(m + " had strange history " + m.getHistory() + ", ignoring...");
            return;
        }
        ModuleHistory hist = (ModuleHistory)m.getHistory();
        byte[] compatSer = this.compatibilitySers.get(inst.getClass().getName());
        if (compatSer != null) {
            Util.err.fine("Had some old-style state for " + m);
            if (ModuleList.isReallyExternalizable(inst.getClass())) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                    new NbObjectOutputStream((OutputStream)baos).writeObject((Object)inst);
                    baos.close();
                    if (Utilities.compareObjects((Object)compatSer, (Object)baos.toByteArray())) {
                        Util.err.fine("Old-style state for " + m + " was gratuitous");
                    } else {
                        Util.err.fine("Old-style state for " + m + " was useful, loading it...");
                        hist.setInstallerState(new byte[0]);
                        ByteArrayInputStream is = new ByteArrayInputStream(compatSer);
                        Object o = new NbObjectInputStream((InputStream)is).readObject();
                        if (o != inst) {
                            throw new ClassCastException("Stored " + o + " but expecting " + inst);
                        }
                    }
                }
                catch (Exception e) {
                    Util.err.log(Level.WARNING, null, e);
                    hist.setInstallerState(new byte[0]);
                }
                catch (LinkageError le) {
                    Util.err.log(Level.WARNING, null, le);
                    hist.setInstallerState(new byte[0]);
                }
            } else {
                Util.err.fine(m + " did not want to store install state");
            }
        } else if (hist.getInstallerState() != null) {
            Util.err.fine("Loading install state for " + m);
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(hist.getInstallerState());
                Object o = new NbObjectInputStream((InputStream)is).readObject();
                if (o != inst) {
                    throw new ClassCastException("Stored " + o + " but expecting " + inst);
                }
            }
            catch (Exception e) {
                Util.err.log(Level.WARNING, null, e);
            }
            catch (LinkageError le) {
                Util.err.log(Level.WARNING, null, le);
            }
        } else if (ModuleList.isReallyExternalizable(inst.getClass())) {
            Util.err.fine("Checking pre-install state of " + m);
            Util.err.warning("Warning: use of writeExternal (or writeReplace) in " + inst.getClass().getName() + " is deprecated; use normal settings instead");
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                new NbObjectOutputStream((OutputStream)baos).writeObject((Object)inst);
                baos.close();
                hist.setInstallerState(baos.toByteArray());
            }
            catch (Exception e) {
                Util.err.log(Level.WARNING, null, e);
                hist.setInstallerState(new byte[0]);
            }
            catch (LinkageError le) {
                Util.err.log(Level.WARNING, null, le);
                hist.setInstallerState(new byte[0]);
            }
        } else {
            Util.err.fine(m + " did not want to store install state");
        }
    }

    private static boolean isReallyExternalizable(Class clazz) {
        Class c;
        for (c = clazz; c != ModuleInstall.class && c != Object.class; c = c.getSuperclass()) {
            try {
                c.getDeclaredMethod("writeExternal", ObjectOutput.class);
                return true;
            }
            catch (NoSuchMethodException nsme) {
                try {
                    c.getDeclaredMethod("writeReplace", new Class[0]);
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
        }
        if (c == Object.class) {
            throw new IllegalArgumentException("Class " + clazz + " was not a ModuleInstall");
        }
        return false;
    }

    void installPostpare(Module m, ModuleInstall inst) {
        block7: {
            if (!(m.getHistory() instanceof ModuleHistory)) {
                Util.err.fine(m + " had strange history " + m.getHistory() + ", ignoring...");
                return;
            }
            ModuleHistory hist = (ModuleHistory)m.getHistory();
            if (hist.getInstallerState() != null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                    new NbObjectOutputStream((OutputStream)baos).writeObject((Object)inst);
                    baos.close();
                    byte[] old = hist.getInstallerState();
                    byte[] nue = baos.toByteArray();
                    if (Utilities.compareObjects((Object)old, (Object)nue)) {
                        Util.err.fine(m + " did not change installer state (" + old.length + " bytes), not writing anything");
                        break block7;
                    }
                    Util.err.fine(m + " changed installer state after loading");
                    hist.setInstallerState(nue);
                }
                catch (Exception e) {
                    Util.err.log(Level.WARNING, null, e);
                }
                catch (LinkageError le) {
                    Util.err.log(Level.WARNING, null, le);
                }
            } else {
                Util.err.fine(m + " has no saved state");
            }
        }
    }

    private Map<String, Object> readStatus(InputSource is, XMLReader reader) throws IOException, SAXException {
        if (reader == null) {
            reader = XMLUtil.createXMLReader((boolean)true);
            reader.setEntityResolver(this.listener);
            reader.setErrorHandler(this.listener);
        }
        final HashMap<String, Object> m = new HashMap<String, Object>();
        DefaultHandler handler = new DefaultHandler(){
            private String modName;
            private String paramName;
            private StringBuffer data = new StringBuffer();

            public void startElement(String uri, String localname, String qname, Attributes attrs) throws SAXException {
                if ("module".equals(qname)) {
                    this.modName = attrs.getValue("name");
                    if (this.modName == null) {
                        throw new SAXException("No module name");
                    }
                    m.put("name", this.modName.intern());
                } else if (this.modName != null && "param".equals(qname)) {
                    this.paramName = attrs.getValue("name");
                    if (this.paramName == null) {
                        throw new SAXException("No param name");
                    }
                    this.paramName = this.paramName.intern();
                    this.data.setLength(0);
                }
            }

            public void characters(char[] ch, int start, int len) {
                if (this.modName != null && this.paramName != null) {
                    this.data.append(ch, start, len);
                }
            }

            public void endElement(String uri, String localname, String qname) throws SAXException {
                if ("param".equals(qname)) {
                    if (this.modName != null && this.paramName != null) {
                        if (this.data.length() == 0) {
                            throw new SAXException("No text contents in " + this.paramName + " of " + this.modName);
                        }
                        try {
                            m.put(this.paramName, ModuleList.this.processStatusParam(this.paramName, this.data.toString()));
                        }
                        catch (NumberFormatException nfe) {
                            throw (SAXException)new SAXException(nfe.toString()).initCause(nfe);
                        }
                        this.data.setLength(0);
                        this.paramName = null;
                    }
                } else if ("module".equals(qname)) {
                    this.modName = null;
                }
            }
        };
        reader.setContentHandler(handler);
        reader.parse(is);
        this.sanityCheckStatus(m);
        return m;
    }

    private Object processStatusParam(String k, String v) throws NumberFormatException {
        if (k == "release") {
            return new Integer(v);
        }
        if (k == "enabled" || k == "autoload" || k == "eager" || k == "reloadable") {
            return Boolean.valueOf(v);
        }
        if (k == "specversion") {
            return new SpecificationVersion(v);
        }
        if (v.length() < 100) {
            v = v.intern();
        }
        return v;
    }

    private void sanityCheckStatus(Map<String, Object> m) throws IOException {
        if (m.get("jar") == null) {
            throw new IOException("Must define jar param");
        }
        if (m.get("autoload") != null && ((Boolean)m.get("autoload")).booleanValue() && m.get("enabled") != null) {
            throw new IOException("Autoloads cannot specify enablement");
        }
        if (m.get("eager") != null && ((Boolean)m.get("eager")).booleanValue() && m.get("enabled") != null) {
            throw new IOException("Eager modules cannot specify enablement");
        }
        String origin = (String)m.remove("origin");
        if (origin != null) {
            String newjar;
            String jar = (String)m.get("jar");
            if (origin.equals("user") || origin.equals("installation")) {
                newjar = "modules/" + jar;
            } else if (origin.equals("user/autoload") || origin.equals("installation/autoload")) {
                newjar = "modules/autoload/" + jar;
            } else if (origin.equals("user/eager") || origin.equals("installation/eager")) {
                newjar = "modules/eager/" + jar;
            } else if (origin.equals("adhoc")) {
                newjar = jar;
            } else {
                throw new IOException("Unrecognized origin " + origin + " for " + jar);
            }
            Util.err.warning("Upgrading 'jar' param from " + jar + " to " + newjar + " and removing 'origin' " + origin);
            m.put("jar", newjar);
        }
    }

    private Map<String, Object> readStatus(InputStream is) throws IOException {
        HashMap<String, Object> m = new HashMap<String, Object>(15);
        if (!this.expect(is, MODULE_XML_INTRO)) {
            Util.err.fine("Could not read intro");
            return null;
        }
        String name = this.readTo(is, '\"');
        if (name == null) {
            Util.err.fine("Could not read code name base");
            return null;
        }
        m.put("name", name.intern());
        if (!this.expect(is, MODULE_XML_INTRO_END)) {
            Util.err.fine("Could not read stuff after cnb");
            return null;
        }
        block6: while (true) {
            int c = is.read();
            switch (c) {
                case 32: {
                    if (!this.expect(is, MODULE_XML_DIV2)) {
                        Util.err.fine("Could not read up to param");
                        return null;
                    }
                    String k = this.readTo(is, '\"');
                    if (k == null) {
                        Util.err.fine("Could not read param");
                        return null;
                    }
                    k = k.intern();
                    if (is.read() != 62) {
                        Util.err.fine("No > at end of <param> " + k);
                        return null;
                    }
                    String v = this.readTo(is, '<');
                    if (v == null) {
                        Util.err.fine("Could not read value of " + k);
                        return null;
                    }
                    if (!this.expect(is, MODULE_XML_DIV3)) {
                        Util.err.fine("Could not read end of param " + k);
                        return null;
                    }
                    try {
                        m.put(k, this.processStatusParam(k, v));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        Util.err.fine("Number misparse: " + nfe);
                        return null;
                    }
                }
                case 60: {
                    if (!this.expect(is, MODULE_XML_END)) {
                        Util.err.fine("Strange ending");
                        return null;
                    }
                    if (is.read() == -1) break block6;
                    Util.err.fine("Trailing garbage");
                    return null;
                }
                default: {
                    Util.err.fine("Strange stuff after <param>s: " + c);
                    return null;
                }
            }
        }
        this.sanityCheckStatus(m);
        return m;
    }

    private boolean expect(InputStream is, byte[] stuff) throws IOException {
        int len = stuff.length;
        boolean inNewline = false;
        int i = 0;
        while (i < len) {
            int c = is.read();
            if (c == 10 || c == 13) {
                if (inNewline) continue;
                inNewline = true;
                c = 10;
            } else {
                inNewline = false;
            }
            if (c == stuff[i++]) continue;
            return false;
        }
        if (stuff[len - 1] == 10) {
            if (!is.markSupported()) {
                throw new IOException("Mark not supported");
            }
            is.mark(1);
            int c = is.read();
            if (c != -1 && c != 10 && c != 13) {
                is.reset();
            }
        }
        return true;
    }

    private String readTo(InputStream is, char delim) throws IOException {
        if (delim == '\n') {
            throw new IOException("Not implemented");
        }
        CharArrayWriter caw = new CharArrayWriter(100);
        boolean inNewline = false;
        int c;
        while ((c = is.read()) != -1) {
            if (c > 126) {
                return null;
            }
            if (c == 10 || c == 13) {
                if (inNewline) continue;
                inNewline = true;
                c = 10;
            } else {
                if (c < 32 && c != 9) {
                    return null;
                }
                inNewline = false;
            }
            if (c == delim) {
                return caw.toString();
            }
            caw.write(c);
        }
        return null;
    }

    private void writeStatus(Map<String, Object> m, OutputStream os) throws IOException {
        String codeName = (String)m.get("name");
        if (codeName == null) {
            throw new IllegalArgumentException("no code name present");
        }
        OutputStreamWriter w = new OutputStreamWriter(os, "UTF-8");
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        w.write("<!DOCTYPE module PUBLIC \"");
        w.write(PUBLIC_ID);
        w.write("\"\n                        \"");
        w.write(SYSTEM_ID);
        w.write("\">\n");
        w.write("<module name=\"");
        w.write(XMLUtil.toAttributeValue((String)codeName));
        w.write("\">\n");
        for (Map.Entry<String, Object> entry : new TreeMap<String, Object>(m).entrySet()) {
            String name = entry.getKey();
            if (name.equals("installerState") || name.equals("name")) continue;
            Object val = entry.getValue();
            w.write("    <param name=\"");
            w.write(XMLUtil.toAttributeValue((String)name));
            w.write("\">");
            w.write(XMLUtil.toElementContent((String)val.toString()));
            w.write("</param>\n");
        }
        w.write("</module>\n");
        ((Writer)w).flush();
    }

    private DiskStatus writeOut(Module m, DiskStatus old) throws IOException {
        DiskStatus nue;
        if (old == null) {
            nue = new DiskStatus();
            nue.module = m;
            nue.diskProps = this.computeProperties(m);
        } else {
            nue = old;
        }
        FileSystem.AtomicAction aa = new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                if (nue.file == null) {
                    nue.file = ModuleList.this.folder.createData(((String)nue.diskProps.get("name")).replace('.', '-'), "xml");
                } else if (nue.dirty) {
                    throw new IOException("Will not clobber external changes in " + nue.file);
                }
                Util.err.fine("ModuleList: (re)writing " + nue.file);
                FileLock lock = nue.file.lock();
                try {
                    OutputStream os = nue.file.getOutputStream(lock);
                    try {
                        ModuleList.this.writeStatus(nue.diskProps, os);
                    }
                    finally {
                        os.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
                byte[] data = (byte[])nue.diskProps.get("installerState");
                if (data != null) {
                    String installerName = (String)nue.diskProps.get("installer");
                    FileObject ser = ModuleList.this.folder.getFileObject(installerName);
                    if (ser == null) {
                        int idx = installerName.lastIndexOf(46);
                        ser = ModuleList.this.folder.createData(installerName.substring(0, idx), installerName.substring(idx + 1));
                    }
                    lock = ser.lock();
                    try {
                        OutputStream os = ser.getOutputStream(lock);
                        try {
                            os.write(data);
                        }
                        finally {
                            os.close();
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                }
            }
        };
        this.myAtomicActions.add(aa);
        this.folder.getFileSystem().runAtomicAction(aa);
        return nue;
    }

    private void deleteFromDisk(final Module m, final DiskStatus status) throws IOException {
        final String nameDashes = m.getCodeNameBase().replace('.', '-');
        FileSystem.AtomicAction aa = new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject xml = ModuleList.this.folder.getFileObject(nameDashes, "xml");
                if (xml == null) {
                    Util.err.fine("ModuleList: " + m + "'s XML already gone from disk");
                    return;
                }
                if (status.dirty) {
                    throw new IOException("Unapproved external change to " + xml);
                }
                Util.err.fine("ModuleList: deleting " + xml);
                xml.delete();
                FileObject ser = ModuleList.this.folder.getFileObject(nameDashes, "ser");
                if (ser != null) {
                    Util.err.fine("(and also " + ser + ")");
                    ser.delete();
                }
            }
        };
        this.myAtomicActions.add(aa);
        this.folder.getFileSystem().runAtomicAction(aa);
    }

    private void flushInitial() {
        Util.err.fine("Flushing initial module list...");
        for (Module m : this.mgr.getModules()) {
            DiskStatus status = this.statuses.get(m.getCodeNameBase());
            if (status == null) continue;
            this.moduleChanged(m, status);
            m.addPropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.moduleListChanged();
        this.mgr.addPropertyChangeListener((PropertyChangeListener)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleListChanged() {
        Map<String, DiskStatus> map = this.statuses;
        synchronized (map) {
            if (Util.err.isLoggable(Level.FINE)) {
                Util.err.fine("ModuleList: moduleListChanged; statuses=" + this.statuses);
            }
            for (Module m : this.mgr.getModules()) {
                String name;
                if (m.isFixed() || m.getAllJars().isEmpty() || this.statuses.get(name = m.getCodeNameBase()) != null) continue;
                Util.err.fine("moduleListChanged: added: " + m);
                try {
                    this.statuses.put(name, this.writeOut(m, null));
                    m.addPropertyChangeListener((PropertyChangeListener)this.listener);
                }
                catch (IOException ioe) {
                    Util.err.log(Level.WARNING, null, ioe);
                }
            }
            Iterator<DiskStatus> it = this.statuses.values().iterator();
            while (it.hasNext()) {
                DiskStatus status = it.next();
                if (status.module.isValid()) continue;
                status.module.removePropertyChangeListener((PropertyChangeListener)this.listener);
                Module nue = this.mgr.get(status.module.getCodeNameBase());
                if (nue != null) {
                    Util.err.fine("moduleListChanged: recreated: " + nue);
                    nue.addPropertyChangeListener((PropertyChangeListener)this.listener);
                    status.module = nue;
                    this.moduleChanged(nue, status);
                    continue;
                }
                Util.err.fine("moduleListChanged: deleted: " + status.module);
                it.remove();
                try {
                    this.deleteFromDisk(status.module, status);
                }
                catch (IOException ioe) {
                    Util.err.log(Level.WARNING, null, ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleChanged(Module m, DiskStatus status) {
        DiskStatus diskStatus = status;
        synchronized (diskStatus) {
            Map<String, Object> newProps;
            if (Util.err.isLoggable(Level.FINE)) {
                Util.err.fine("ModuleList: moduleChanged: " + m);
            }
            if (!Utilities.compareObjects(status.diskProps, newProps = this.computeProperties(m))) {
                if (Util.err.isLoggable(Level.FINE)) {
                    HashSet<Map.Entry<String, Object>> changes = new HashSet<Map.Entry<String, Object>>(newProps.entrySet());
                    changes.removeAll(status.diskProps.entrySet());
                    Util.err.fine("ModuleList: changes are " + changes);
                }
                status.diskProps = newProps;
                try {
                    this.writeOut(m, status);
                }
                catch (IOException ioe) {
                    Util.err.log(Level.WARNING, null, ioe);
                }
            }
        }
    }

    private Map<String, Object> computeProperties(Module m) {
        SpecificationVersion spec;
        if (m.isFixed() || !m.isValid()) {
            throw new IllegalArgumentException("fixed or invalid: " + m);
        }
        if (!(m.getHistory() instanceof ModuleHistory)) {
            throw new IllegalArgumentException("weird history: " + m);
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("name", m.getCodeNameBase());
        int rel = m.getCodeNameRelease();
        if (rel >= 0) {
            p.put("release", new Integer(rel));
        }
        if ((spec = m.getSpecificationVersion()) != null) {
            p.put("specversion", spec);
        }
        if (!m.isAutoload() && !m.isEager()) {
            p.put("enabled", m.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
        }
        p.put("autoload", m.isAutoload() ? Boolean.TRUE : Boolean.FALSE);
        p.put("eager", m.isEager() ? Boolean.TRUE : Boolean.FALSE);
        p.put("reloadable", m.isReloadable() ? Boolean.TRUE : Boolean.FALSE);
        ModuleHistory hist = (ModuleHistory)m.getHistory();
        p.put("jar", hist.getJar());
        if (hist.getInstallerStateChanged()) {
            p.put("installer", m.getCodeNameBase().replace('.', '-') + ".ser");
            p.put("installerState", hist.getInstallerState());
        }
        return p;
    }

    private static final class DiskStatus {
        public Module module;
        public FileObject file;
        public boolean pendingInstall = false;
        public Map<String, Object> diskProps;
        public boolean dirty = false;

        public String toString() {
            return "DiskStatus[module=" + this.module + ",valid=" + this.module.isValid() + ",file=" + this.file + ",dirty=" + this.dirty + ",pendingInstall=" + this.pendingInstall + ",diskProps=" + this.diskProps + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Listener
    implements PropertyChangeListener,
    ErrorHandler,
    EntityResolver,
    FileChangeListener,
    Runnable {
        private boolean listening = true;
        private boolean pendingRun = false;

        Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!ModuleList.this.triggered) {
                throw new IllegalStateException("Property change before trigger()");
            }
            String prop = evt.getPropertyName();
            Object src = evt.getSource();
            if (!this.listening) {
                if (Util.err.isLoggable(Level.FINE)) {
                    Util.err.fine("ModuleList: ignoring own change " + prop + " from " + src);
                }
                return;
            }
            if ("classLoader".equals(prop) || "enabledModules".equals(prop) || "classLoader".equals(prop) || "problems".equals(prop) || "valid".equals(prop)) {
                return;
            }
            if ("modules".equals(prop)) {
                ModuleList.this.moduleListChanged();
            } else if (src instanceof Module) {
                Module m = (Module)src;
                if (!m.isValid()) {
                    return;
                }
                DiskStatus status = (DiskStatus)ModuleList.this.statuses.get(m.getCodeNameBase());
                if (status == null) {
                    throw new IllegalStateException("Unknown module " + m + "; statuses=" + ModuleList.this.statuses);
                }
                if (status.pendingInstall && "enabled".equals(prop)) {
                    throw new IllegalStateException("Got PROP_ENABLED on " + m + " before trigger()");
                }
                ModuleList.this.moduleChanged(m, status);
            } else {
                Util.err.fine("Unexpected property change: " + evt + " prop=" + prop + " src=" + src);
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            Util.err.log(Level.WARNING, null, e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public InputSource resolveEntity(String pubid, String sysid) throws SAXException, IOException {
            if (pubid.equals(ModuleList.PUBLIC_ID)) {
                return new InputSource(ModuleList.class.getResource("module-status-1_0.dtd").toExternalForm());
            }
            return EntityCatalog.getDefault().resolveEntity(pubid, sysid);
        }

        public void fileDeleted(FileEvent ev) {
            if (this.isOurs(ev)) {
                if (Util.err.isLoggable(Level.FINE)) {
                    Util.err.fine("ModuleList: got expected deletion " + ev);
                }
                return;
            }
            FileObject fo = ev.getFile();
            this.fileDeleted0(fo.getName(), fo.getExt());
        }

        public void fileDataCreated(FileEvent ev) {
            if (this.isOurs(ev)) {
                if (Util.err.isLoggable(Level.FINE)) {
                    Util.err.fine("ModuleList: got expected creation " + ev);
                }
                return;
            }
            FileObject fo = ev.getFile();
            this.fileCreated0(fo.getName(), fo.getExt());
        }

        public void fileRenamed(FileRenameEvent ev) {
            if (this.isOurs((FileEvent)ev)) {
                throw new IllegalStateException("I don't rename anything! " + ev);
            }
            FileObject fo = ev.getFile();
            this.fileDeleted0(ev.getName(), ev.getExt());
            this.fileCreated0(fo.getName(), fo.getExt());
        }

        private void fileCreated0(String name, String ext) {
            if ("xml".equals(ext)) {
                String codenamebase = name.replace('-', '.');
                DiskStatus status = (DiskStatus)ModuleList.this.statuses.get(codenamebase);
                Util.err.fine("ModuleList: outside file creation event for " + codenamebase);
                if (status != null) {
                    status.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(ext)) {
                // empty if block
            }
        }

        private void fileDeleted0(String name, String ext) {
            if ("xml".equals(ext)) {
                String codenamebase = name.replace('-', '.');
                DiskStatus status = (DiskStatus)ModuleList.this.statuses.get(codenamebase);
                Util.err.fine("ModuleList: outside file deletion event for " + codenamebase);
                if (status != null) {
                    status.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(ext)) {
                // empty if block
            }
        }

        public void fileChanged(FileEvent ev) {
            if (this.isOurs(ev)) {
                if (Util.err.isLoggable(Level.FINE)) {
                    Util.err.fine("ModuleList: got expected modification " + ev);
                }
                return;
            }
            FileObject fo = ev.getFile();
            String name = fo.getName();
            String ext = fo.getExt();
            if ("xml".equals(ext)) {
                String codenamebase = name.replace('-', '.');
                DiskStatus status = (DiskStatus)ModuleList.this.statuses.get(codenamebase);
                Util.err.fine("ModuleList: outside file modification event for " + codenamebase + ": " + ev);
                if (status != null) {
                    status.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(ext)) {
                // empty if block
            }
        }

        public void fileFolderCreated(FileEvent ev) {
        }

        public void fileAttributeChanged(FileAttributeEvent ev) {
        }

        private boolean isOurs(FileEvent ev) {
            Iterator it = ModuleList.this.myAtomicActions.iterator();
            while (it.hasNext()) {
                if (!ev.firedFrom((FileSystem.AtomicAction)it.next())) continue;
                return true;
            }
            return false;
        }

        private synchronized void runme() {
            if (!this.pendingRun) {
                this.pendingRun = true;
                if (rpListener == null) {
                    rpListener = new RequestProcessor("org.netbeans.core.modules.ModuleList.Listener");
                }
                rpListener.post((Runnable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Listener listener = this;
            synchronized (listener) {
                this.pendingRun = false;
            }
            Util.err.fine("ModuleList: will process outstanding external XML changes");
            ModuleList.this.mgr.mutexPrivileged().enterWriteAccess();
            try {
                ModuleList.this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        Map xmlfiles = Listener.this.prepareXMLFiles();
                        Map dirtyprops = Listener.this.prepareDirtyProps(xmlfiles);
                        Listener.this.listening = false;
                        try {
                            Listener.this.stepCheckReloadable(dirtyprops);
                            Listener.this.stepCreate(xmlfiles, dirtyprops);
                            Listener.this.stepEnable(dirtyprops);
                            Listener.this.stepDisable(dirtyprops);
                            Listener.this.stepDelete(xmlfiles);
                            Listener.this.stepCheckMisc(dirtyprops);
                            Listener.this.stepCheckSer(xmlfiles, dirtyprops);
                        }
                        finally {
                            Listener.this.listening = true;
                            Listener.this.stepUpdateProps(dirtyprops);
                            Listener.this.stepMarkClean();
                        }
                    }
                });
                Util.err.fine("ModuleList: finished processing outstanding external XML changes");
            }
            catch (IOException ioe) {
                Util.err.log(Level.WARNING, null, ioe);
            }
            finally {
                ModuleList.this.mgr.mutexPrivileged().exitWriteAccess();
            }
        }

        private Map<String, FileObject> prepareXMLFiles() {
            Util.err.fine("ModuleList: prepareXMLFiles");
            HashMap<String, FileObject> xmlfiles = new HashMap<String, FileObject>(100);
            FileObject[] kids = ModuleList.this.folder.getChildren();
            for (int i = 0; i < kids.length; ++i) {
                if (!kids[i].hasExt("xml")) continue;
                xmlfiles.put(kids[i].getName().replace('-', '.'), kids[i]);
            }
            return xmlfiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Map<String, Object>> prepareDirtyProps(Map<String, FileObject> xmlfiles) throws IOException {
            Util.err.fine("ModuleList: prepareDirtyProps");
            HashMap<String, Map<String, Object>> dirtyprops = new HashMap<String, Map<String, Object>>(100);
            for (Map.Entry<String, FileObject> entry : xmlfiles.entrySet()) {
                FileObject xmlfile;
                String cnb = entry.getKey();
                DiskStatus status = (DiskStatus)ModuleList.this.statuses.get(cnb);
                if (status != null && !status.dirty || (xmlfile = entry.getValue()) == null || !xmlfile.canRead()) continue;
                InputStream is = xmlfile.getInputStream();
                try {
                    InputSource src = new InputSource(is);
                    src.setSystemId(xmlfile.getURL().toString());
                    try {
                        dirtyprops.put(cnb, ModuleList.this.readStatus(src, null));
                    }
                    catch (SAXException saxe) {
                        throw (IOException)new IOException(saxe.toString()).initCause(saxe);
                    }
                }
                finally {
                    is.close();
                }
            }
            return dirtyprops;
        }

        private void stepCheckReloadable(Map<String, Map<String, Object>> dirtyprops) {
            Util.err.fine("ModuleList: stepCheckReloadable");
            for (Map.Entry<String, Map<String, Object>> entry : dirtyprops.entrySet()) {
                boolean diskReloadable;
                String cnb = entry.getKey();
                DiskStatus status = (DiskStatus)ModuleList.this.statuses.get(cnb);
                if (status == null) continue;
                Map<String, Object> props = entry.getValue();
                Boolean diskReloadableB = (Boolean)props.get("reloadable");
                boolean bl = diskReloadable = diskReloadableB != null ? diskReloadableB : false;
                boolean memReloadable = status.module.isReloadable();
                if (memReloadable == diskReloadable) continue;
                Util.err.fine("Disk change in reloadable for " + cnb + " from " + memReloadable + " to " + diskReloadable);
                status.module.setReloadable(diskReloadable);
            }
        }

        private void stepCreate(Map<String, FileObject> xmlfiles, Map<String, Map<String, Object>> dirtyprops) throws IOException {
            Util.err.fine("ModuleList: stepCreate");
            for (Map.Entry<String, FileObject> entry : xmlfiles.entrySet()) {
                Map<String, Object> statusProps;
                Module m;
                String cnb = entry.getKey();
                if (ModuleList.this.statuses.containsKey(cnb)) continue;
                FileObject xmlfile = entry.getValue();
                Map<String, Object> props = dirtyprops.get(cnb);
                if (!cnb.equals(props.get("name"))) {
                    throw new IOException("Code name mismatch");
                }
                String jar = (String)props.get("jar");
                File jarFile = ModuleList.this.findJarByName(jar, cnb);
                Boolean reloadableB = (Boolean)props.get("reloadable");
                boolean reloadable = reloadableB != null ? reloadableB : false;
                Boolean autoloadB = (Boolean)props.get("autoload");
                boolean autoload = autoloadB != null ? autoloadB : false;
                Boolean eagerB = (Boolean)props.get("eager");
                boolean eager = eagerB != null ? eagerB : false;
                try {
                    m = ModuleList.this.mgr.create(jarFile, (Object)new ModuleHistory(jar), reloadable, autoload, eager);
                }
                catch (DuplicateException dupe) {
                    throw (IOException)new IOException(dupe.toString()).initCause(dupe);
                }
                m.addPropertyChangeListener((PropertyChangeListener)this);
                if (props.get("enabled") != null && ((Boolean)props.get("enabled")).booleanValue()) {
                    statusProps = new HashMap<String, Object>(props);
                    statusProps.put("enabled", Boolean.FALSE);
                } else {
                    statusProps = props;
                }
                DiskStatus status = new DiskStatus();
                status.module = m;
                status.file = xmlfile;
                status.diskProps = statusProps;
                ModuleList.this.statuses.put(cnb, status);
            }
        }

        private void stepEnable(Map<String, Map<String, Object>> dirtyprops) throws IOException {
            Util.err.fine("ModuleList: stepEnable");
            HashSet<Module> toenable = new HashSet<Module>();
            for (Map.Entry<String, Map<String, Object>> entry : dirtyprops.entrySet()) {
                String cnb = entry.getKey();
                Map<String, Object> props = entry.getValue();
                if (props.get("enabled") == null || !((Boolean)props.get("enabled")).booleanValue()) continue;
                DiskStatus status = (DiskStatus)ModuleList.this.statuses.get(cnb);
                if (status.diskProps.get("enabled") != null && ((Boolean)status.diskProps.get("enabled")).booleanValue()) continue;
                if (status.module.isEnabled()) {
                    throw new IllegalStateException("Already enabled: " + status.module);
                }
                toenable.add(status.module);
            }
            ModuleList.this.installNew(toenable);
        }

        private void stepDisable(Map<String, Map<String, Object>> dirtyprops) throws IOException {
            Util.err.fine("ModuleList: stepDisable");
            HashSet<Module> todisable = new HashSet<Module>();
            for (Map.Entry<String, Map<String, Object>> entry : dirtyprops.entrySet()) {
                String cnb = entry.getKey();
                Map<String, Object> props = entry.getValue();
                if (props.get("enabled") != null && ((Boolean)props.get("enabled")).booleanValue()) continue;
                DiskStatus status = (DiskStatus)ModuleList.this.statuses.get(cnb);
                if (status.diskProps.get("enabled") == null || !((Boolean)status.diskProps.get("enabled")).booleanValue()) continue;
                if (!status.module.isEnabled()) {
                    throw new IllegalStateException("Already disabled: " + status.module);
                }
                todisable.add(status.module);
            }
            if (todisable.isEmpty()) {
                return;
            }
            List reallydisable = ModuleList.this.mgr.simulateDisable(todisable);
            for (Module m : reallydisable) {
                if (m.isAutoload() || m.isEager() || todisable.contains(m)) continue;
                todisable.add(m);
            }
            ModuleList.this.mgr.disable(todisable);
        }

        private void stepDelete(Map<String, FileObject> xmlfiles) throws IOException {
            Module m3;
            Util.err.fine("ModuleList: stepDelete");
            HashSet<Module> todelete = new HashSet<Module>();
            Iterator it = ModuleList.this.statuses.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String cnb = (String)entry.getKey();
                DiskStatus status = (DiskStatus)entry.getValue();
                if (xmlfiles.containsKey(cnb)) continue;
                m3 = status.module;
                todelete.add(m3);
                it.remove();
            }
            if (todelete.isEmpty()) {
                return;
            }
            HashSet<Module> todisable = new HashSet<Module>();
            for (Module m2 : todelete) {
                if (!m2.isEnabled() || m2.isAutoload() || m2.isEager()) continue;
                todisable.add(m2);
            }
            List reallydisable = ModuleList.this.mgr.simulateDisable(todisable);
            for (Module m3 : reallydisable) {
                if (m3.isAutoload() || m3.isEager() || todisable.contains(m3)) continue;
                todisable.add(m3);
            }
            ModuleList.this.mgr.disable(todisable);
            Iterator delIt = todelete.iterator();
            while (delIt.hasNext()) {
                m3 = (Module)delIt.next();
                if (m3.isEnabled()) {
                    if (!m3.isAutoload() && !m3.isEager()) {
                        throw new IllegalStateException("Module " + m3 + " scheduled for deletion could not be disabled yet was not an autoload nor eager");
                    }
                    ModuleList.this.ev.log("cantDeleteEnabledAutoload", new Object[]{m3});
                    delIt.remove();
                    continue;
                }
                ModuleList.this.mgr.delete(m3);
            }
        }

        private void stepCheckMisc(Map dirtyprops) {
            Util.err.fine("ModuleList: stepCheckMisc");
            String[] toCheck = new String[]{"jar", "autoload", "eager", "release", "specversion"};
            for (Map.Entry entry : dirtyprops.entrySet()) {
                String cnb = (String)entry.getKey();
                Map props = (Map)entry.getValue();
                DiskStatus status = (DiskStatus)ModuleList.this.statuses.get(cnb);
                Map<String, Object> diskProps = status.diskProps;
                for (int i = 0; i < toCheck.length; ++i) {
                    Object inMem;
                    String prop = toCheck[i];
                    Object onDisk = props.get(prop);
                    if (Utilities.compareObjects(onDisk, (Object)(inMem = diskProps.get(prop)))) continue;
                    ModuleList.this.ev.log("miscPropMismatch", new Object[]{status.module, prop, onDisk, inMem});
                }
            }
        }

        private void stepCheckSer(Map xmlfiles, Map dirtyprops) {
        }

        private void stepUpdateProps(Map<String, Map<String, Object>> dirtyprops) {
            Util.err.fine("ModuleList: stepUpdateProps");
            for (Map.Entry<String, Map<String, Object>> entry : dirtyprops.entrySet()) {
                String cnb = entry.getKey();
                DiskStatus status = (DiskStatus)ModuleList.this.statuses.get(cnb);
                if (status == null) continue;
                Map<String, Object> props = entry.getValue();
                status.diskProps = props;
            }
        }

        private void stepMarkClean() {
            Util.err.fine("ModuleList: stepMarkClean");
            for (DiskStatus status : ModuleList.this.statuses.values()) {
                status.dirty = false;
            }
        }
    }
}

