/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.netbeans.core.startup.CLIOptions;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXParseException;

public final class TopLogging {
    private static boolean disabledConsole = !Boolean.getBoolean("netbeans.logger.console");
    private static final PrintStream OLD_ERR = System.err;
    private static String previousUser;
    private static Handler streamHandler;
    private static Handler defaultHandler;

    public TopLogging() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            String key = (String)e.getKey();
            if ("sun.os.patch.level".equals(key)) continue;
            String v = (String)e.getValue();
            if (!key.endsWith(".level")) continue;
            ps.print(key);
            ps.print("=");
            ps.println(v);
        }
        ps.close();
        try {
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(os.toByteArray()));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Logger logger = Logger.getLogger("");
        Handler[] old = logger.getHandlers();
        for (int i = 0; i < old.length; ++i) {
            logger.removeHandler(old[i]);
        }
        logger.addHandler(TopLogging.defaultHandler());
        if (!disabledConsole) {
            logger.addHandler(TopLogging.streamHandler());
        }
        logger.addHandler(new LookupDel());
    }

    public static void initializeQuietly() {
        TopLogging.initialize(false);
    }

    static final void initialize() {
        TopLogging.initialize(true);
    }

    private static void initialize(boolean verbose) {
        block7: {
            if (previousUser == null || previousUser.equals(System.getProperty("netbeans.user"))) {
                streamHandler = null;
                defaultHandler = null;
            }
            if (System.getProperty("java.util.logging.config.file") != null) {
                return;
            }
            String v = System.getProperty("java.util.logging.config.class");
            String p = TopLogging.class.getName();
            if (v != null && !v.equals(p)) {
                return;
            }
            new TopLogging();
            System.setProperty("java.util.logging.config.class", p);
            if (verbose) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(os);
                TopLogging.printSystemInfo(ps);
                ps.close();
                try {
                    Logger logger = Logger.getLogger(TopLogging.class.getName());
                    logger.log(Level.INFO, os.toString("utf-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
        }
        if (!(System.err instanceof LgStream)) {
            System.setErr(new LgStream(Logger.getLogger("stderr")));
        }
    }

    private static void printSystemInfo(PrintStream ps) {
        DateFormat df = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        Date date = new Date();
        ps.println("-------------------------------------------------------------------------------");
        ps.println(">Log Session: " + df.format(date));
        ps.println(">System Info: ");
        String buildNumber = System.getProperty("netbeans.buildnumber");
        String currentVersion = NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)buildNumber);
        ps.println("  Product Version         = " + currentVersion);
        ps.println("  Operating System        = " + System.getProperty("os.name", "unknown") + " version " + System.getProperty("os.version", "unknown") + " running on " + System.getProperty("os.arch", "unknown"));
        ps.println("  Java; VM; Vendor; Home  = " + System.getProperty("java.version", "unknown") + "; " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "") + "; " + System.getProperty("java.vendor", "unknown") + "; " + System.getProperty("java.home", "unknown"));
        ps.print("  System Locale; Encoding = " + Locale.getDefault());
        String branding = NbBundle.getBranding();
        if (branding != null) {
            ps.print(" (" + branding + ")");
        }
        ps.println("; " + System.getProperty("file.encoding", "unknown"));
        ps.println("  Home Dir.; Current Dir. = " + System.getProperty("user.home", "unknown") + "; " + System.getProperty("user.dir", "unknown"));
        ps.print("  Installation; User Dir. = ");
        String nbdirs = System.getProperty("netbeans.dirs");
        if (nbdirs != null) {
            StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                ps.print(FileUtil.normalizeFile((File)new File(tok.nextToken())));
                ps.print(File.pathSeparatorChar);
            }
        }
        ps.println(CLIOptions.getHomeDir() + "; " + CLIOptions.getUserDir());
        ps.println("  Boot & Ext. Classpath   = " + TopLogging.createBootClassPath());
        ps.println("  Application Classpath   = " + System.getProperty("java.class.path", "unknown"));
        ps.println("  Startup Classpath       = " + System.getProperty("netbeans.dynamic.classpath", "unknown"));
        ps.println("-------------------------------------------------------------------------------");
    }

    private static String createBootClassPath() {
        String boot = System.getProperty("sun.boot.class.path");
        StringBuffer sb = boot != null ? new StringBuffer(boot) : new StringBuffer();
        TopLogging.findBootJars(System.getProperty("java.ext.dirs"), sb);
        TopLogging.findBootJars(System.getProperty("java.endorsed.dirs"), sb);
        return sb.toString();
    }

    private static void findBootJars(String extensions, StringBuffer sb) {
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                File[] entries = dir.listFiles();
                if (entries == null) continue;
                for (int i = 0; i < entries.length; ++i) {
                    String name = entries[i].getName().toLowerCase(Locale.US);
                    if (!name.endsWith(".zip") && !name.endsWith(".jar")) continue;
                    if (sb.length() > 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(entries[i].getPath());
                }
            }
        }
    }

    static Handler createStreamHandler(PrintStream pw) {
        StreamHandler s = new StreamHandler(pw, NbFormatter.FORMATTER);
        return s;
    }

    private static synchronized Handler streamHandler() {
        if (streamHandler == null) {
            StreamHandler sth = new StreamHandler(OLD_ERR, NbFormatter.FORMATTER);
            sth.setLevel(Level.ALL);
            streamHandler = new NonClose(sth, 500);
        }
        return streamHandler;
    }

    private static synchronized Handler defaultHandler() {
        if (defaultHandler != null) {
            return defaultHandler;
        }
        String home = System.getProperty("netbeans.user");
        if (home != null && !"memory".equals(home) && !CLIOptions.noLogging) {
            try {
                File dir = new File(new File(new File(home), "var"), "log");
                dir.mkdirs();
                File f = new File(dir, "messages.log");
                File f1 = new File(dir, "messages.log.1");
                File f2 = new File(dir, "messages.log.2");
                if (f1.exists()) {
                    f1.renameTo(f2);
                }
                if (f.exists()) {
                    f.renameTo(f1);
                }
                FileOutputStream fout = new FileOutputStream(f, false);
                StreamHandler h = new StreamHandler(fout, NbFormatter.FORMATTER);
                h.setLevel(Level.ALL);
                h.setFormatter(NbFormatter.FORMATTER);
                defaultHandler = new NonClose(h, 5000);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (defaultHandler == null) {
            defaultHandler = TopLogging.streamHandler();
            disabledConsole = true;
        }
        return defaultHandler;
    }

    static void flush(boolean clear) {
        Handler d;
        Handler s = streamHandler;
        if (s != null) {
            s.flush();
        }
        if ((d = defaultHandler) != null) {
            d.flush();
        }
        if (clear) {
            streamHandler = null;
            defaultHandler = null;
        }
    }

    static void close() {
        Handler d;
        Handler s = streamHandler;
        if (s instanceof NonClose) {
            NonClose ns = (NonClose)s;
            ns.doClose();
        }
        if ((d = defaultHandler) != null) {
            NonClose nd = (NonClose)d;
            nd.doClose();
        }
    }

    public static void printStackTrace(Throwable t, PrintWriter pw) {
        StackTraceElement[] tStack = t.getStackTrace();
        StackTraceElement[] hereStack = new Throwable().getStackTrace();
        int idx = -1;
        for (int i = 1; i <= Math.min(tStack.length, hereStack.length); ++i) {
            if (tStack[tStack.length - i].equals(hereStack[hereStack.length - i])) continue;
            idx = tStack.length - i;
            break;
        }
        TopLogging.doPrintStackTrace(pw, t, null, idx);
    }

    private static void doPrintStackTrace(PrintWriter pw, Throwable t, Throwable higher, int caughtIndex) {
        int end;
        String suffix;
        Throwable lower;
        block10: {
            try {
                if (t.getClass().getMethod("printStackTrace", PrintWriter.class).getDeclaringClass() != Throwable.class) {
                    t.printStackTrace(pw);
                    return;
                }
            }
            catch (NoSuchMethodException e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)e);
            }
        }
        if ((lower = t.getCause()) != null) {
            TopLogging.doPrintStackTrace(pw, lower, t, -1);
            pw.print("Caused: ");
        }
        String summary = t.toString();
        if (lower != null && summary.endsWith(suffix = ": " + lower)) {
            summary = summary.substring(0, summary.length() - suffix.length());
        }
        pw.println(summary);
        StackTraceElement[] trace = t.getStackTrace();
        if (higher != null) {
            int higherEnd;
            StackTraceElement[] higherTrace = higher.getStackTrace();
            for (end = trace.length; end > 0 && (higherEnd = end + higherTrace.length - trace.length) > 0 && higherTrace[higherEnd - 1].equals(trace[end - 1]); --end) {
            }
        }
        for (int i = 0; i < end; ++i) {
            if (i == caughtIndex) {
                pw.print("[catch] at ");
            } else {
                pw.print("\tat ");
            }
            pw.println(trace[i]);
        }
    }

    static {
        System.setProperty("sun.awt.exception.handler", "org.netbeans.core.startup.TopLogging$AWTHandler");
    }

    public static final class AWTHandler {
        public static void handle(Throwable t) {
            if (t.getClass().getName().endsWith(".ExitSecurityException")) {
                return;
            }
            Logger.global.log(Level.SEVERE, null, t);
        }
    }

    private static final class LgStream
    extends PrintStream {
        private Logger log;
        private StringBuffer sb = new StringBuffer();
        private ThreadLocal<Integer> FLUSHING = new ThreadLocal();

        public LgStream(Logger log) {
            super(new ByteArrayOutputStream());
            this.log = log;
        }

        public void write(byte[] buf, int off, int len) {
            if (this.FLUSHING.get() != null) {
                return;
            }
            this.sb.append(new String(buf, off, len));
            this.checkFlush();
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(int b) {
            if (this.FLUSHING.get() != null) {
                return;
            }
            this.sb.append((char)b);
            this.checkFlush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkFlush() {
            try {
                this.FLUSHING.set(1);
                this.doFlush();
            }
            finally {
                this.FLUSHING.set(null);
            }
        }

        private void doFlush() {
            int first;
            boolean justNewLine = false;
            while ((first = this.sb.indexOf("\n")) >= 0) {
                justNewLine = false;
                if (first == 0) {
                    justNewLine = true;
                    this.sb.delete(0, 1);
                    continue;
                }
                this.log.log(Level.INFO, this.sb.substring(0, first + 1));
                this.sb.delete(0, first + 1);
            }
            if (justNewLine) {
                this.log.log(Level.INFO, "\n");
            }
        }
    }

    private static final class LookupDel
    extends Handler
    implements LookupListener {
        private Lookup.Result<Handler> handlers = Lookup.getDefault().lookupResult(Handler.class);
        private Collection<? extends Handler> instances = this.handlers.allInstances();

        public LookupDel() {
            this.handlers.addLookupListener((LookupListener)this);
        }

        public void publish(LogRecord record) {
            for (Handler handler : this.instances) {
                handler.publish(record);
            }
        }

        public void flush() {
            for (Handler handler : this.instances) {
                handler.flush();
            }
        }

        public void close() throws SecurityException {
            for (Handler handler : this.instances) {
                handler.close();
            }
        }

        public void resultChanged(LookupEvent ev) {
            this.instances = this.handlers.allInstances();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NbFormatter
    extends Formatter {
        private static String lineSeparator = System.getProperty("line.separator");
        static Formatter FORMATTER = new NbFormatter();

        private NbFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            this.print(sb, record, new HashSet<Throwable>());
            return sb.toString();
        }

        private void print(StringBuilder sb, LogRecord record, Set<Throwable> beenThere) {
            String message = this.formatMessage(record);
            if (message != null && message.indexOf(10) != -1 && record.getThrown() == null) {
                sb.append(message);
                return;
            }
            if ("stderr".equals(record.getLoggerName()) && record.getLevel() == Level.INFO) {
                sb.append(message);
                return;
            }
            sb.append(record.getLevel().getLocalizedName());
            NbFormatter.addLoggerName(sb, record);
            if (message != null) {
                sb.append(": ");
                sb.append(message);
            }
            sb.append(lineSeparator);
            if (record.getThrown() != null && record.getLevel().intValue() != 1973) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    TopLogging.printStackTrace(record.getThrown(), pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                LogRecord[] arr = NbFormatter.extractDelegates(sb, record.getThrown(), beenThere);
                if (arr != null) {
                    for (LogRecord r : arr) {
                        this.print(sb, r, beenThere);
                    }
                }
                this.specialProcessing(sb, record.getThrown(), beenThere);
            }
        }

        private static void addLoggerName(StringBuilder sb, LogRecord record) {
            String name = record.getLoggerName();
            if (!"".equals(name)) {
                sb.append(" [");
                sb.append(name);
                sb.append(']');
            }
        }

        private static LogRecord[] extractDelegates(StringBuilder sb, Throwable t, Set<Throwable> beenThere) {
            if (!beenThere.add(t)) {
                sb.append("warning: cyclic dependency between annotated throwables");
                return null;
            }
            if (t instanceof Callable) {
                Object rec = null;
                try {
                    rec = ((Callable)((Object)t)).call();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (rec instanceof LogRecord[]) {
                    return rec;
                }
            }
            if (t == null) {
                return null;
            }
            return NbFormatter.extractDelegates(sb, t.getCause(), beenThere);
        }

        private void specialProcessing(StringBuilder sb, Throwable t, Set<Throwable> beenThere) {
            if (t instanceof MissingResourceException) {
                String k;
                MissingResourceException mre = (MissingResourceException)t;
                String cn = mre.getClassName();
                if (cn != null) {
                    LogRecord rec = new LogRecord(Level.CONFIG, null);
                    rec.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    rec.setMessage("EXC_MissingResourceException_class_name");
                    rec.setParameters(new Object[]{cn});
                    this.print(sb, rec, beenThere);
                }
                if ((k = mre.getKey()) != null) {
                    LogRecord rec = new LogRecord(Level.CONFIG, null);
                    rec.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    rec.setMessage("EXC_MissingResourceException_key");
                    rec.setParameters(new Object[]{k});
                    this.print(sb, rec, beenThere);
                }
            }
            if (t instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)t;
                String pubid = spe.getPublicId();
                String sysid = spe.getSystemId();
                if (pubid != null || sysid != null) {
                    Object[] param;
                    String msg;
                    int col = spe.getColumnNumber();
                    int line = spe.getLineNumber();
                    if (col != -1 || line != -1) {
                        msg = "EXC_sax_parse_col_line";
                        param = new Object[]{String.valueOf(pubid), String.valueOf(sysid), new Integer(col), new Integer(line)};
                    } else {
                        msg = "EXC_sax_parse";
                        param = new Object[]{String.valueOf(pubid), String.valueOf(sysid)};
                    }
                    LogRecord rec = new LogRecord(Level.CONFIG, null);
                    rec.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    rec.setMessage(msg);
                    rec.setParameters(param);
                    this.print(sb, rec, beenThere);
                }
            }
        }
    }

    private static final class NonClose
    extends Handler
    implements Runnable {
        private static RequestProcessor RP = new RequestProcessor("Logging Flush");
        private final Handler delegate;
        private RequestProcessor.Task flush;
        private int delay;

        public NonClose(Handler h, int delay) {
            this.delegate = h;
            this.flush = RP.create((Runnable)this, true);
            this.flush.setPriority(1);
            this.delay = delay;
        }

        public void publish(LogRecord record) {
            this.delegate.publish(record);
            this.flush.schedule(this.delay);
        }

        public void flush() {
            this.flush.cancel();
            this.flush.waitFinished();
            this.delegate.flush();
        }

        public void close() throws SecurityException {
            this.flush();
            this.delegate.flush();
        }

        public void doClose() throws SecurityException {
            this.flush();
            this.delegate.close();
        }

        public Formatter getFormatter() {
            return this.delegate.getFormatter();
        }

        static Handler getInternal(Handler h) {
            if (h instanceof NonClose) {
                return ((NonClose)h).delegate;
            }
            return h;
        }

        public void run() {
            this.delegate.flush();
        }
    }
}

