/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.openide.util.NamedServicesProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class RecognizeInstanceFiles
extends NamedServicesProvider {
    private static final Logger LOG = Logger.getLogger(RecognizeInstanceFiles.class.getName());

    public Lookup create(String path) {
        return new OverFiles(path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FOItem
    extends AbstractLookup.Pair<Object> {
        private static Reference<Object> EMPTY = new WeakReference<Object>(null);
        private FileObject fo;
        private Reference<Object> ref = EMPTY;

        public FOItem(FileObject fo) {
            this.fo = fo;
        }

        protected boolean instanceOf(Class<?> c) {
            Object r = this.ref.get();
            if (r != null) {
                return c.isInstance(r);
            }
            return c.isAssignableFrom(this.getType());
        }

        protected boolean creatorOf(Object obj) {
            return this.ref.get() == obj;
        }

        public synchronized Object getInstance() {
            Object r = this.ref.get();
            if (r == null && (r = this.fo.getAttribute("instanceCreate")) != null) {
                this.ref = new WeakReference<Object>(r);
            }
            return r;
        }

        public Class<? extends Object> getType() {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = FOItem.class.getClassLoader();
            }
            try {
                return Class.forName(FOItem.getClassName(this.fo), false, l);
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.INFO, ex.getMessage(), ex);
                return Object.class;
            }
        }

        public String getId() {
            String s = this.fo.getPath();
            if (s.endsWith(".instance")) {
                s = s.substring(0, s.length() - ".instance".length());
            }
            return s;
        }

        public String getDisplayName() {
            String n = this.fo.getName();
            try {
                n = this.fo.getFileSystem().getStatus().annotateName(n, Collections.singleton(this.fo));
            }
            catch (FileStateInvalidException ex) {
                LOG.log(Level.WARNING, ex.getMessage(), ex);
            }
            return n;
        }

        private static String getClassName(FileObject fo) {
            int last;
            Object attr = fo.getAttribute("instanceClass");
            if (attr instanceof String) {
                return Utilities.translate((String)((String)attr));
            }
            if (attr != null) {
                LOG.warning("instanceClass was a " + attr.getClass().getName());
            }
            if ((attr = fo.getAttribute("instanceCreate")) != null) {
                return attr.getClass().getName();
            }
            String name = fo.getName();
            int first = name.indexOf(91) + 1;
            if (first != 0) {
                LOG.log(Level.WARNING, "Cannot understand {0}", fo);
            }
            if ((last = name.indexOf(93)) < 0) {
                last = name.length();
            }
            if (first < last) {
                name = name.substring(first, last);
            }
            name = name.replace('-', '.');
            name = Utilities.translate((String)name);
            return name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            FOItem other = (FOItem)((Object)obj);
            return this.fo == other.fo || this.fo != null && this.fo.equals(other.fo);
        }

        public int hashCode() {
            int hash = 3;
            hash = 11 * hash + (this.fo != null ? this.fo.hashCode() : 0);
            return hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrderAttribsMap
    implements Map<FOItem, List<FOItem>> {
        private final List<FOItem> all;

        public OrderAttribsMap(List<FOItem> all) {
            this.all = all;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FOItem> get(Object key) {
            if (key instanceof FOItem) {
                FOItem fi = (FOItem)((Object)key);
                FileObject folder = fi.fo.getParent();
                if (folder == null) {
                    return null;
                }
                HashSet<String> afterMeNames = new HashSet<String>();
                Enumeration it = folder.getAttributes();
                while (it.hasMoreElements()) {
                    String attr = (String)it.nextElement();
                    int slash = attr.indexOf(47);
                    if (slash == -1 || !fi.fo.getNameExt().equals(attr.substring(0, slash)) || !Boolean.TRUE.equals(folder.getAttribute(attr))) continue;
                    afterMeNames.add(attr.substring(slash + 1));
                }
                if (afterMeNames.isEmpty()) {
                    return null;
                }
                ArrayList<FOItem> afterMe = new ArrayList<FOItem>();
                for (FOItem foItem : this.all) {
                    if (!afterMeNames.contains(foItem.fo.getNameExt())) continue;
                    afterMe.add(foItem);
                }
                return afterMe;
            }
            return null;
        }

        @Override
        public List<FOItem> put(FOItem key, List<FOItem> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FOItem> remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends FOItem, ? extends List<FOItem>> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<FOItem> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<List<FOItem>> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<FOItem, List<FOItem>>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OverFiles
    extends ProxyLookup
    implements FileChangeListener {
        private final String path;
        private final FileChangeListener weakL;
        private final AbstractLookup.Content content;
        private final AbstractLookup lkp;

        public OverFiles(String path) {
            this(path, new ArrayList<FOItem>(), new AbstractLookup.Content());
        }

        private OverFiles(String path, List<FOItem> items, AbstractLookup.Content cnt) {
            this(path, items, new AbstractLookup(cnt), cnt);
        }

        private OverFiles(String path, List<FOItem> items, AbstractLookup lkp, AbstractLookup.Content cnt) {
            super(OverFiles.computeDelegates(path, items, (Lookup)lkp));
            this.path = path;
            this.lkp = lkp;
            this.content = cnt;
            try {
                items = Utilities.topologicalSort(items, (Map)new OrderAttribsMap(items));
            }
            catch (TopologicalSortException ex) {
                List l;
                items = l = ex.partialSort();
            }
            this.content.setPairs((Collection)items);
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            this.weakL = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fs);
            fs.addFileChangeListener(this.weakL);
        }

        private void refresh() {
            List<FOItem> items = new ArrayList<FOItem>();
            Lookup[] delegates = OverFiles.computeDelegates(this.path, items, (Lookup)this.lkp);
            try {
                items = Utilities.topologicalSort(items, (Map)new OrderAttribsMap(items));
            }
            catch (TopologicalSortException ex) {
                List l = ex.partialSort();
                items = l;
            }
            this.content.setPairs(items);
            this.setLookups(delegates);
        }

        private static Lookup[] computeDelegates(String p, List<FOItem> items, Lookup lkp) {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(p);
            LinkedList<Object> delegates = new LinkedList<Object>();
            delegates.add(lkp);
            if (fo != null) {
                for (FileObject f : fo.getChildren()) {
                    if (f.isFolder()) {
                        delegates.add((Object)new OverFiles(f.getPath()));
                        continue;
                    }
                    items.add(new FOItem(f));
                }
            }
            delegates.add(Lookups.metaInfServices((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/namedservices/" + p)));
            return delegates.toArray(new Lookup[0]);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.refresh();
        }

        public void fileDataCreated(FileEvent fe) {
            this.refresh();
        }

        public void fileChanged(FileEvent fe) {
            this.refresh();
        }

        public void fileDeleted(FileEvent fe) {
            this.refresh();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.refresh();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            this.refresh();
        }
    }
}

