/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.core.startup.preferences.PropertiesStorage;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

public abstract class NbPreferences
extends AbstractPreferences {
    private static Preferences USER_ROOT;
    private static Preferences SYSTEM_ROOT;
    Properties properties;
    FileStorage fileStorage;
    private static final RequestProcessor RP;
    final RequestProcessor.Task flushTask = RP.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = NbPreferences.this.lock;
            synchronized (object) {
                try {
                    NbPreferences.this.flushSpi();
                }
                catch (BackingStoreException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
    }, true);

    static Preferences userRootImpl() {
        if (USER_ROOT == null) {
            USER_ROOT = new UserPreferences();
        }
        assert (USER_ROOT != null);
        return USER_ROOT;
    }

    static Preferences systemRootImpl() {
        if (SYSTEM_ROOT == null) {
            SYSTEM_ROOT = new SystemPreferences();
        }
        assert (SYSTEM_ROOT != null);
        return SYSTEM_ROOT;
    }

    private NbPreferences(boolean user) {
        super(null, "");
        this.fileStorage = this.getFileStorage(this.absolutePath());
    }

    private NbPreferences(NbPreferences parent, String name) {
        super(parent, name);
        this.fileStorage = this.getFileStorage(this.absolutePath());
        this.newNode = !this.fileStorage.existsNode();
    }

    protected final String getSpi(String key) {
        return this.properties().getProperty(key);
    }

    protected final String[] childrenNamesSpi() throws BackingStoreException {
        return this.fileStorage.childrenNames();
    }

    protected final String[] keysSpi() throws BackingStoreException {
        return this.properties().keySet().toArray(new String[0]);
    }

    protected final void putSpi(String key, String value) {
        this.properties().put(key, value);
        this.fileStorage.markModified();
        this.asyncInvocationOfFlushSpi();
    }

    public void put(String key, String value) {
        String oldValue = this.getSpi(key);
        if (value.equals(oldValue)) {
            return;
        }
        try {
            super.put(key, value);
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().contains("too long")) {
                this.putSpi(key, value);
            }
            throw iae;
        }
    }

    protected final void removeSpi(String key) {
        this.properties().remove(key);
        this.fileStorage.markModified();
        this.asyncInvocationOfFlushSpi();
    }

    protected final void removeNodeSpi() throws BackingStoreException {
        try {
            this.fileStorage.removeNode();
        }
        catch (IOException ex) {
            throw new BackingStoreException(ex);
        }
    }

    void asyncInvocationOfFlushSpi() {
        if (!this.fileStorage.isReadOnly()) {
            this.flushTask.schedule(200);
        }
    }

    protected void flushSpi() throws BackingStoreException {
        try {
            this.fileStorage.save(this.properties());
        }
        catch (IOException ex) {
            throw new BackingStoreException(ex);
        }
    }

    protected void syncSpi() throws BackingStoreException {
        if (this.properties != null) {
            try {
                this.properties.clear();
                this.properties().putAll((Map<?, ?>)this.fileStorage.load());
            }
            catch (IOException ex) {
                throw new BackingStoreException(ex);
            }
        }
    }

    Properties properties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                this.properties().putAll((Map<?, ?>)this.fileStorage.load());
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return this.properties;
    }

    public final void removeNode() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        this.properties().clear();
        super.removeNode();
    }

    public final void flush() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        super.flush();
    }

    public final void sync() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        this.flushTask.waitFinished();
        super.sync();
    }

    protected abstract FileStorage getFileStorage(String var1);

    static {
        RP = new RequestProcessor();
    }

    static interface FileStorage {
        public boolean isReadOnly();

        public String[] childrenNames();

        public boolean existsNode();

        public void removeNode() throws IOException;

        public void markModified();

        public Properties load() throws IOException;

        public void save(Properties var1) throws IOException;
    }

    private static final class SystemPreferences
    extends NbPreferences {
        private SystemPreferences() {
            super(false);
        }

        private SystemPreferences(NbPreferences parent, String name) {
            super(parent, name);
        }

        protected AbstractPreferences childSpi(String name) {
            return new SystemPreferences(this, name);
        }

        protected FileStorage getFileStorage(String absolutePath) {
            return PropertiesStorage.instanceReadOnly(this.absolutePath());
        }
    }

    public static class UserPreferences
    extends NbPreferences {
        public UserPreferences() {
            super(true);
        }

        private UserPreferences(NbPreferences parent, String name) {
            super(parent, name);
        }

        protected AbstractPreferences childSpi(String name) {
            return new UserPreferences(this, name);
        }

        protected FileStorage getFileStorage(String absolutePath) {
            return PropertiesStorage.instance(this.absolutePath());
        }
    }
}

