/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.tasklist;

import java.awt.event.ActionListener;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tasklist.trampoline.Accessor;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.trampoline.TaskGroupFactory;
import org.netbeans.spi.tasklist.AccessorImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Task {
    private FileObject resource;
    private TaskGroup group;
    private String description;
    private int line;
    private ActionListener al;

    public static Task create(FileObject resource, String groupName, String description, int line) {
        return new Task(resource, Task.getTaskGroup(groupName), description, line, null);
    }

    public static Task create(FileObject resource, String groupName, String description, ActionListener al) {
        return new Task(resource, Task.getTaskGroup(groupName), description, -1, al);
    }

    private Task(FileObject resource, TaskGroup group, String description, int line, ActionListener al) {
        assert (null != group);
        assert (null != description);
        assert (null != resource);
        this.resource = resource;
        this.group = group;
        this.description = description;
        this.line = line;
        this.al = al;
    }

    FileObject getResource() {
        return this.resource;
    }

    TaskGroup getGroup() {
        return this.group;
    }

    String getDescription() {
        return this.description;
    }

    int getLine() {
        return this.line;
    }

    ActionListener getActionListener() {
        return this.al;
    }

    static TaskGroup createGroup(Map<String, String> attrs) {
        return TaskGroupFactory.create(attrs);
    }

    private static TaskGroup getTaskGroup(String groupName) {
        TaskGroup group = TaskGroupFactory.getDefault().getGroup(groupName);
        if (null == group) {
            Logger.getLogger(Task.class.getName()).log(Level.INFO, NbBundle.getMessage(Task.class, (String)"Err_UnknownGroupName"), groupName);
            group = TaskGroupFactory.getDefault().getDefaultGroup();
        }
        return group;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Task test = (Task)o;
        if (this.line != test.line) {
            return false;
        }
        if (this.description != test.description && this.description != null && !this.description.equals(test.description)) {
            return false;
        }
        if (this.group != test.group && this.group != null && !this.group.equals(test.group)) {
            return false;
        }
        return this.resource == test.resource || this.resource == null || this.resource.equals(test.resource);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + this.line;
        hash = 17 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 17 * hash + (this.group != null ? this.group.hashCode() : 0);
        hash = 17 * hash + (this.resource != null ? this.resource.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getResource());
        buffer.append(", ");
        buffer.append(this.getLine());
        buffer.append(", ");
        buffer.append(this.getDescription());
        buffer.append(", ");
        buffer.append(this.getGroup());
        buffer.append("]");
        return buffer.toString();
    }

    static {
        Accessor.DEFAULT = new AccessorImpl();
    }
}

