/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public final class RequestProcessor {
    private static RequestProcessor DEFAULT = new RequestProcessor();
    private static RequestProcessor UNLIMITED = new RequestProcessor("Default RequestProcessor", 50);
    private static Timer starterThread = new Timer(true);
    private static Logger logger;
    private static int counter;
    static final boolean SLOW;
    String name;
    boolean stopped = false;
    private Object processorLock = new Object();
    private HashSet<Processor> processors = new HashSet();
    private List<Item> queue = new LinkedList<Item>();
    private int running = 0;
    private int throughput;
    private boolean interruptThread;

    public RequestProcessor() {
        this(null, 1);
    }

    public RequestProcessor(String name) {
        this(name, 1);
    }

    public RequestProcessor(String name, int throughput) {
        this(name, throughput, false);
    }

    public RequestProcessor(String name, int throughput, boolean interruptThread) {
        this.throughput = throughput;
        this.name = name != null ? name : "OpenIDE-request-processor-" + counter++;
        this.interruptThread = interruptThread;
    }

    public static RequestProcessor getDefault() {
        return UNLIMITED;
    }

    public Task post(Runnable run) {
        return this.post(run, 0, 1);
    }

    public Task post(Runnable run, int timeToWait) {
        return this.post(run, timeToWait, 1);
    }

    public Task post(Runnable run, int timeToWait, int priority) {
        Task task = new Task(run, priority);
        task.schedule(timeToWait);
        return task;
    }

    public Task create(Runnable run) {
        return this.create(run, false);
    }

    public Task create(Runnable run, boolean initiallyFinished) {
        Task t = new Task(run);
        if (initiallyFinished) {
            t.notifyFinished();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestProcessorThread() {
        Thread c = Thread.currentThread();
        Object object = this.processorLock;
        synchronized (object) {
            return this.processors.contains(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this == UNLIMITED || this == DEFAULT) {
            throw new IllegalArgumentException("Can't stop shared RP's");
        }
        Object object = this.processorLock;
        synchronized (object) {
            this.stopped = true;
            for (Processor p : this.processors) {
                p.interrupt();
            }
        }
    }

    @Deprecated
    public static Task postRequest(Runnable run) {
        return DEFAULT.post(run);
    }

    @Deprecated
    public static Task postRequest(Runnable run, int timeToWait) {
        return DEFAULT.post(run, timeToWait);
    }

    @Deprecated
    public static Task postRequest(Runnable run, int timeToWait, int priority) {
        return DEFAULT.post(run, timeToWait, priority);
    }

    @Deprecated
    public static Task createRequest(Runnable run) {
        return DEFAULT.create(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Logger logger() {
        Timer timer = starterThread;
        synchronized (timer) {
            if (logger == null) {
                logger = Logger.getLogger("org.openide.util.RequestProcessor");
            }
            return logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Item item) {
        Logger em = RequestProcessor.logger();
        boolean loggable = em.isLoggable(Level.FINE);
        Object object = this.processorLock;
        synchronized (object) {
            if (item.getTask() == null) {
                if (loggable) {
                    em.fine("Null task for item " + item);
                }
                return;
            }
            this.prioritizedEnqueue(item);
            if (this.running < this.throughput) {
                ++this.running;
                Processor proc = Processor.get();
                this.processors.add(proc);
                proc.setName(this.name);
                proc.attachTo(this);
            }
        }
        if (loggable) {
            em.fine("Item enqueued: " + item.action + " status: " + item.enqueued);
        }
    }

    private void prioritizedEnqueue(Item item) {
        int iprio = item.getPriority();
        if (this.queue.isEmpty()) {
            this.queue.add(item);
            item.enqueued = true;
            return;
        }
        if (iprio > this.queue.get(this.queue.size() - 1).getPriority()) {
            ListIterator<Item> it = this.queue.listIterator();
            while (it.hasNext()) {
                Item next = it.next();
                if (iprio <= next.getPriority()) continue;
                it.set(item);
                it.add(next);
                item.enqueued = true;
                return;
            }
            throw new IllegalStateException("Prioritized enqueue failed!");
        }
        this.queue.add(item);
        item.enqueued = true;
    }

    Task askForWork(Processor worker, String debug) {
        if (this.stopped || this.queue.isEmpty()) {
            this.processors.remove(worker);
            Processor.put(worker, debug);
            --this.running;
            return null;
        }
        Item i = this.queue.remove(0);
        Task t = i.getTask();
        i.clear(worker);
        return t;
    }

    static {
        counter = 0;
        SLOW = Boolean.getBoolean("org.openide.util.RequestProcessor.Item.SLOW");
    }

    private class EnqueueTask
    extends TimerTask {
        Item itm;

        EnqueueTask(Item itm) {
            this.itm = itm;
        }

        public void run() {
            try {
                RequestProcessor.this.enqueue(this.itm);
            }
            catch (RuntimeException e) {
                Exceptions.printStackTrace(e);
            }
        }
    }

    private static class Item
    extends Exception {
        private final RequestProcessor owner;
        private Object action;
        private boolean enqueued;

        Item(Task task, RequestProcessor rp) {
            super("Posted StackTrace");
            this.action = task;
            this.owner = rp;
        }

        Task getTask() {
            Object a = this.action;
            return a instanceof Task ? (Task)a : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean clear(Processor processor) {
            Object object = this.owner.processorLock;
            synchronized (object) {
                this.action = processor;
                return this.enqueued ? this.owner.queue.remove(this) : true;
            }
        }

        Processor getProcessor() {
            Object a = this.action;
            return a instanceof Processor ? (Processor)a : null;
        }

        int getPriority() {
            return this.getTask().getPriority();
        }

        public Throwable fillInStackTrace() {
            return SLOW ? super.fillInStackTrace() : this;
        }
    }

    private static class Processor
    extends Thread {
        private static Stack<Processor> pool = new Stack();
        private static final int INACTIVE_TIMEOUT = 60000;
        private RequestProcessor source;
        private Task todo;
        private boolean idle = true;
        private Object lock = new Object();

        public Processor() {
            super(Processor.getTopLevelThreadGroup(), "Inactive RequestProcessor thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Processor get() {
            Stack<Processor> stack = pool;
            synchronized (stack) {
                if (pool.isEmpty()) {
                    Processor proc = new Processor();
                    proc.idle = false;
                    proc.start();
                    return proc;
                }
                Processor proc = pool.pop();
                proc.idle = false;
                return proc;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void put(Processor proc, String last) {
            Stack<Processor> stack = pool;
            synchronized (stack) {
                proc.setName("Inactive RequestProcessor thread [Was:" + proc.getName() + "/" + last + "]");
                proc.idle = true;
                pool.push(proc);
            }
        }

        void setPrio(int priority) {
            if (priority != this.getPriority()) {
                this.setPriority(priority);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachTo(RequestProcessor src) {
            Object object = this.lock;
            synchronized (object) {
                this.source = src;
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                RequestProcessor current = null;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        if (this.source == null) {
                            this.lock.wait(60000L);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    current = this.source;
                    this.source = null;
                    if (current == null) {
                        Stack<Processor> e = pool;
                        synchronized (e) {
                            if (this.idle) {
                                pool.remove(this);
                                break;
                            }
                            continue;
                        }
                    }
                }
                String debug = null;
                Logger em = RequestProcessor.logger();
                boolean loggable = em.isLoggable(Level.FINE);
                if (loggable) {
                    em.fine("Begining work " + this.getName());
                }
                while (true) {
                    Object object2 = current.processorLock;
                    synchronized (object2) {
                        this.todo = current.askForWork(this, debug);
                        if (this.todo == null) {
                            break;
                        }
                    }
                    this.setPrio(this.todo.getPriority());
                    try {
                        if (loggable) {
                            em.fine("  Executing " + this.todo);
                        }
                        this.todo.run();
                        if (loggable) {
                            em.fine("  Execution finished in" + this.getName());
                        }
                        debug = this.todo.debug();
                    }
                    catch (OutOfMemoryError oome) {
                        em.log(Level.SEVERE, null, oome);
                    }
                    catch (StackOverflowError e) {
                        e.printStackTrace();
                        Processor.doNotify(this.todo, e);
                    }
                    catch (Throwable t) {
                        Processor.doNotify(this.todo, t);
                    }
                    object2 = current.processorLock;
                    synchronized (object2) {
                        this.todo = null;
                        Thread.interrupted();
                    }
                }
                if (!loggable) continue;
                em.fine("Work finished " + this.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void doEvaluate(Task t, Object processorLock, RequestProcessor src) {
            Task previous = this.todo;
            boolean interrupted = Thread.interrupted();
            try {
                this.todo = t;
                t.run();
            }
            finally {
                Object object = processorLock;
                synchronized (object) {
                    this.todo = previous;
                    if ((interrupted || this.todo.item == null) && src.interruptThread) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void interruptTask(Task t, RequestProcessor src) {
            if (t != this.todo) {
                return;
            }
            if (src.interruptThread) {
                this.interrupt();
            }
        }

        private static void doNotify(Task todo, Throwable ex) {
            RequestProcessor.logger().log(Level.SEVERE, null, ex);
            if (SLOW) {
                logger.log(Level.SEVERE, null, todo.item);
            }
        }

        static ThreadGroup getTopLevelThreadGroup() {
            PrivilegedAction<ThreadGroup> run = new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    ThreadGroup current = Thread.currentThread().getThreadGroup();
                    while (current.getParent() != null) {
                        current = current.getParent();
                    }
                    return current;
                }
            };
            return AccessController.doPrivileged(run);
        }
    }

    public final class Task
    extends org.openide.util.Task
    implements Cancellable {
        private Item item;
        private int priority;
        private long time;
        private Thread lastThread;

        Task(Runnable run) {
            super(run);
            this.priority = 1;
            this.time = 0L;
            this.lastThread = null;
        }

        Task(Runnable run, int priority) {
            super(run);
            this.priority = 1;
            this.time = 0L;
            this.lastThread = null;
            if (priority < 1) {
                priority = 1;
            }
            if (priority > 10) {
                priority = 10;
            }
            this.priority = priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.notifyRunning();
                this.lastThread = Thread.currentThread();
                this.run.run();
            }
            finally {
                Item scheduled = this.item;
                if (scheduled == null || scheduled.getTask() != this) {
                    this.notifyFinished();
                }
                this.lastThread = null;
            }
        }

        public int getDelay() {
            long delay = this.time - System.currentTimeMillis();
            if (delay < 0L) {
                return 0;
            }
            if (delay > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)delay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(int delay) {
            Item localItem;
            if (RequestProcessor.this.stopped) {
                throw new IllegalStateException("RequestProcessor already stopped!");
            }
            this.time = System.currentTimeMillis() + (long)delay;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                this.notifyRunning();
                if (this.item != null) {
                    this.item.clear(null);
                }
                localItem = this.item = new Item(this, RequestProcessor.this);
            }
            if (delay == 0) {
                RequestProcessor.this.enqueue(localItem);
            } else {
                starterThread.schedule((TimerTask)new EnqueueTask(localItem), delay);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                boolean success;
                if (this.item == null) {
                    success = false;
                } else {
                    Processor p = this.item.getProcessor();
                    success = this.item.clear(null);
                    if (p != null) {
                        p.interruptTask(this, RequestProcessor.this);
                        this.item = null;
                    }
                }
                if (success) {
                    this.notifyFinished();
                }
                return success;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPriority(int priority) {
            if (this.priority == priority) {
                return;
            }
            if (priority < 1) {
                priority = 1;
            }
            if (priority > 10) {
                priority = 10;
            }
            this.priority = priority;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                if (this.item == null) {
                    return;
                }
                if (RequestProcessor.this.queue.remove(this.item)) {
                    RequestProcessor.this.prioritizedEnqueue(this.item);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFinished() {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean toRun;
                Logger em = RequestProcessor.logger();
                boolean loggable = em.isLoggable(Level.FINE);
                if (loggable) {
                    em.fine("Task.waitFinished on " + this + " from other task in RP: " + Thread.currentThread().getName());
                }
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    boolean bl = toRun = !this.isFinished() && (this.item == null || this.item.clear(null));
                    if (loggable) {
                        em.fine("    ## finished: " + this.isFinished());
                        em.fine("    ## item: " + this.item);
                    }
                }
                if (toRun) {
                    if (loggable) {
                        em.fine("    ## running it synchronously");
                    }
                    Processor processor = (Processor)Thread.currentThread();
                    processor.doEvaluate(this, RequestProcessor.this.processorLock, RequestProcessor.this);
                } else {
                    if (loggable) {
                        em.fine("    ## not running it synchronously");
                    }
                    if (this.lastThread != Thread.currentThread()) {
                        if (loggable) {
                            em.fine("    ## waiting for it to be finished");
                        }
                        super.waitFinished();
                    }
                }
                if (loggable) {
                    em.fine("    ## exiting waitFinished");
                }
            } else {
                super.waitFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitFinished(long timeout) throws InterruptedException {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean toRun;
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    toRun = !this.isFinished() && (this.item == null || this.item.clear(null));
                }
                if (toRun) {
                    throw new InterruptedException("Cannot wait with timeout " + timeout + " from the RequestProcessor thread for task: " + this);
                }
                if (this.lastThread != Thread.currentThread()) {
                    return super.waitFinished(timeout);
                }
                return true;
            }
            return super.waitFinished(timeout);
        }

        public String toString() {
            return "RequestProcessor.Task [" + RequestProcessor.this.name + ", " + this.priority + "] for " + super.toString();
        }
    }
}

