/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.plugins.SearchVisitor;

public class DeleteTransformer
extends SearchVisitor {
    public DeleteTransformer(WorkingCopy workingCopy) {
        super(workingCopy);
    }

    public Tree visitMethod(MethodTree tree, Element p) {
        this.deleteDeclIfMatch(tree, p);
        return (Tree)super.visitMethod(tree, p);
    }

    public Tree visitClass(ClassTree tree, Element p) {
        this.deleteDeclIfMatch(tree, p);
        return (Tree)super.visitClass(tree, p);
    }

    public Tree visitVariable(VariableTree tree, Element p) {
        this.deleteDeclIfMatch(tree, p);
        return (Tree)super.visitVariable(tree, p);
    }

    private void deleteDeclIfMatch(Tree tree, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return;
        }
        Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        if (((Object)elementToFind).equals(el)) {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            Tree newOne = null;
            if (parent.getKind() == Tree.Kind.CLASS) {
                newOne = this.make.removeClassMember((ClassTree)parent, tree);
            } else if (parent.getKind() == Tree.Kind.COMPILATION_UNIT) {
                newOne = this.make.removeCompUnitTypeDecl((CompilationUnitTree)parent, tree);
            }
            if (newOne != null) {
                this.workingCopy.rewrite(parent, newOne);
            }
            this.addUsage(this.getCurrentPath());
        }
    }
}

