/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    protected volatile boolean cancelRequest = false;
    private volatile CancellableTask currentTask;

    public void cancelRequest() {
        this.cancelRequest = true;
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
    }

    protected ClasspathInfo getClasspathInfo(AbstractRefactoring refactoring) {
        ClasspathInfo cpInfo = (ClasspathInfo)refactoring.getContext().lookup(ClasspathInfo.class);
        if (cpInfo == null) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "Missing scope (ClasspathInfo), using default scope (all open projects)");
            cpInfo = RetoucheUtils.getClasspathInfoFor(new FileObject[]{null});
            refactoring.getContext().add((Object)cpInfo);
        }
        return cpInfo;
    }

    protected static final Problem createProblem(Problem result, boolean isFatal, String message) {
        Problem problem = new Problem(isFatal, message);
        if (result == null) {
            return problem;
        }
        if (isFatal) {
            problem.setNext(result);
            return problem;
        }
        Problem p = result;
        while (p.getNext() != null) {
            p = p.getNext();
        }
        p.setNext(problem);
        return result;
    }

    protected static Problem isElementAvail(TreePathHandle e, CompilationInfo info) {
        if (e == null) {
            return new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
        }
        Element el = e.resolveElement(info);
        if (el == null || el.asType().getKind() == TypeKind.ERROR) {
            return new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"DSC_ElementNotResolved"));
        }
        return null;
    }

    private Iterable<? extends List<FileObject>> groupByRoot(Iterable<? extends FileObject> data) {
        HashMap<FileObject, LinkedList<FileObject>> result = new HashMap<FileObject, LinkedList<FileObject>>();
        for (FileObject fileObject : data) {
            FileObject root;
            ClassPath cp = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (cp == null || (root = cp.findOwnerRoot(fileObject)) == null) continue;
            LinkedList<FileObject> subr = (LinkedList<FileObject>)result.get(root);
            if (subr == null) {
                subr = new LinkedList<FileObject>();
                result.put(root, subr);
            }
            subr.add(fileObject);
        }
        return result.values();
    }

    protected final Collection<ModificationResult> processFiles(Set<FileObject> files, CancellableTask<WorkingCopy> task) {
        this.currentTask = task;
        Iterable<? extends List<FileObject>> work = this.groupByRoot(files);
        LinkedList<ModificationResult> results = new LinkedList<ModificationResult>();
        for (List<FileObject> list : work) {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)list.get(0)), list);
            try {
                results.add(javaSource.runModificationTask(task));
            }
            catch (IOException ex) {
                throw (RuntimeException)new RuntimeException().initCause(ex);
            }
        }
        return results;
    }
}

