/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.WhereUsedElement;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.plugins.FindOverridingVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindSubtypesVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindUsagesVisitor;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaWhereUsedQueryPlugin
extends JavaRefactoringPlugin {
    private WhereUsedQuery refactoring;

    public JavaWhereUsedQueryPlugin(WhereUsedQuery refactoring) {
        this.refactoring = refactoring;
    }

    private TreePathHandle getSearchHandle() {
        return (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    public Problem preCheck() {
        return null;
    }

    private Set<FileObject> getRelevantFiles(final TreePathHandle tph) {
        final ClasspathInfo cpInfo = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
        final ClassIndex idx = cpInfo.getClassIndex();
        final HashSet<FileObject> set = new HashSet<FileObject>();
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{tph.getFileObject()});
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController info) throws Exception {
                info.toPhase(JavaSource.Phase.RESOLVED);
                set.add(tph.getFileObject());
                Element el = tph.resolveElement((CompilationInfo)info);
                if (el.getKind().isField()) {
                    set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                } else if (el.getKind().isClass() || el.getKind().isInterface()) {
                    if (JavaWhereUsedQueryPlugin.this.isFindSubclasses() || JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly()) {
                        if (JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly()) {
                            EnumSet<ClassIndex.SearchKind> searchKind = EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS);
                            set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el)), searchKind, EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        } else {
                            set.addAll(JavaWhereUsedQueryPlugin.this.getImplementorsRecursive(idx, cpInfo, (TypeElement)el));
                        }
                    } else {
                        set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el)), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    }
                } else if (el.getKind() == ElementKind.METHOD && JavaWhereUsedQueryPlugin.this.isFindOverridingMethods()) {
                    TypeElement type = (TypeElement)el.getEnclosingElement();
                    set.addAll(JavaWhereUsedQueryPlugin.this.getImplementorsRecursive(idx, cpInfo, type));
                }
                if (el.getKind() == ElementKind.METHOD && JavaWhereUsedQueryPlugin.this.isFindUsages()) {
                    Set s = idx.getElements(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
                    for (ElementHandle eh : s) {
                        TypeElement te = (TypeElement)eh.resolve((CompilationInfo)info);
                        if (te == null) continue;
                        for (Element element : te.getEnclosedElements()) {
                            if (!(element instanceof ExecutableElement) || !info.getElements().overrides((ExecutableElement)element, (ExecutableElement)el, te)) continue;
                            set.addAll(idx.getResources(ElementHandle.create((Element)te), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        }
                    }
                    set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                } else if (el.getKind() == ElementKind.CONSTRUCTOR) {
                    set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                }
            }
        };
        try {
            source.runUserActionTask((CancellableTask)task, true);
        }
        catch (IOException ioe) {
            throw (RuntimeException)new RuntimeException().initCause(ioe);
        }
        return set;
    }

    private Set<FileObject> getImplementorsRecursive(ClassIndex idx, ClasspathInfo cpInfo, TypeElement el) {
        HashSet<FileObject> set = new HashSet<FileObject>();
        LinkedList elements = new LinkedList(idx.getElements(ElementHandle.create((Element)el), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        HashSet<ElementHandle> result = new HashSet<ElementHandle>();
        while (!elements.isEmpty()) {
            ElementHandle next = (ElementHandle)elements.removeFirst();
            result.add(next);
            elements.addAll(idx.getElements(next, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        }
        for (ElementHandle e : result) {
            FileObject fo = SourceUtils.getFile((ElementHandle)e, (ClasspathInfo)cpInfo);
            assert (fo != null) : "issue 90196, Cannot find file for " + e + ". cpInfo=" + cpInfo;
            set.add(fo);
        }
        return set;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        Set<FileObject> a = this.getRelevantFiles(this.getSearchHandle());
        this.fireProgressListenerStart(1, a.size());
        this.processFiles(a, new FindTask(elements));
        this.fireProgressListenerStop();
        return null;
    }

    public Problem fastCheckParameters() {
        if (this.getSearchHandle().getKind() == Tree.Kind.METHOD) {
            return this.checkParametersForMethod(this.isFindOverridingMethods(), this.isFindUsages());
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    private Problem checkParametersForMethod(boolean overriders, boolean usages) {
        if (!usages && !overriders) {
            return new Problem(true, NbBundle.getMessage(JavaWhereUsedQueryPlugin.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        Node.Cookie obj = dob.getCookie(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getCookie(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchFromBaseClass() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringElementsBag elements;
        private volatile boolean cancelled;

        public FindTask(RefactoringElementsBag elements) {
            this.elements = elements;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void run(WorkingCopy compiler) throws IOException {
            if (this.cancelled) {
                return;
            }
            compiler.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree cu = compiler.getCompilationUnit();
            if (cu == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                return;
            }
            Element element = JavaWhereUsedQueryPlugin.this.getSearchHandle().resolveElement((CompilationInfo)compiler);
            assert (element != null);
            ArrayList<TreePath> result = new ArrayList<TreePath>();
            if (JavaWhereUsedQueryPlugin.this.isFindUsages()) {
                FindUsagesVisitor findVisitor = new FindUsagesVisitor(compiler);
                findVisitor.scan(compiler.getCompilationUnit(), element);
                result.addAll(findVisitor.getUsages());
            }
            if (element.getKind() == ElementKind.METHOD && JavaWhereUsedQueryPlugin.this.isFindOverridingMethods()) {
                FindOverridingVisitor override = new FindOverridingVisitor(compiler);
                override.scan(compiler.getCompilationUnit(), element);
                result.addAll(override.getUsages());
            } else if ((element.getKind().isClass() || element.getKind().isInterface()) && (JavaWhereUsedQueryPlugin.this.isFindSubclasses() || JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly())) {
                FindSubtypesVisitor subtypes = new FindSubtypesVisitor(!JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly(), compiler);
                subtypes.scan(compiler.getCompilationUnit(), element);
                result.addAll(subtypes.getUsages());
            }
            for (TreePath tree : result) {
                this.elements.add((AbstractRefactoring)JavaWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create((CompilationInfo)compiler, tree));
            }
            JavaWhereUsedQueryPlugin.this.fireProgressListenerStep();
        }
    }
}

