/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class PackageRename
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        if (refactoring instanceof RenameRefactoring && refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null) {
            return new PackageRenamePlugin((RenameRefactoring)refactoring);
        }
        return null;
    }

    public class PackageRenamePlugin
    implements RefactoringPlugin {
        private RenameRefactoring refactoring;

        public PackageRenamePlugin(RenameRefactoring refactoring) {
            this.refactoring = refactoring;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem prepare(RefactoringElementsBag elements) {
            elements.addFileChange((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new RenameNonRecursiveFolder((NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class), elements));
            return null;
        }

        public Problem fastCheckParameters() {
            String newName = this.refactoring.getNewName();
            if (!RetoucheUtils.isValidPackageName(newName)) {
                String msg = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage")).format(new Object[]{newName});
                return new Problem(true, msg);
            }
            ClassPath projectClassPath = ClassPath.getClassPath((FileObject)((NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder(), (String)"classpath/source");
            if (projectClassPath.findResource(newName.replace('.', '/')) != null) {
                String msg = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_PackageExists")).format(new Object[]{newName});
                return new Problem(true, msg);
            }
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        private class RenameNonRecursiveFolder
        extends SimpleRefactoringElementImplementation {
            private FileObject folder;
            private RefactoringElementsBag session;
            private String oldName;
            private FileObject root;
            private DataFolder dataFolder;

            public RenameNonRecursiveFolder(NonRecursiveFolder nrfo, RefactoringElementsBag session) {
                this.folder = nrfo.getFolder();
                this.session = session;
                ClassPath cp = ClassPath.getClassPath((FileObject)this.folder, (String)"classpath/source");
                this.oldName = cp.getResourceName(this.folder, '.', false);
                this.root = cp.findOwnerRoot(this.folder);
                this.dataFolder = DataFolder.findFolder((FileObject)this.folder);
            }

            public String getText() {
                return "Rename file " + this.folder.getNameExt();
            }

            public String getDisplayText() {
                return this.getText();
            }

            public void performChange() {
                this.setName();
            }

            public void undoChange() {
                throw new UnsupportedOperationException("not implemented");
            }

            public Lookup getLookup() {
                return Lookups.singleton((Object)this.folder.getParent());
            }

            public FileObject getParentFile() {
                return this.folder.getParent();
            }

            public PositionBounds getPosition() {
                return null;
            }

            public void setName() {
                int index;
                int i;
                String name = PackageRenamePlugin.this.refactoring.getNewName();
                if (this.oldName.equals(name)) {
                    return;
                }
                name = name.replace('.', '/') + '/';
                this.oldName = this.oldName.replace('.', '/') + '/';
                for (i = 0; i < this.oldName.length() && i < name.length() && this.oldName.charAt(i) == name.charAt(i); ++i) {
                }
                String commonPrefix = (index = this.oldName.lastIndexOf(47, --i)) == -1 ? null : this.oldName.substring(0, index);
                String toCreate = index + 1 == name.length() ? "" : name.substring(index + 1);
                try {
                    FileObject commonFolder;
                    FileObject destination = commonFolder = commonPrefix == null ? this.root : this.root.getFileObject(commonPrefix);
                    StringTokenizer dtk = new StringTokenizer(toCreate, "/");
                    while (dtk.hasMoreTokens()) {
                        String pathElement = dtk.nextToken();
                        FileObject tmp = destination.getFileObject(pathElement);
                        if (tmp == null) {
                            tmp = destination.createFolder(pathElement);
                        }
                        destination = tmp;
                    }
                    FileObject source = this.dataFolder.getPrimaryFile();
                    DataFolder sourceFolder = DataFolder.findFolder((FileObject)source);
                    DataFolder destinationFolder = DataFolder.findFolder((FileObject)destination);
                    DataObject[] children = sourceFolder.getChildren();
                    for (int j = 0; j < children.length; ++j) {
                        if (!children[j].getPrimaryFile().isData()) continue;
                        children[j].move(destinationFolder);
                    }
                    while (!commonFolder.equals(source) && source.getChildren().length == 0) {
                        FileObject tmp = source;
                        source = source.getParent();
                        tmp.delete();
                    }
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        }
    }
}

