/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.DiffElement;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.PushDownTransformer;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushDownRefactoringPlugin
extends JavaRefactoringPlugin {
    private final PushDownRefactoring refactoring;
    private TreePathHandle treePathHandle;
    Problem precheckProblem;

    public PushDownRefactoringPlugin(PushDownRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = refactoring.getSourceType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        JavaSource source = JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
        this.fireProgressListenerStart(1, 4);
        this.precheckProblem = null;
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void cancel() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void run(CompilationController cc) throws Exception {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                PushDownRefactoringPlugin.this.precheckProblem = JavaRefactoringPlugin.isElementAvail(PushDownRefactoringPlugin.this.treePathHandle, (CompilationInfo)cc);
                if (PushDownRefactoringPlugin.this.precheckProblem != null) {
                    return;
                }
                if (!RetoucheUtils.isElementInOpenProject(PushDownRefactoringPlugin.this.treePathHandle.getFileObject())) {
                    PushDownRefactoringPlugin.this.precheckProblem = new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                    return;
                }
                PushDownRefactoringPlugin.this.fireProgressListenerStep();
                ElementHandle eh = ElementHandle.create((Element)PushDownRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)cc));
                Set resources = cc.getClasspathInfo().getClassIndex().getResources(eh, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
                if (resources.isEmpty()) {
                    PushDownRefactoringPlugin.this.precheckProblem = new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDOwn_NoSubtype"));
                    return;
                }
                PushDownRefactoringPlugin.this.fireProgressListenerStep();
                Element el = PushDownRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)cc);
                for (Element element : el.getEnclosedElements()) {
                    if (element.getKind() == ElementKind.CONSTRUCTOR) continue;
                    return;
                }
                PushDownRefactoringPlugin.this.precheckProblem = new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDown_NoMembers"));
                PushDownRefactoringPlugin.this.fireProgressListenerStep();
            }
        };
        try {
            source.runUserActionTask((CancellableTask)task, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.fireProgressListenerStop();
        }
        return this.precheckProblem;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        if (this.refactoring.getMembers().length == 0) {
            return new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDown_NoMembersSelected"));
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles(TreePathHandle handle) {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        ClassIndex idx = cpInfo.getClassIndex();
        HashSet<FileObject> set = new HashSet<FileObject>();
        set.add(RetoucheUtils.getFileObject(handle));
        set.addAll(idx.getResources(RetoucheUtils.getElementHandle(handle), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        return set;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Set<FileObject> a = this.getRelevantFiles(this.treePathHandle);
        this.fireProgressListenerStart(1, a.size());
        if (!a.isEmpty()) {
            Collection<ModificationResult> results = this.processFiles(a, new FindTask(refactoringElements));
            refactoringElements.registerTransaction((Transaction)new RetoucheCommit(results));
            for (ModificationResult result : results) {
                for (FileObject jfo : result.getModifiedFileObjects()) {
                    for (ModificationResult.Difference dif : result.getDifferences(jfo)) {
                        String old = dif.getOldText();
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(dif, jfo, result));
                    }
                }
            }
        }
        this.fireProgressListenerStop();
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringElementsBag elements;

        public FindTask(RefactoringElementsBag elements) {
            this.elements = elements;
        }

        public void cancel() {
        }

        public void run(WorkingCopy compiler) throws IOException {
            compiler.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree cu = compiler.getCompilationUnit();
            if (cu == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                return;
            }
            Element el = PushDownRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)compiler);
            assert (el != null);
            PushDownTransformer findVisitor = new PushDownTransformer(compiler, PushDownRefactoringPlugin.this.refactoring.getMembers());
            findVisitor.scan(compiler.getCompilationUnit(), el);
            for (TreePath tree : findVisitor.getUsages()) {
                ElementGripFactory.getDefault().put(compiler.getFileObject(), tree, (CompilationInfo)compiler);
            }
            PushDownRefactoringPlugin.this.fireProgressListenerStep();
        }
    }
}

