/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.plugins.SearchVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameTransformer
extends SearchVisitor {
    private Set<ElementHandle<ExecutableElement>> allMethods;
    private String newName;
    Elements elements;

    public RenameTransformer(String newName, WorkingCopy workingCopy, Set<ElementHandle<ExecutableElement>> am) {
        super(workingCopy);
        this.elements = this.workingCopy.getElements();
        this.newName = newName;
        this.allMethods = am;
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Element p) {
        this.renameUsageIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitIdentifier(node, p);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        this.renameUsageIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitMemberSelect(node, p);
    }

    private void renameUsageIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(path)) {
            return;
        }
        Element el = this.workingCopy.getTrees().getElement(path);
        if (el == null) {
            return;
        }
        if (((Object)el).equals(elementToFind) || this.isMethodMatch(el)) {
            Tree nju = this.make.setLabel(tree, (CharSequence)this.newName);
            this.workingCopy.rewrite(tree, nju);
        }
    }

    @Override
    public Tree visitMethod(MethodTree tree, Element p) {
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        return (Tree)super.visitMethod(tree, p);
    }

    @Override
    public Tree visitClass(ClassTree tree, Element p) {
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        return (Tree)super.visitClass(tree, p);
    }

    @Override
    public Tree visitVariable(VariableTree tree, Element p) {
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        return (Tree)super.visitVariable(tree, p);
    }

    private void renameDeclIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(path)) {
            return;
        }
        Element el = this.workingCopy.getTrees().getElement(path);
        if (((Object)el).equals(elementToFind) || this.isMethodMatch(el)) {
            Tree nju = this.make.setLabel(tree, (CharSequence)this.newName);
            this.workingCopy.rewrite(tree, nju);
            return;
        }
    }

    private boolean isMethodMatch(Element method) {
        if (method.getKind() == ElementKind.METHOD && this.allMethods != null) {
            for (ElementHandle<ExecutableElement> mh : this.allMethods) {
                ExecutableElement baseMethod = (ExecutableElement)mh.resolve((CompilationInfo)this.workingCopy);
                if (!baseMethod.equals(method) && !this.elements.overrides((ExecutableElement)method, baseMethod, SourceUtils.getEnclosingTypeElement((Element)baseMethod))) continue;
                return true;
            }
        }
        return false;
    }
}

