/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RetoucheRefactoringPlugin
extends JavaRefactoringPlugin
implements CancellableTask<CompilationController> {
    private Switch whatRun = Switch.DEFAULT;
    private Problem problem;

    RetoucheRefactoringPlugin() {
    }

    protected abstract Problem preCheck(CompilationController var1) throws IOException;

    protected abstract Problem checkParameters(CompilationController var1) throws IOException;

    protected abstract Problem fastCheckParameters(CompilationController var1) throws IOException;

    protected abstract Problem prepare(WorkingCopy var1, RefactoringElementsBag var2) throws IOException;

    protected abstract FileObject getFileObject();

    public void cancel() {
    }

    public final void run(CompilationController javac) throws Exception {
        switch (this.whatRun) {
            case PRECHECK: {
                this.problem = this.preCheck(javac);
                break;
            }
            case CHECKPARAMETERS: {
                this.problem = this.checkParameters(javac);
                break;
            }
            case FASTCHECKPARAMETERS: {
                this.problem = this.fastCheckParameters(javac);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public Problem preCheck() {
        return this.run(Switch.PRECHECK);
    }

    public Problem checkParameters() {
        return this.run(Switch.CHECKPARAMETERS);
    }

    public Problem fastCheckParameters() {
        return this.run(Switch.FASTCHECKPARAMETERS);
    }

    public Problem prepare(final RefactoringElementsBag bag) {
        this.whatRun = Switch.PREPARE;
        this.problem = null;
        FileObject fo = this.getFileObject();
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        try {
            js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy wc) throws Exception {
                    RetoucheRefactoringPlugin.this.prepare(wc, bag);
                }
            }).commit();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.problem;
    }

    private Problem run(Switch s) {
        this.whatRun = s;
        this.problem = null;
        FileObject fo = this.getFileObject();
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        try {
            js.runUserActionTask((CancellableTask)this, true);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.problem;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Switch {
        PRECHECK,
        FASTCHECKPARAMETERS,
        CHECKPARAMETERS,
        PREPARE,
        DEFAULT;

    }
}

