/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.DiffElement;
import org.netbeans.modules.refactoring.java.api.UseSuperTypeRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.plugins.SearchVisitor;
import org.netbeans.modules.refactoring.java.plugins.VarUsageVisitor;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class UseSuperTypeRefactoringPlugin
extends JavaRefactoringPlugin {
    private final UseSuperTypeRefactoring refactoring;
    private final RenameRefactoring renameRefactoring = null;
    private static final float ONE_DOT_FIVE = 1.5f;

    public UseSuperTypeRefactoringPlugin(UseSuperTypeRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        TreePathHandle subClassHandle = this.refactoring.getTypeElement();
        this.replaceSubtypeUsages(subClassHandle, refactoringElements);
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem fastCheckParameters() {
        if (this.refactoring.getTargetSuperType() == null) {
            return new Problem(true, NbBundle.getMessage(UseSuperTypeRefactoringPlugin.class, (String)"ERR_UseSuperTypeNoSuperType"));
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSubtypeUsages(final TreePathHandle subClassHandle, final RefactoringElementsBag elemsBag) {
        JavaSource javaSrc = JavaSource.forFileObject((FileObject)subClassHandle.getFileObject());
        try {
            javaSrc.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController complController) throws IOException {
                    complController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    FileObject fo = subClassHandle.getFileObject();
                    ClasspathInfo classpathInfo = UseSuperTypeRefactoringPlugin.this.getClasspathInfo(UseSuperTypeRefactoringPlugin.this.refactoring);
                    ClassIndex clsIndx = classpathInfo.getClassIndex();
                    TypeElement javaClassElement = (TypeElement)subClassHandle.resolveElement((CompilationInfo)complController);
                    EnumSet<ClassIndex.SearchKind> typeRefSearch = EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES);
                    Set refFileObjSet = clsIndx.getResources(ElementHandle.create((Element)javaClassElement), typeRefSearch, EnumSet.of(ClassIndex.SearchScope.SOURCE));
                    if (!refFileObjSet.isEmpty()) {
                        UseSuperTypeRefactoringPlugin.this.fireProgressListenerStart(3, refFileObjSet.size());
                        Collection<ModificationResult> results = UseSuperTypeRefactoringPlugin.this.processFiles(refFileObjSet, new FindRefTask(subClassHandle, UseSuperTypeRefactoringPlugin.this.refactoring.getTargetSuperType()));
                        elemsBag.registerTransaction((Transaction)new RetoucheCommit(results));
                        for (ModificationResult result : results) {
                            for (FileObject fileObj : result.getModifiedFileObjects()) {
                                for (ModificationResult.Difference diff : result.getDifferences(fileObj)) {
                                    String old = diff.getOldText();
                                    if (old == null) continue;
                                    elemsBag.add((AbstractRefactoring)UseSuperTypeRefactoringPlugin.this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fileObj, result));
                                }
                            }
                        }
                    }
                }
            }, false);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FindRefTask
    implements CancellableTask<WorkingCopy> {
        private final TreePathHandle subClassHandle;
        private final ElementHandle superClassHandle;

        private FindRefTask(TreePathHandle subClassHandle, ElementHandle superClassHandle) {
            this.subClassHandle = subClassHandle;
            this.superClassHandle = superClassHandle;
        }

        public void cancel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(WorkingCopy compiler) throws Exception {
            try {
                compiler.toPhase(JavaSource.Phase.RESOLVED);
                CompilationUnitTree cu = compiler.getCompilationUnit();
                if (cu == null) {
                    ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                    return;
                }
                Element subClassElement = this.subClassHandle.resolveElement((CompilationInfo)compiler);
                Element superClassElement = this.superClassHandle.resolve((CompilationInfo)compiler);
                assert (subClassElement != null);
                ReferencesVisitor findRefVisitor = new ReferencesVisitor(compiler, subClassElement, superClassElement);
                findRefVisitor.scan(compiler.getCompilationUnit(), subClassElement);
            }
            finally {
                UseSuperTypeRefactoringPlugin.this.fireProgressListenerStep();
            }
        }
    }

    private static class ReferencesVisitor
    extends SearchVisitor {
        private final Element superTypeElement;
        private final Element subTypeElement;

        private ReferencesVisitor(WorkingCopy workingCopy, Element subClassElement, Element superClassElement) {
            super(workingCopy);
            this.superTypeElement = superClassElement;
            this.subTypeElement = subClassElement;
        }

        public Tree visitVariable(VariableTree varTree, Element elementToMatch) {
            Element typeElement = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            TreePath treePath = this.getCurrentPath();
            VariableElement varElement = (VariableElement)this.workingCopy.getTrees().getElement(treePath);
            TypeMirror varType = varElement.asType();
            if (((Object)varType).equals(elementToMatch.asType()) && this.isReplaceCandidate(varElement)) {
                this.replaceWithSuperType(varTree, this.superTypeElement);
            }
            return (Tree)super.visitVariable(varTree, elementToMatch);
        }

        private boolean isReplaceCandidate(VariableElement varElement) {
            VarUsageVisitor varUsagesVisitor = new VarUsageVisitor(this.workingCopy, (TypeElement)this.superTypeElement);
            varUsagesVisitor.scan(this.workingCopy.getCompilationUnit(), varElement);
            return varUsagesVisitor.isReplaceCandidate();
        }

        private void replaceWithSuperType(VariableTree oldVarTree, Element superClassElement) {
            Tree superTypeTree = this.make.Type(superClassElement.asType());
            ExpressionTree oldInitTree = oldVarTree.getInitializer();
            ModifiersTree oldModifiers = oldVarTree.getModifiers();
            VariableTree newTree = this.make.Variable(oldModifiers, (CharSequence)oldVarTree.getName(), superTypeTree, oldInitTree);
            this.workingCopy.rewrite((Tree)oldVarTree, (Tree)newTree);
        }
    }
}

