/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.plugins.SearchVisitor;

class VarUsageVisitor
extends SearchVisitor {
    private final TypeElement superTypeElement;
    private boolean isReplCandidate = true;

    VarUsageVisitor(WorkingCopy workingCopy, TypeElement superTypeElem) {
        super(workingCopy);
        this.superTypeElement = superTypeElem;
    }

    public Tree visitMemberSelect(MemberSelectTree memSelectTree, Element refVarElem) {
        Element methodElement = this.asElement(memSelectTree);
        Element varElement = this.asElement(memSelectTree.getExpression());
        if (!((Object)refVarElem).equals(varElement)) {
            return (Tree)super.visitMemberSelect(memSelectTree, refVarElem);
        }
        if (ElementKind.METHOD.equals((Object)methodElement.getKind())) {
            TypeElement superClassTypeElement = this.superTypeElement;
            ExecutableElement execElem = (ExecutableElement)methodElement;
            TypeElement declaringClassElement = (TypeElement)this.getDeclaringClass(execElem);
            boolean isAssgCmptble = this.isAssignable(superClassTypeElement, declaringClassElement);
            this.isReplCandidate = isAssgCmptble ? this.isReplCandidate : false;
        }
        return (Tree)super.visitMemberSelect(memSelectTree, refVarElem);
    }

    public Tree visitAssignment(AssignmentTree assgnTree, Element refVarElem) {
        ExpressionTree exprnTree = assgnTree.getExpression();
        Element exprElement = this.asElement(exprnTree);
        if (!((Object)refVarElem).equals(exprElement)) {
            return (Tree)super.visitAssignment(assgnTree, refVarElem);
        }
        ExpressionTree varExprTree = assgnTree.getVariable();
        VariableElement varElement = (VariableElement)this.asElement(varExprTree);
        this.isReplCandidate = this.isReplacableAssgnmt(varElement) && this.isReplCandidate;
        return (Tree)super.visitAssignment(assgnTree, refVarElem);
    }

    public Tree visitVariable(VariableTree varTree, Element refVarElem) {
        ExpressionTree initTree = varTree.getInitializer();
        if (null == initTree) {
            return (Tree)super.visitVariable(varTree, refVarElem);
        }
        Element exprElement = this.asElement(initTree);
        if (!((Object)refVarElem).equals(exprElement)) {
            return (Tree)super.visitVariable(varTree, refVarElem);
        }
        VariableElement varElement = (VariableElement)this.asElement(varTree);
        this.isReplCandidate = this.isReplacableAssgnmt(varElement) && this.isReplCandidate;
        return (Tree)super.visitVariable(varTree, refVarElem);
    }

    private boolean isReplacableAssgnmt(VariableElement varElement) {
        DeclaredType declType;
        TypeElement varType;
        return this.isDeclaredType(varElement.asType()) && this.isAssignable(this.superTypeElement, varType = (TypeElement)(declType = (DeclaredType)varElement.asType()).asElement());
    }

    boolean isReplaceCandidate() {
        return this.isReplCandidate;
    }

    private boolean isObjectClass(TypeElement element) {
        boolean isClass = element.getKind().equals((Object)ElementKind.CLASS);
        if (isClass) {
            return element.getSuperclass().getKind().equals((Object)TypeKind.NONE);
        }
        return false;
    }

    private boolean isAssignable(TypeElement typeFrom, TypeElement typeTo) {
        Types types = this.workingCopy.getTypes();
        return types.isAssignable(typeFrom.asType(), typeTo.asType());
    }

    private Element asElement(Tree tree) {
        Trees treeUtil = this.workingCopy.getTrees();
        TreePath treePath = treeUtil.getPath(this.workingCopy.getCompilationUnit(), tree);
        Element element = treeUtil.getElement(treePath);
        return element;
    }

    private Tree asTree(Element element) {
        Trees treeUtil = this.workingCopy.getTrees();
        return treeUtil.getTree(element);
    }

    private Element getDeclaringClass(ExecutableElement execElem) {
        Element classElem = execElem.getEnclosingElement();
        while (classElem != null) {
            if (classElem.getKind().equals((Object)ElementKind.CLASS) || classElem.getKind().equals((Object)ElementKind.INTERFACE)) {
                return classElem;
            }
            Element enclElement = classElem.getEnclosingElement();
            if (((Object)classElem).equals(enclElement)) break;
            classElem = enclElement;
        }
        return null;
    }

    private boolean isDeclaredType(TypeMirror type) {
        return TypeKind.DECLARED.equals((Object)type.getKind());
    }
}

