/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.java.ui.ExtractInterfaceAction;
import org.netbeans.modules.refactoring.java.ui.ExtractInterfacePanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class ExtractInterfaceRefactoringUI
implements RefactoringUI {
    private final ExtractInterfaceRefactoring refactoring;
    private final TreePathHandle sourceType;
    private ExtractInterfacePanel panel;
    private String name;

    public ExtractInterfaceRefactoringUI(TreePathHandle selectedElement, CompilationInfo info) {
        this.sourceType = this.getSourceType(selectedElement, info);
        this.refactoring = new ExtractInterfaceRefactoring(this.sourceType);
        this.refactoring.getContext().add((Object)info.getClasspathInfo());
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new ExtractInterfacePanel(this.refactoring, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.captureParameters();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.captureParameters();
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(ExtractInterfaceAction.class, (String)"DSC_ExtractInterface", (Object)this.name);
    }

    public String getName() {
        return NbBundle.getMessage(ExtractInterfaceAction.class, (String)"LBL_ExtractInterface");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ExtractInterfaceRefactoringUI.class.getName());
    }

    private void captureParameters() {
        this.panel.storeSettings();
    }

    private TreePathHandle getSourceType(TreePathHandle selected, CompilationInfo javac) {
        TreePathHandle srcType = null;
        TreePath path = selected.resolve(javac);
        Element sourceElm = javac.getTrees().getScope(path).getEnclosingClass();
        if ((sourceElm = this.resolveEnclosingClass(sourceElm)) != null) {
            srcType = TreePathHandle.create((TreePath)javac.getTrees().getPath(sourceElm), (CompilationInfo)javac);
            this.name = UiUtils.getHeader((Element)sourceElm, (CompilationInfo)javac, (String)"%name%");
        }
        return srcType;
    }

    private Element resolveEnclosingClass(Element e) {
        block3: do {
            switch (e.getKind()) {
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    TypeElement te = (TypeElement)e;
                    if (te.getNestingKind() == NestingKind.ANONYMOUS || te.getNestingKind() == NestingKind.LOCAL) continue block3;
                    return e;
                }
            }
        } while ((e = e.getEnclosingElement()) != null);
        return null;
    }
}

