/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.MoveClassPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveClassUI
implements RefactoringUI,
RefactoringUIBypass {
    private DataObject javaObject;
    private MoveClassPanel panel;
    private MoveRefactoring refactoring;
    private String targetPkgName = "";
    private boolean disable;
    private FileObject targetFolder;
    private PasteType pasteType;

    static final String getString(String key) {
        return NbBundle.getMessage(MoveClassUI.class, (String)key);
    }

    public MoveClassUI(DataObject javaObject) {
        this(javaObject, null, null, Collections.emptyList());
    }

    public MoveClassUI(DataObject javaObject, FileObject targetFolder, PasteType pasteType, Collection<TreePathHandle> handles) {
        this.disable = targetFolder != null;
        this.targetFolder = targetFolder;
        this.javaObject = javaObject;
        this.pasteType = pasteType;
        this.refactoring = new MoveRefactoring(Lookups.fixed((Object[])new Object[]{javaObject.getPrimaryFile(), handles.toArray(new Object[handles.size()])}));
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(javaObject.getPrimaryFile()));
    }

    public String getName() {
        return MoveClassUI.getString("LBL_MoveClass");
    }

    public String getDescription() {
        return new MessageFormat(MoveClassUI.getString("DSC_MoveClass")).format(new Object[]{this.javaObject.getName(), this.packageName()});
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            String pkgName = this.targetFolder != null ? MoveClassUI.getPackageName(this.targetFolder) : MoveClassUI.getPackageName(this.javaObject.getPrimaryFile().getParent());
            this.panel = new MoveClassPanel(parent, pkgName, new MessageFormat(MoveClassUI.getString("LBL_MoveClassNamed")).format(new Object[]{this.javaObject.getPrimaryFile().getName()}), (FileObject)(this.targetFolder != null ? this.targetFolder : (this.javaObject != null ? this.javaObject.getPrimaryFile() : null)));
            this.panel.setCombosEnabled(!this.disable);
        }
        return this.panel;
    }

    private static String getPackageName(FileObject file) {
        ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
        return cp.getResourceName(file, '.', false);
    }

    private String packageName() {
        return this.targetPkgName.trim().length() == 0 ? MoveClassUI.getString("LBL_DefaultPackage") : this.targetPkgName.trim();
    }

    private Problem setParameters(boolean checkOnly) {
        if (this.panel == null) {
            return null;
        }
        this.targetPkgName = this.panel.getPackageName();
        URL url = URLMapper.findURL((FileObject)this.panel.getRootFolder(), (int)1);
        try {
            this.refactoring.setTarget(Lookups.singleton((Object)new URL(url.toExternalForm() + URLEncoder.encode(this.panel.getPackageName().replace('.', '/')))));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        if (checkOnly) {
            return this.refactoring.fastCheckParameters();
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveClassUI.class);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        this.pasteType.paste();
    }
}

