/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PullUpPanel
extends JPanel
implements CustomRefactoringPanel {
    private static final String[] COLUMN_NAMES = new String[]{"LBL_PullUp_Selected", "LBL_PullUp_Member", "LBL_PullUp_MakeAbstract"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, TreePathHandle.class, Boolean.class};
    private final PullUpRefactoring refactoring;
    private final TableModel tableModel;
    private Set<MemberInfo> selectedMembers;
    private MemberInfo targetType;
    private Object[][] members = new Object[0][0];
    private ElementKind sourceKind;
    private JLabel chooseLabel;
    private JTable membersTable;
    private JScrollPane scrollPane;
    private JComboBox supertypeCombo;
    private JLabel supertypeLabel;
    private JPanel supertypePanel;

    public PullUpPanel(PullUpRefactoring refactoring, Set<MemberInfo> selectedMembers, final ChangeListener parent) {
        this.refactoring = refactoring;
        this.tableModel = new TableModel();
        this.selectedMembers = selectedMembers;
        this.initComponents();
        this.setPreferredSize(new Dimension(420, 380));
        this.membersTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                parent.stateChanged(null);
            }
        });
    }

    public void initialize() {
        final TreePathHandle handle = this.refactoring.getSourceType();
        JavaSource source = JavaSource.forFileObject((FileObject)handle.getFileObject());
        try {
            source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    Collection<Element> supertypes = RetoucheUtils.getSuperTypes((TypeElement)handle.resolveElement((CompilationInfo)controller), (CompilationInfo)controller, true);
                    MemberInfo[] minfo = new MemberInfo[supertypes.size()];
                    int i = 0;
                    for (Element e : supertypes) {
                        minfo[i++] = new MemberInfo(e, (CompilationInfo)controller);
                    }
                    TypeElement sourceTypeElement = (TypeElement)handle.resolveElement((CompilationInfo)controller);
                    PullUpPanel.this.sourceKind = sourceTypeElement.getKind();
                    PullUpPanel.this.supertypeCombo.setRenderer(new UIUtilities.JavaElementListCellRenderer());
                    PullUpPanel.this.supertypeCombo.setModel(new ComboModel(minfo));
                    PullUpPanel.this.membersTable.setDefaultRenderer(COLUMN_CLASSES[1], new UIUtilities.JavaElementTableCellRenderer(){

                        protected String extractText(Object value) {
                            String displayValue = super.extractText(value);
                            if (value instanceof MemberInfo && ((MemberInfo)value).getType() == 1) {
                                displayValue = "implements " + displayValue;
                            }
                            return displayValue;
                        }
                    });
                    PullUpPanel.this.membersTable.getColumnModel().getColumn(2).setCellRenderer(new UIUtilities.BooleanTableCellRenderer(){

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            MemberInfo object = (MemberInfo)table.getModel().getValueAt(row, 1);
                            if (object.getKind() == ElementKind.METHOD && object.getKind() == ElementKind.METHOD && PullUpPanel.this.targetType.getKind().isInterface() && !object.getModifiers().contains((Object)Modifier.STATIC) && !object.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                                value = Boolean.TRUE;
                            }
                            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        }
                    });
                    PullUpPanel.this.scrollPane.setBackground(PullUpPanel.this.membersTable.getBackground());
                    PullUpPanel.this.scrollPane.getViewport().setBackground(PullUpPanel.this.membersTable.getBackground());
                    PullUpPanel.this.membersTable.setRowHeight(18);
                    if (UIManager.getColor("control") != null) {
                        PullUpPanel.this.membersTable.setGridColor(UIManager.getColor("control"));
                    }
                    UIUtilities.initColumnWidth(PullUpPanel.this.membersTable, 0, Boolean.TRUE, 4);
                    UIUtilities.initColumnWidth(PullUpPanel.this.membersTable, 2, Boolean.TRUE, 4);
                    String name = UiUtils.getHeader((TreePath)handle.resolve((CompilationInfo)controller), (CompilationInfo)controller, (String)"%name%");
                    PullUpPanel.this.setName(NbBundle.getMessage(PullUpPanel.class, (String)"LBL_PullUpHeader", (Object[])new Object[]{name}));
                }
            }, true);
        }
        catch (IOException ioe) {
            throw (RuntimeException)new RuntimeException().initCause(ioe);
        }
    }

    public MemberInfo getTargetType() {
        return this.targetType;
    }

    public MemberInfo[] getMembers() {
        final ArrayList list = new ArrayList();
        TreePathHandle handle = this.refactoring.getSourceType();
        JavaSource source = JavaSource.forFileObject((FileObject)handle.getFileObject());
        try {
            source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController parameter) throws Exception {
                    boolean targetIsInterface = PullUpPanel.this.targetType.getKind().isInterface();
                    for (int i = 0; i < PullUpPanel.this.members.length; ++i) {
                        MemberInfo element;
                        if (!PullUpPanel.this.members[i][0].equals(Boolean.TRUE)) continue;
                        element.setUserData(Lookups.singleton((Object)((element = (MemberInfo)PullUpPanel.this.members[i][1]).getKind() == ElementKind.METHOD && targetIsInterface || ((Boolean)PullUpPanel.this.members[i][2] == null ? Boolean.FALSE : (Boolean)PullUpPanel.this.members[i][2]) != false ? 1 : 0)));
                        list.add(element);
                    }
                }
            }, true);
        }
        catch (IOException ioe) {
            throw (RuntimeException)new RuntimeException().initCause(ioe);
        }
        return list.toArray(new MemberInfo[list.size()]);
    }

    private void initComponents() {
        this.supertypePanel = new JPanel();
        this.supertypeCombo = new JComboBox();
        this.supertypeLabel = new JLabel();
        this.chooseLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.membersTable = new JTable();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new BorderLayout());
        this.supertypePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.supertypePanel.setLayout(new BorderLayout(12, 0));
        this.supertypePanel.add((Component)this.supertypeCombo, "Center");
        this.supertypeLabel.setLabelFor(this.supertypeCombo);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.supertypeLabel, (String)bundle.getString("LBL_PullUp_Supertype"));
        this.supertypePanel.add((Component)this.supertypeLabel, "West");
        this.supertypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PullUpPanel.class, (String)"ACSD_DestinationSupertypeName"));
        this.supertypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PullUpPanel.class, (String)"ACSD_DestinationSupertypeDescription"));
        this.chooseLabel.setLabelFor(this.membersTable);
        Mnemonics.setLocalizedText((JLabel)this.chooseLabel, (String)NbBundle.getMessage(PullUpPanel.class, (String)"LBL_PullUpLabel"));
        this.chooseLabel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.supertypePanel.add((Component)this.chooseLabel, "South");
        this.add((Component)this.supertypePanel, "North");
        this.membersTable.setModel(this.tableModel);
        this.membersTable.setAutoResizeMode(1);
        this.scrollPane.setViewportView(this.membersTable);
        this.membersTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PullUpPanel.class, (String)"ACSD_MembersToPullUp"));
        this.membersTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PullUpPanel.class, (String)"ACSD_MembersToPullUpDescription"));
        this.add((Component)this.scrollPane, "Center");
    }

    public Component getComponent() {
        return this;
    }

    static /* synthetic */ Object[][] access$702(PullUpPanel x0, Object[][] x1) {
        x0.members = x1;
        return x1;
    }

    private class ComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final MemberInfo[] supertypes;

        ComboModel(MemberInfo[] supertypes) {
            this.supertypes = supertypes;
            if (supertypes.length > 0) {
                this.setSelectedItem(supertypes[0]);
            }
        }

        public void setSelectedItem(final Object anItem) {
            JavaSource source = JavaSource.forFileObject((FileObject)PullUpPanel.this.refactoring.getSourceType().getFileObject());
            try {
                source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController info) {
                        try {
                            info.toPhase(JavaSource.Phase.RESOLVED);
                        }
                        catch (IOException ioe) {
                            throw (RuntimeException)new RuntimeException().initCause(ioe);
                        }
                        if (PullUpPanel.this.targetType != anItem) {
                            PullUpPanel.this.targetType = (MemberInfo)anItem;
                            ComboModel.this.fireContentsChanged(this, -1, -1);
                            ArrayList<MemberInfo> classes = new ArrayList<MemberInfo>();
                            Element e = PullUpPanel.this.refactoring.getSourceType().resolveElement((CompilationInfo)info);
                            MemberInfo m = new MemberInfo(e, (CompilationInfo)info);
                            classes.add(m);
                            for (int i = 0; i < ComboModel.this.supertypes.length; ++i) {
                                TypeMirror targetTM = PullUpPanel.this.targetType.getElementHandle().resolve((CompilationInfo)info).asType();
                                TypeMirror superTM = ComboModel.this.supertypes[i].getElementHandle().resolve((CompilationInfo)info).asType();
                                if (!info.getTypes().isSubtype(superTM, targetTM) || info.getTypes().isSameType(superTM, targetTM)) continue;
                                classes.add(ComboModel.this.supertypes[i]);
                            }
                            PullUpPanel.this.tableModel.update(classes.toArray(new MemberInfo[classes.size()]));
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                throw (RuntimeException)new RuntimeException().initCause(ioe);
            }
        }

        public Object getSelectedItem() {
            return PullUpPanel.this.targetType;
        }

        public Object getElementAt(int index) {
            return this.supertypes[index];
        }

        public int getSize() {
            return this.supertypes.length;
        }
    }

    private class TableModel
    extends AbstractTableModel {
        private TableModel() {
        }

        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        public String getColumnName(int column) {
            return UIUtilities.getColumnName(NbBundle.getMessage(PullUpPanel.class, (String)COLUMN_NAMES[column]));
        }

        public Class getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        public int getRowCount() {
            return PullUpPanel.this.members.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return PullUpPanel.this.members[rowIndex][columnIndex];
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ((PullUpPanel)PullUpPanel.this).members[rowIndex][columnIndex] = value;
            this.fireTableDataChanged();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                if (PullUpPanel.this.members[rowIndex][2] == null) {
                    return false;
                }
                Object element = PullUpPanel.this.members[rowIndex][1];
                return !PullUpPanel.this.sourceKind.isInterface() && !((MemberInfo)element).getModifiers().contains((Object)Modifier.STATIC) && !((MemberInfo)element).getModifiers().contains((Object)Modifier.ABSTRACT);
            }
            return columnIndex == 0;
        }

        void update(final MemberInfo[] classes) {
            JavaSource source = JavaSource.forFileObject((FileObject)PullUpPanel.this.refactoring.getSourceType().getFileObject());
            try {
                source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController info) {
                        Object[] value;
                        int i;
                        try {
                            info.toPhase(JavaSource.Phase.RESOLVED);
                        }
                        catch (IOException ioe) {
                            throw (RuntimeException)new RuntimeException().initCause(ioe);
                        }
                        HashMap<Object, Object[]> map = new HashMap<Object, Object[]>();
                        for (i = 0; i < classes.length; ++i) {
                            for (TypeMirror typeMirror : ((TypeElement)classes[i].getElementHandle().resolve((CompilationInfo)info)).getInterfaces()) {
                                MemberInfo ifcName = new MemberInfo(RetoucheUtils.typeToElement(typeMirror, (CompilationInfo)info), (CompilationInfo)info, 1);
                                map.put(ifcName, new Object[]{Boolean.FALSE, ifcName, null});
                            }
                            List<? extends Element> features = classes[i].getElementHandle().resolve((CompilationInfo)info).getEnclosedElements();
                            boolean bl = false;
                            block7: for (Element element : features) {
                                switch (element.getKind()) {
                                    case CONSTRUCTOR: 
                                    case STATIC_INIT: 
                                    case INSTANCE_INIT: {
                                        continue block7;
                                    }
                                }
                                MemberInfo mi = new MemberInfo(element, (CompilationInfo)info);
                                map.put(mi, new Object[]{Boolean.FALSE, mi, element.getKind() == ElementKind.METHOD ? Boolean.FALSE : null});
                            }
                        }
                        if (PullUpPanel.this.selectedMembers != null) {
                            Iterator it = PullUpPanel.this.selectedMembers.iterator();
                            while (it.hasNext()) {
                                value = (Object[])map.get(it.next());
                                if (value == null) continue;
                                value[0] = Boolean.TRUE;
                            }
                            PullUpPanel.this.selectedMembers = null;
                        } else {
                            for (i = 0; i < PullUpPanel.this.members.length; ++i) {
                                value = (Object[])map.get(PullUpPanel.this.members[i][1]);
                                if (value == null) continue;
                                map.put(value[1], PullUpPanel.this.members[i]);
                            }
                        }
                        TreeMap<Object, Object[]> treeMap = new TreeMap<Object, Object[]>(new Comparator(){

                            public int compare(Object o1, Object o2) {
                                return ((MemberInfo)o1).getHtmlText().compareTo(((MemberInfo)o2).getHtmlText());
                            }
                        });
                        treeMap.putAll(map);
                        PullUpPanel.access$702(PullUpPanel.this, new Object[treeMap.size()][]);
                        int i2 = 0;
                        Iterator iterator = treeMap.values().iterator();
                        while (iterator.hasNext()) {
                            ((PullUpPanel)PullUpPanel.this).members[i2] = (Object[])iterator.next();
                            ++i2;
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                throw (RuntimeException)new RuntimeException().initCause(ioe);
            }
            this.fireTableDataChanged();
        }
    }
}

