/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.CopyClassRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.MoveClassUI;
import org.netbeans.modules.refactoring.java.ui.MoveClassesUI;
import org.netbeans.modules.refactoring.java.ui.RenameRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.SafeDeleteUI;
import org.netbeans.modules.refactoring.java.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    public void doRename(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        final Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        if (RefactoringActionsProvider.isFromEditor(ec)) {
            new TextComponentRunnable(ec){

                protected RefactoringUI createRefactoringUI(TreePathHandle selectedElement, int startOffset, int endOffset, final CompilationInfo info) {
                    Element selected = selectedElement.resolveElement(info);
                    if (selected == null) {
                        return null;
                    }
                    if (selected.getKind() == ElementKind.CONSTRUCTOR) {
                        selected = selected.getEnclosingElement();
                    }
                    if (selected.getKind() == ElementKind.PACKAGE) {
                        NonRecursiveFolder folder = new NonRecursiveFolder(){

                            public FileObject getFolder() {
                                return info.getFileObject().getParent();
                            }
                        };
                        return new RenameRefactoringUI(folder);
                    }
                    if (selected.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
                        FileObject f = SourceUtils.getFile((Element)selected, (ClasspathInfo)info.getClasspathInfo());
                        if (selected.getSimpleName().toString().equals(f.getName())) {
                            return new RenameRefactoringUI(f == null ? info.getFileObject() : f, selectedElement, info);
                        }
                        return new RenameRefactoringUI(selectedElement, info);
                    }
                    return new RenameRefactoringUI(selectedElement, info);
                }
            }.run();
        } else {
            new NodeToFileObject(lookup.lookupAll(Node.class)){

                @Override
                protected RefactoringUI createRefactoringUI(FileObject[] selectedElements, Collection<TreePathHandle> handles) {
                    String newName = RefactoringActionsProvider.getName(dictionary);
                    if (newName != null) {
                        if (this.pkg[0] != null) {
                            return new RenameRefactoringUI(this.pkg[0], newName);
                        }
                        return new RenameRefactoringUI(selectedElements[0], newName, handles == null || handles.isEmpty() ? null : handles.iterator().next(), this.cinfo == null ? null : (CompilationInfo)this.cinfo.get());
                    }
                    if (this.pkg[0] != null) {
                        return new RenameRefactoringUI(this.pkg[0]);
                    }
                    return new RenameRefactoringUI(selectedElements[0], handles == null || handles.isEmpty() ? null : handles.iterator().next(), this.cinfo == null ? null : (CompilationInfo)this.cinfo.get());
                }
            }.run();
        }
    }

    public boolean canRename(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob == null) {
            return false;
        }
        FileObject fo = dob.getPrimaryFile();
        if (RetoucheUtils.isRefactorable(fo)) {
            return true;
        }
        return dob instanceof DataFolder && RetoucheUtils.isFileInOpenProject(fo) && RetoucheUtils.isOnSourceClasspath(fo) && !RetoucheUtils.isClasspathRoot(fo);
    }

    public void doCopy(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        final Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        new NodeToFileObject(lookup.lookupAll(Node.class)){

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] selectedElements, Collection<TreePathHandle> handle) {
                return new CopyClassRefactoringUI(selectedElements[0], RefactoringActionsProvider.this.getTarget(dictionary), RefactoringActionsProvider.this.getPaste(dictionary));
            }
        }.run();
    }

    public boolean canCopy(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob == null) {
            return false;
        }
        Dictionary dict = (Dictionary)lookup.lookup(Dictionary.class);
        FileObject fob = this.getTarget(dict);
        if (dict != null && dict.get("target") != null && fob == null) {
            return false;
        }
        if (fob != null) {
            if (!fob.isFolder()) {
                return false;
            }
            FileObject fo = dob.getPrimaryFile();
            if (RetoucheUtils.isRefactorable(fo)) {
                return true;
            }
        } else {
            FileObject fo = dob.getPrimaryFile();
            if (RetoucheUtils.isRefactorable(fo)) {
                return true;
            }
        }
        return false;
    }

    public boolean canFindUsages(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        return dob != null && RetoucheUtils.isJavaFile(dob.getPrimaryFile());
    }

    public void doFindUsages(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (RefactoringActionsProvider.isFromEditor(ec)) {
            new TextComponentRunnable(ec){

                protected RefactoringUI createRefactoringUI(TreePathHandle selectedElement, int startOffset, int endOffset, CompilationInfo info) {
                    return new WhereUsedQueryUI(selectedElement, info);
                }
            }.run();
        } else {
            new NodeToElement(lookup.lookupAll(Node.class)){

                protected RefactoringUI createRefactoringUI(TreePathHandle selectedElement, CompilationInfo info) {
                    return new WhereUsedQueryUI(selectedElement, info);
                }
            }.run();
        }
    }

    public boolean canDelete(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        for (Node n : nodes) {
            DataObject dob = (DataObject)n.getCookie(DataObject.class);
            if (dob == null) {
                return false;
            }
            if (RetoucheUtils.isRefactorable(dob.getPrimaryFile())) continue;
            return false;
        }
        return !nodes.isEmpty();
    }

    public void doDelete(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (RefactoringActionsProvider.isFromEditor(ec)) {
            new TextComponentRunnable(ec){

                protected RefactoringUI createRefactoringUI(TreePathHandle selectedElement, int startOffset, int endOffset, CompilationInfo info) {
                    Element selected = selectedElement.resolveElement(info);
                    if (selected.getKind() == ElementKind.PACKAGE || selected.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
                        return new SafeDeleteUI(new FileObject[]{info.getFileObject()}, Collections.singleton(selectedElement));
                    }
                    return new SafeDeleteUI(new TreePathHandle[]{selectedElement}, info);
                }
            }.run();
        } else {
            new NodeToFileObject(lookup.lookupAll(Node.class)){

                @Override
                protected RefactoringUI createRefactoringUI(FileObject[] selectedElements, Collection<TreePathHandle> handles) {
                    return new SafeDeleteUI(selectedElements, handles);
                }
            }.run();
        }
    }

    private FileObject getTarget(Dictionary dict) {
        if (dict == null) {
            return null;
        }
        Node n = (Node)dict.get("target");
        if (n == null) {
            return null;
        }
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob != null) {
            return dob.getPrimaryFile();
        }
        return null;
    }

    private PasteType getPaste(Dictionary dict) {
        if (dict == null) {
            return null;
        }
        Transferable orig = (Transferable)dict.get("transferable");
        if (orig == null) {
            return null;
        }
        Node n = (Node)dict.get("target");
        if (n == null) {
            return null;
        }
        PasteType[] pt = n.getPasteTypes(orig);
        if (pt.length == 1) {
            return null;
        }
        return pt[1];
    }

    static String getName(Dictionary dict) {
        if (dict == null) {
            return null;
        }
        return (String)dict.get("name");
    }

    public boolean canMove(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        Dictionary dict = (Dictionary)lookup.lookup(Dictionary.class);
        FileObject fo = this.getTarget(dict);
        if (fo != null) {
            if (!fo.isFolder()) {
                return false;
            }
            HashSet<DataFolder> folders = new HashSet<DataFolder>();
            boolean jdoFound = false;
            for (Node n : nodes) {
                DataObject dob = (DataObject)n.getCookie(DataObject.class);
                if (dob == null) {
                    return false;
                }
                if (!RetoucheUtils.isOnSourceClasspath(dob.getPrimaryFile())) {
                    return false;
                }
                if (dob instanceof DataFolder) {
                    folders.add((DataFolder)dob);
                    continue;
                }
                if (!RetoucheUtils.isJavaFile(dob.getPrimaryFile())) continue;
                jdoFound = true;
            }
            if (jdoFound) {
                return true;
            }
            for (DataFolder fold : folders) {
                Enumeration e = fold.children(true);
                while (e.hasMoreElements()) {
                    if (!RetoucheUtils.isJavaFile(((DataObject)e.nextElement()).getPrimaryFile())) continue;
                    return true;
                }
            }
            return false;
        }
        boolean result = false;
        for (Node n : nodes) {
            DataObject dob = (DataObject)n.getCookie(DataObject.class);
            if (dob == null) {
                return false;
            }
            if (dob instanceof DataFolder) {
                Object b = dict.get("DnD");
                return b == null ? false : (Boolean)b;
            }
            if (!RetoucheUtils.isOnSourceClasspath(dob.getPrimaryFile())) {
                return false;
            }
            if (!RetoucheUtils.isJavaFile(dob.getPrimaryFile())) continue;
            result = true;
        }
        return result;
    }

    public void doMove(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        final Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        if (RefactoringActionsProvider.isFromEditor(ec)) {
            new TextComponentRunnable(ec){

                protected RefactoringUI createRefactoringUI(TreePathHandle selectedElement, int startOffset, int endOffset, CompilationInfo info) {
                    Element e = selectedElement.resolveElement(info);
                    if ((e.getKind().isClass() || e.getKind().isInterface()) && SourceUtils.getOutermostEnclosingTypeElement((Element)e) == e) {
                        try {
                            DataObject d;
                            FileObject fo = SourceUtils.getFile((Element)e, (ClasspathInfo)info.getClasspathInfo());
                            if (fo != null && (d = DataObject.find((FileObject)SourceUtils.getFile((Element)e, (ClasspathInfo)info.getClasspathInfo()))).getName().equals(e.getSimpleName().toString())) {
                                return new MoveClassUI(d);
                            }
                        }
                        catch (DataObjectNotFoundException ex) {
                            throw (RuntimeException)new RuntimeException().initCause(ex);
                        }
                    }
                    if (selectedElement.resolve(info).getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                        try {
                            return new MoveClassUI(DataObject.find((FileObject)info.getFileObject()));
                        }
                        catch (DataObjectNotFoundException ex) {
                            throw (RuntimeException)new RuntimeException().initCause(ex);
                        }
                    }
                    try {
                        return new MoveClassUI(DataObject.find((FileObject)info.getFileObject()));
                    }
                    catch (DataObjectNotFoundException ex) {
                        throw (RuntimeException)new RuntimeException().initCause(ex);
                    }
                }
            }.run();
        } else {
            new NodeToFileObject(lookup.lookupAll(Node.class)){

                @Override
                protected RefactoringUI createRefactoringUI(FileObject[] selectedElements, Collection<TreePathHandle> handles) {
                    PasteType paste = RefactoringActionsProvider.this.getPaste(dictionary);
                    FileObject tar = RefactoringActionsProvider.this.getTarget(dictionary);
                    if (selectedElements.length == 1) {
                        try {
                            return new MoveClassUI(DataObject.find((FileObject)selectedElements[0]), tar, paste, handles);
                        }
                        catch (DataObjectNotFoundException ex) {
                            throw (RuntimeException)new RuntimeException().initCause(ex);
                        }
                    }
                    HashSet<FileObject> s = new HashSet<FileObject>();
                    s.addAll(Arrays.asList(selectedElements));
                    return new MoveClassesUI(s, tar, paste);
                }
            }.run();
        }
    }

    static boolean isFromEditor(EditorCookie ec) {
        TopComponent activetc;
        return ec != null && ec.getOpenedPanes() != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToElement
    implements Runnable {
        private Node node;
        private RefactoringUI ui;

        public NodeToElement(Collection<? extends Node> nodes) {
            assert (nodes.size() == 1);
            this.node = nodes.iterator().next();
        }

        @Override
        public final void run() {
            DataObject o = (DataObject)this.node.getCookie(DataObject.class);
            JavaSource source = JavaSource.forFileObject((FileObject)o.getPrimaryFile());
            assert (source != null);
            try {
                source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController info) throws Exception {
                        info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        CompilationUnitTree unit = info.getCompilationUnit();
                        TreePathHandle representedObject = TreePathHandle.create((TreePath)TreePath.getPath(unit, unit.getTypeDecls().get(0)), (CompilationInfo)info);
                        NodeToElement.this.ui = NodeToElement.this.createRefactoringUI(representedObject, (CompilationInfo)info);
                    }
                }, false);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            UI.openRefactoringUI((RefactoringUI)this.ui);
        }

        protected abstract RefactoringUI createRefactoringUI(TreePathHandle var1, CompilationInfo var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToFileObject
    implements Runnable {
        private Collection<? extends Node> nodes;
        private RefactoringUI ui;
        public NonRecursiveFolder[] pkg;
        public WeakReference<CompilationInfo> cinfo;

        public NodeToFileObject(Collection<? extends Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        public void run() {
            FileObject[] fobs = new FileObject[this.nodes.size()];
            this.pkg = new NonRecursiveFolder[fobs.length];
            int i = 0;
            final ArrayList<TreePathHandle> handles = new ArrayList<TreePathHandle>();
            for (Node node : this.nodes) {
                DataObject dob = (DataObject)node.getCookie(DataObject.class);
                if (dob == null) continue;
                fobs[i] = dob.getPrimaryFile();
                if (RetoucheUtils.isJavaFile(fobs[i])) {
                    JavaSource source = JavaSource.forFileObject((FileObject)fobs[i]);
                    assert (source != null);
                    try {
                        source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                            public void cancel() {
                            }

                            public void run(CompilationController info) throws Exception {
                                info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                CompilationUnitTree unit = info.getCompilationUnit();
                                for (Tree tree : unit.getTypeDecls()) {
                                    Element e = info.getTrees().getElement(TreePath.getPath(unit, tree));
                                    if (!e.getSimpleName().toString().equals(info.getFileObject().getName())) continue;
                                    TreePathHandle representedObject = TreePathHandle.create((TreePath)TreePath.getPath(unit, tree), (CompilationInfo)info);
                                    handles.add(representedObject);
                                    break;
                                }
                                NodeToFileObject.this.cinfo = new WeakReference<CompilationController>(info);
                            }
                        }, false);
                    }
                    catch (IllegalArgumentException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                this.pkg[i++] = (NonRecursiveFolder)node.getLookup().lookup(NonRecursiveFolder.class);
            }
            UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(fobs, handles));
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1, Collection<TreePathHandle> var2);
    }

    public static abstract class TextComponentRunnable
    implements Runnable {
        private JTextComponent textC;
        private int caret;
        private int start;
        private int end;
        private RefactoringUI ui;

        public TextComponentRunnable(EditorCookie ec) {
            this.textC = ec.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        public final void run() {
            try {
                JavaSource source = JavaSource.forDocument((Document)this.textC.getDocument());
                source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController cc) throws Exception {
                        List<? extends Tree> decls;
                        TreePath selectedElement = null;
                        cc.toPhase(JavaSource.Phase.RESOLVED);
                        selectedElement = cc.getTreeUtilities().pathFor(TextComponentRunnable.this.caret);
                        if (selectedElement.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT && !(decls = cc.getCompilationUnit().getTypeDecls()).isEmpty()) {
                            selectedElement = TreePath.getPath(cc.getCompilationUnit(), decls.get(0));
                        }
                        TextComponentRunnable.this.ui = TextComponentRunnable.this.createRefactoringUI(TreePathHandle.create((TreePath)selectedElement, (CompilationInfo)cc), TextComponentRunnable.this.start, TextComponentRunnable.this.end, (CompilationInfo)cc);
                    }
                }, false);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
                return;
            }
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)activetc);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRenameKeyword"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(TreePathHandle var1, int var2, int var3, CompilationInfo var4);
    }
}

