/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.io.IOException;
import java.text.MessageFormat;
import javax.lang.model.element.ElementKind;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.RenamePanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class RenameRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final AbstractRefactoring refactoring;
    private String oldName = null;
    private String dispOldName;
    private String newName;
    private RenamePanel panel;
    private boolean fromListener = false;
    private TreePathHandle jmiObject;
    private FileObject byPassFolder;
    private boolean byPassPakageRename;
    private boolean pkgRename = true;

    public RenameRefactoringUI(TreePathHandle jmiObject, CompilationInfo info) {
        this.jmiObject = jmiObject;
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)jmiObject));
        this.oldName = jmiObject.resolveElement(info).getSimpleName().toString();
        this.refactoring.getContext().add((Object)info.getClasspathInfo());
        this.dispOldName = this.oldName;
    }

    public RenameRefactoringUI(FileObject file, TreePathHandle handle, CompilationInfo info) {
        if (handle != null) {
            this.jmiObject = handle;
            this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{file, handle}));
            this.oldName = this.jmiObject.resolveElement(info).getSimpleName().toString();
        } else {
            this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{file}));
            this.oldName = file.getName();
        }
        this.dispOldName = this.oldName;
        ClasspathInfo cpInfo = handle == null ? RetoucheUtils.getClasspathInfoFor(file) : RetoucheUtils.getClasspathInfoFor(handle);
        this.refactoring.getContext().add((Object)cpInfo);
    }

    public RenameRefactoringUI(NonRecursiveFolder file) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)file));
        this.oldName = RetoucheUtils.getPackageName(file.getFolder());
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(file.getFolder()));
        this.dispOldName = this.oldName;
        this.pkgRename = true;
    }

    RenameRefactoringUI(FileObject jmiObject, String newName, TreePathHandle handle, CompilationInfo info) {
        this.refactoring = handle != null ? new RenameRefactoring(Lookups.fixed((Object[])new Object[]{jmiObject, handle})) : new RenameRefactoring(Lookups.fixed((Object[])new Object[]{jmiObject}));
        this.oldName = newName;
        this.dispOldName = newName;
        ClasspathInfo cpInfo = handle == null ? RetoucheUtils.getClasspathInfoFor(jmiObject) : RetoucheUtils.getClasspathInfoFor(handle);
        this.refactoring.getContext().add((Object)cpInfo);
        this.fromListener = true;
    }

    RenameRefactoringUI(NonRecursiveFolder jmiObject, String newName) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)jmiObject));
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(jmiObject.getFolder()));
        this.oldName = newName;
        this.dispOldName = newName;
        this.fromListener = true;
        this.pkgRename = true;
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            String name = this.oldName;
            String suffix = "";
            if (this.jmiObject != null) {
                ElementKind kind = RetoucheUtils.getElementKind(this.jmiObject);
                if (kind.isClass() || kind.isInterface()) {
                    suffix = kind.isInterface() ? RenameRefactoringUI.getString("LBL_Interface") : RenameRefactoringUI.getString("LBL_Class");
                } else if (kind == ElementKind.METHOD) {
                    suffix = RenameRefactoringUI.getString("LBL_Method");
                } else if (kind == ElementKind.FIELD) {
                    suffix = RenameRefactoringUI.getString("LBL_Field");
                } else if (kind == ElementKind.LOCAL_VARIABLE) {
                    suffix = RenameRefactoringUI.getString("LBL_LocalVar");
                } else if (kind == ElementKind.PACKAGE || this.jmiObject == null && this.fromListener) {
                    suffix = this.pkgRename ? RenameRefactoringUI.getString("LBL_Package") : RenameRefactoringUI.getString("LBL_Folder");
                } else if (kind == ElementKind.PARAMETER) {
                    suffix = RenameRefactoringUI.getString("LBL_Parameter");
                }
            }
            suffix = suffix + " " + name;
            this.panel = new RenamePanel(name, parent, NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename") + " " + suffix, !this.fromListener, this.fromListener && !this.byPassPakageRename);
        }
        return this.panel;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(RenameRefactoringUI.class, (String)key);
    }

    public Problem setParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
            ((RenameRefactoring)this.refactoring).setSearchInComments(this.panel.searchJavadoc());
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (!this.panel.isUpdateReferences()) {
            return null;
        }
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
        }
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(RenamePanel.class, (String)"DSC_Rename")).format(new Object[]{this.dispOldName, this.newName});
    }

    public String getName() {
        return NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        ElementKind k = RetoucheUtils.getElementKind(this.jmiObject);
        String postfix = k == ElementKind.PACKAGE ? ".JavaPackage" : (k.isClass() || k.isInterface() ? ".JavaClass" : (k == ElementKind.METHOD ? ".Method" : (k.isField() ? ".Field" : "")));
        return new HelpCtx(RenameRefactoringUI.class.getName() + postfix);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        Object dob = null;
        dob = this.byPassFolder != null ? DataFolder.findFolder((FileObject)this.byPassFolder) : DataObject.find((FileObject)((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class)));
        dob.rename(this.panel.getNameValue());
    }
}

