/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.api.UseSuperTypeRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class UseSuperTypePanel
extends JPanel
implements CustomRefactoringPanel {
    private final UseSuperTypeRefactoring refactoring;
    private JLabel label;
    private JScrollPane listScrollPane;
    private JList superTypeList;

    public UseSuperTypePanel(UseSuperTypeRefactoring refactoring) {
        this.refactoring = refactoring;
        this.initComponents();
        TreePathHandle subType = refactoring.getTypeElement();
        String title = null;
        String className = subType.toString();
        title = NbBundle.getMessage(UseSuperTypePanel.class, (String)"LBL_UseSyperTypeTitle", (Object)className);
        this.setName(title);
        this.superTypeList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, ((ElementHandle)value).getBinaryName(), index, isSelected, cellHasFocus);
            }
        });
        this.superTypeList.setModel(new DefaultComboBoxModel<ElementHandle>(refactoring.getCandidateSuperTypes()));
        this.superTypeList.setSelectionMode(0);
        this.superTypeList.setSelectedIndex(0);
    }

    public void initialize() {
    }

    public Component getComponent() {
        return this;
    }

    public ElementHandle getSuperType() {
        return (ElementHandle)this.superTypeList.getSelectedValue();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.listScrollPane = new JScrollPane();
        this.superTypeList = new JList();
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(600, 500));
        this.setPreferredSize(new Dimension(300, 200));
        this.label.setLabelFor(this.superTypeList);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getBundle(UseSuperTypePanel.class).getString("DSC_UseSuperType"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.label, gridBagConstraints);
        this.superTypeList.setSelectionMode(0);
        this.listScrollPane.setViewportView(this.superTypeList);
        this.superTypeList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UseSuperTypePanel.class, (String)"ACSD_SupertypeToUse"));
        this.superTypeList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UseSuperTypePanel.class, (String)"ACSD_SupertypeToUseDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.listScrollPane, gridBagConstraints);
    }
}

