/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WhereUsedPanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient TreePathHandle element;
    private TreePathHandle newElement;
    private final transient ChangeListener parent;
    private static final int MAX_NAME = 50;
    private boolean initialized = false;
    private String methodDeclaringSuperClass = null;
    private String methodDeclaringClass = null;
    private ButtonGroup buttonGroup;
    private JRadioButton c_directOnly;
    private JRadioButton c_subclasses;
    private JRadioButton c_usages;
    private JPanel classesPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel label;
    private JCheckBox m_isBaseClass;
    private JCheckBox m_overriders;
    private JCheckBox m_usages;
    private JPanel methodsPanel;
    private JCheckBox searchInComments;

    public WhereUsedPanel(String name, TreePathHandle e, ChangeListener parent) {
        this.setName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed"));
        this.element = e;
        this.parent = parent;
        this.initComponents();
    }

    String getMethodDeclaringClass() {
        return this.isMethodFromBaseClass() ? this.methodDeclaringSuperClass : this.methodDeclaringClass;
    }

    private Collection getOverriddenMethods(ExecutableElement m, CompilationInfo info) {
        return RetoucheUtils.getOverridenMethods(m, info);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        JavaSource source = JavaSource.forFileObject((FileObject)this.element.getFileObject());
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void cancel() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void run(CompilationController info) throws Exception {
                String labelText;
                info.toPhase(JavaSource.Phase.RESOLVED);
                String m_isBaseClassText = null;
                Set<Object> modif = new HashSet();
                final Element element = WhereUsedPanel.this.element.resolveElement((CompilationInfo)info);
                if (element.getKind() == ElementKind.METHOD) {
                    ExecutableElement method = (ExecutableElement)element;
                    modif = method.getModifiers();
                    labelText = NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_MethodUsages", (Object)WhereUsedPanel.this.getHeader(method, (CompilationInfo)info), (Object)WhereUsedPanel.this.getSimpleName(method.getEnclosingElement()));
                    WhereUsedPanel.this.methodDeclaringClass = WhereUsedPanel.this.getSimpleName(method.getEnclosingElement());
                    Collection overridens = WhereUsedPanel.this.getOverriddenMethods(method, (CompilationInfo)info);
                    if (!overridens.isEmpty()) {
                        ExecutableElement el = (ExecutableElement)overridens.iterator().next();
                        m_isBaseClassText = new MessageFormat(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_UsagesOfBaseClass")).format(new Object[]{WhereUsedPanel.this.methodDeclaringSuperClass = WhereUsedPanel.this.getSimpleName(((ExecutableElement)overridens.iterator().next()).getEnclosingElement())});
                        ElementHandle eh = ElementHandle.create((Element)el);
                        TreePath tp = SourceUtils.pathFor((CompilationInfo)info, (Element)eh.resolve((CompilationInfo)info));
                        WhereUsedPanel.this.newElement = TreePathHandle.create((TreePath)tp, (CompilationInfo)info);
                    }
                } else {
                    labelText = element.getKind().isClass() || element.getKind().isInterface() ? NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_ClassUsages", (Object)element.getSimpleName()) : (element.getKind() == ElementKind.CONSTRUCTOR ? NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_ConstructorUsages", (Object)WhereUsedPanel.this.getHeader(element), (Object)WhereUsedPanel.this.getSimpleName(element.getEnclosingElement())) : (element.getKind().isField() ? NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_FieldUsages", (Object)element.getSimpleName(), (Object)WhereUsedPanel.this.getSimpleName(element.getEnclosingElement())) : (element.getKind() == ElementKind.PACKAGE ? NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_PackageUsages", (Object)element.getSimpleName()) : NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_VariableUsages", (Object)element.getSimpleName()))));
                }
                final Set<Object> modifiers = modif;
                final String isBaseClassText = m_isBaseClassText;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WhereUsedPanel.this.remove(WhereUsedPanel.this.classesPanel);
                        WhereUsedPanel.this.remove(WhereUsedPanel.this.methodsPanel);
                        WhereUsedPanel.this.label.setText(labelText);
                        if (element instanceof ExecutableElement) {
                            WhereUsedPanel.this.add((Component)WhereUsedPanel.this.methodsPanel, "Center");
                            WhereUsedPanel.this.methodsPanel.setVisible(true);
                            WhereUsedPanel.this.m_usages.setVisible(!modifiers.contains((Object)Modifier.STATIC));
                            WhereUsedPanel.this.m_overriders.setVisible(!modifiers.contains((Object)Modifier.FINAL) || modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE));
                            if (WhereUsedPanel.this.methodDeclaringSuperClass != null) {
                                WhereUsedPanel.this.m_isBaseClass.setVisible(true);
                                WhereUsedPanel.this.m_isBaseClass.setSelected(true);
                                Mnemonics.setLocalizedText((AbstractButton)WhereUsedPanel.this.m_isBaseClass, (String)isBaseClassText);
                            } else {
                                WhereUsedPanel.this.m_isBaseClass.setVisible(false);
                                WhereUsedPanel.this.m_isBaseClass.setSelected(false);
                            }
                        } else if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE) {
                            WhereUsedPanel.this.add((Component)WhereUsedPanel.this.classesPanel, "Center");
                            WhereUsedPanel.this.classesPanel.setVisible(true);
                        } else {
                            WhereUsedPanel.this.remove(WhereUsedPanel.this.classesPanel);
                            WhereUsedPanel.this.remove(WhereUsedPanel.this.methodsPanel);
                            WhereUsedPanel.this.c_subclasses.setVisible(false);
                            WhereUsedPanel.this.m_usages.setVisible(false);
                            WhereUsedPanel.this.c_usages.setVisible(false);
                            WhereUsedPanel.this.c_directOnly.setVisible(false);
                        }
                        WhereUsedPanel.this.validate();
                    }
                });
            }
        };
        try {
            source.runUserActionTask((CancellableTask)task, true);
        }
        catch (IOException ioe) {
            throw (RuntimeException)new RuntimeException().initCause(ioe);
        }
        this.initialized = true;
    }

    private String getSimpleName(Element clazz) {
        return clazz.getSimpleName().toString();
    }

    private String getHeader(ExecutableElement call, CompilationInfo info) {
        String result = UiUtils.getHeader((Element)call, (CompilationInfo)info, (String)"%name%%parameters%");
        if (result.length() > 50) {
            result = result.substring(0, 49) + "...";
        }
        return RetoucheUtils.htmlize(result);
    }

    public TreePathHandle getBaseMethod() {
        return this.newElement;
    }

    public void requestFocus() {
        super.requestFocus();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.methodsPanel = new JPanel();
        this.m_isBaseClass = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.m_overriders = new JCheckBox();
        this.m_usages = new JCheckBox();
        this.classesPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.c_subclasses = new JRadioButton();
        this.c_usages = new JRadioButton();
        this.c_directOnly = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.methodsPanel.setLayout(new GridBagLayout());
        this.m_isBaseClass.setSelected(true);
        this.m_isBaseClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_isBaseClassActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_isBaseClass, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle");
        this.m_isBaseClass.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_isBaseClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.methodsPanel.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.m_overriders, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindOverridingMethods"));
        this.m_overriders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_overridersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_overriders, gridBagConstraints);
        this.m_overriders.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_overriders"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.m_usages.setSelected(true);
        this.m_usages.setMargin(new Insets(10, 2, 2, 2));
        this.m_usages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_usagesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_usages, gridBagConstraints);
        this.m_usages.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_usages"));
        this.add((Component)this.methodsPanel, "Center");
        this.classesPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.classesPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.buttonGroup.add(this.c_subclasses);
        Mnemonics.setLocalizedText((AbstractButton)this.c_subclasses, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindAllSubtypes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_subclasses, gridBagConstraints);
        this.c_subclasses.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_subclasses"));
        this.buttonGroup.add(this.c_usages);
        this.c_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.c_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.c_usages.setMargin(new Insets(4, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_usages, gridBagConstraints);
        this.c_usages.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_usages"));
        this.buttonGroup.add(this.c_directOnly);
        Mnemonics.setLocalizedText((AbstractButton)this.c_directOnly, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindDirectSubtypesOnly"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_directOnly, gridBagConstraints);
        this.c_directOnly.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_directOnly"));
        this.add((Component)this.classesPanel, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add((Component)this.label, "North");
        this.searchInComments.setSelected((Boolean)RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)NbBundle.getBundle(WhereUsedPanel.class).getString("LBL_SearchInComents"));
        this.searchInComments.setMargin(new Insets(10, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                WhereUsedPanel.this.searchInCommentsItemStateChanged(evt);
            }
        });
        this.jPanel3.add((Component)this.searchInComments, "South");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.jPanel3, "North");
    }

    private void searchInCommentsItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.whereUsed", b);
    }

    private void m_isBaseClassActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_overridersActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_usagesActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    public boolean isMethodFromBaseClass() {
        return this.m_isBaseClass.isSelected();
    }

    public boolean isMethodOverriders() {
        return this.m_overriders.isSelected();
    }

    public boolean isClassSubTypes() {
        return this.c_subclasses.isSelected();
    }

    public boolean isClassSubTypesDirectOnly() {
        return this.c_directOnly.isSelected();
    }

    public boolean isMethodFindUsages() {
        return this.m_usages.isSelected();
    }

    public boolean isClassFindUsages() {
        return this.c_usages.isSelected();
    }

    public Dimension getPreferredSize() {
        Dimension orig = super.getPreferredSize();
        return new Dimension(orig.width + 30, orig.height + 30);
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    private Object getHeader(Element element) {
        return element.toString();
    }

    public Component getComponent() {
        return this;
    }
}

