/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.tree;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGrip;
import org.openide.filesystems.FileObject;

public class ElementGripFactory {
    private static ElementGripFactory instance;
    private WeakHashMap<FileObject, Interval> map = new WeakHashMap();

    private ElementGripFactory() {
    }

    public static ElementGripFactory getDefault() {
        if (instance == null) {
            instance = new ElementGripFactory();
        }
        return instance;
    }

    public void cleanUp() {
        this.map.clear();
    }

    public ElementGrip get(FileObject fileObject, int position) {
        Interval start = this.map.get(fileObject);
        if (start == null) {
            return null;
        }
        try {
            return start.get((long)((long)position)).item;
        }
        catch (RuntimeException e) {
            return start.item;
        }
    }

    public ElementGrip getParent(ElementGrip el) {
        Interval start = this.map.get(el.getFileObject());
        return start.getParent(el);
    }

    public void put(FileObject parentFile, TreePath tp, CompilationInfo info) {
        Interval root = this.map.get(parentFile);
        Interval i = Interval.createInterval(tp, info, root, null, parentFile);
        if (i != null) {
            this.map.put(parentFile, i);
        }
    }

    private static class Interval {
        long from = -1L;
        long to = -1L;
        Set<Interval> subintervals = new HashSet<Interval>();
        ElementGrip item = null;

        private Interval() {
        }

        Interval get(long position) {
            if (this.from <= position && this.to >= position) {
                for (Interval o : this.subintervals) {
                    Interval ob = o.get(position);
                    if (ob == null) continue;
                    return ob;
                }
                return this;
            }
            return null;
        }

        ElementGrip getParent(ElementGrip eh) {
            for (Interval i : this.subintervals) {
                if (i.item.equals(eh)) {
                    return this.item;
                }
                ElementGrip e = i.getParent(eh);
                if (e == null) continue;
                return e;
            }
            return null;
        }

        public static Interval createInterval(TreePath tp, CompilationInfo info, Interval root, Interval p, FileObject parentFile) {
            Interval o;
            Tree t = tp.getLeaf();
            long start = info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), t);
            long end = info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), t);
            Element current = info.getTrees().getElement(tp);
            Tree.Kind kind = tp.getLeaf().getKind();
            if (kind != Tree.Kind.CLASS && kind != Tree.Kind.METHOD) {
                if (tp.getParentPath().getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                    return null;
                }
                return Interval.createInterval(tp.getParentPath(), info, root, p, parentFile);
            }
            Interval i = null;
            if (root != null && (o = root.get(start)) != null && ((Object)o.item.resolveElement(info)).equals(current)) {
                if (p != null) {
                    o.subintervals.add(p);
                }
                return null;
            }
            if (i == null) {
                i = new Interval();
            }
            if (i.from != start) {
                ElementGrip currentHandle2;
                i.from = start;
                i.to = end;
                i.item = currentHandle2 = new ElementGrip(tp, info);
            }
            if (p != null) {
                i.subintervals.add(p);
            }
            if (tp.getParentPath().getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                return i;
            }
            return Interval.createInterval(tp.getParentPath(), info, root, i, parentFile);
        }
    }
}

