/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import org.netbeans.core.startup.ManifestSection;
import org.openide.util.Lookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoreBridge {
    private static boolean lookupInitialized;

    public static CoreBridge getDefault() {
        CoreBridge b = (CoreBridge)Lookup.getDefault().lookup(CoreBridge.class);
        if (b == null) {
            assert (lookupInitialized);
            b = new FakeBridge();
        }
        return b;
    }

    static void lookupInitialized() {
        lookupInitialized = true;
    }

    static void conditionallyLoaderPoolTransaction(boolean begin) {
        CoreBridge b = (CoreBridge)Lookup.getDefault().lookup(CoreBridge.class);
        if (b != null) {
            b.loaderPoolTransaction(begin);
        }
    }

    static Lookup conditionallyLookupCacheLoad() {
        CoreBridge b = (CoreBridge)Lookup.getDefault().lookup(CoreBridge.class);
        if (b != null) {
            return b.lookupCacheLoad();
        }
        return Lookup.EMPTY;
    }

    static void conditionallyPrintStatus(String txt) {
        CoreBridge b = (CoreBridge)Lookup.getDefault().lookup(CoreBridge.class);
        if (b != null) {
            b.setStatusText(txt);
        } else {
            System.err.println(txt);
        }
    }

    protected abstract void attachToCategory(Object var1);

    protected abstract void loadDefaultSection(ManifestSection var1, InstanceContent.Convertor<ManifestSection, Object> var2, boolean var3);

    protected abstract void loadActionSection(ManifestSection.ActionSection var1, boolean var2) throws Exception;

    protected abstract void loadLoaderSection(ManifestSection.LoaderSection var1, boolean var2) throws Exception;

    protected abstract void loaderPoolTransaction(boolean var1);

    public abstract void registerPropertyEditors();

    protected abstract void loadSettings();

    public abstract Lookup lookupCacheLoad();

    public abstract void lookupCacheStore(Lookup var1) throws IOException;

    public abstract void setStatusText(String var1);

    public abstract void initializePlaf(Class var1, int var2, URL var3);

    public abstract void cliUsage(PrintWriter var1);

    public abstract int cli(String[] var1, InputStream var2, OutputStream var3, OutputStream var4, File var5);

    private static final class FakeBridge
    extends CoreBridge {
        private FakeBridge() {
        }

        protected void attachToCategory(Object category) {
        }

        protected void loadDefaultSection(ManifestSection ms, InstanceContent.Convertor convertor, boolean add) {
        }

        protected void loadActionSection(ManifestSection.ActionSection s, boolean load) throws Exception {
            s.getInstance();
        }

        protected void loadLoaderSection(ManifestSection.LoaderSection s, boolean load) throws Exception {
        }

        protected void loaderPoolTransaction(boolean begin) {
        }

        protected void addToSplashMaxSteps(int cnt) {
        }

        protected void incrementSplashProgressBar() {
        }

        public Lookup lookupCacheLoad() {
            return Lookup.EMPTY;
        }

        public void lookupCacheStore(Lookup l) throws IOException {
        }

        public void setStatusText(String status) {
            System.err.println("STATUS: " + status);
        }

        public void initializePlaf(Class uiClass, int uiFontSize, URL themeURL) {
        }

        public void cliUsage(PrintWriter printWriter) {
        }

        public void registerPropertyEditors() {
        }

        protected void loadSettings() {
        }

        public int cli(String[] string, InputStream inputStream, OutputStream outputStream, OutputStream errorStream, File file) {
            return 0;
        }
    }
}

