/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LazyIterator
implements Iterator<Class> {
    Class first;
    Class step;
    Class<?> template;
    Object skip;
    Iterator delegate;

    LazyIterator(Class first, Class template, Class skip) {
        assert (first != null);
        this.first = first;
        this.template = template;
        this.skip = skip;
    }

    @Override
    public boolean hasNext() {
        if (this.first != null) {
            return true;
        }
        if (this.delegate == null) {
            this.delegate = this.prepareDelegate();
        }
        if (this.step != null) {
            return true;
        }
        while (this.delegate.hasNext() && this.step == null) {
            Class next = ((Lookup.Item)this.delegate.next()).getType();
            if (next == this.skip) continue;
            this.step = next;
        }
        return this.step != null;
    }

    @Override
    public Class next() {
        if (this.first != null) {
            Class ret = this.first;
            this.first = null;
            return ret;
        }
        if (this.delegate == null) {
            this.delegate = this.prepareDelegate();
        }
        if (this.step != null) {
            Class ret = this.step;
            this.step = null;
            return ret;
        }
        while (this.delegate.hasNext()) {
            Class next = ((Lookup.Item)this.delegate.next()).getType();
            if (next == this.skip) continue;
            return next;
        }
        throw new NoSuchElementException();
    }

    private Iterator prepareDelegate() {
        return Lookup.getDefault().lookupResult(this.template).allItems().iterator();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

