/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.NbEvents;
import org.netbeans.core.startup.NbInstaller;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleSystem {
    private final ModuleManager mgr;
    private final NbInstaller installer;
    private final ModuleList list;
    private final Events ev;
    private Set<Module> bootModules = null;

    public ModuleSystem(FileSystem systemFileSystem) throws IOException {
        if (Boolean.getBoolean("org.netbeans.core.startup.ModuleSystem.CULPRIT")) {
            Thread.dumpStack();
        }
        this.ev = Boolean.getBoolean("netbeans.modules.quiet") ? new QuietEvents() : new NbEvents();
        this.installer = new NbInstaller(this.ev);
        this.mgr = new ModuleManager((ModuleInstaller)this.installer, this.ev);
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                if ("classLoader".equals(ev.getPropertyName())) {
                    MainLookup.systemClassLoaderChanged(ModuleSystem.this.mgr.getClassLoader());
                }
            }
        };
        this.mgr.addPropertyChangeListener(l);
        MainLookup.systemClassLoaderChanged(((Object)((Object)this.installer)).getClass().getClassLoader());
        MainLookup.moduleLookupReady(this.mgr.getModuleLookup());
        if (systemFileSystem.isReadOnly()) {
            this.list = null;
        } else {
            FileObject root = systemFileSystem.getRoot();
            FileObject modulesFolder = root.getFileObject("Modules");
            if (modulesFolder == null) {
                modulesFolder = root.createFolder("Modules");
            }
            this.list = new ModuleList(this.mgr, modulesFolder, this.ev);
            this.installer.registerList(this.list);
            this.installer.registerManager(this.mgr);
        }
        this.ev.log("createdModuleSystem", new Object[0]);
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public Events getEvents() {
        return this.ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getModuleJars() {
        this.mgr.mutexPrivileged().enterReadAccess();
        try {
            ArrayList<File> l = new ArrayList<File>();
            for (Module m : this.mgr.getEnabledModules()) {
                l.addAll(m.getAllJars());
            }
            ArrayList<File> arrayList = l;
            return arrayList;
        }
        finally {
            this.mgr.mutexPrivileged().exitReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBootModules() {
        ArrayList<String> ignoredPrefixes = new ArrayList<String>(3);
        try {
            String nbhomeS;
            File f;
            String jdk = System.getProperty("java.home");
            if (jdk.endsWith(File.separator + "jre")) {
                jdk = jdk.substring(0, jdk.length() - 4);
            }
            if (new File(new File(f = new File(jdk), "lib"), "tools.jar").isFile()) {
                ignoredPrefixes.add("jar:" + f.toURI().toURL());
            }
            if ((nbhomeS = System.getProperty("netbeans.home")) != null) {
                File nbhome = new File(nbhomeS);
                f = new File(new File(nbhome, "lib"), "ext");
                ignoredPrefixes.add("jar:" + f.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            Util.err.log(Level.WARNING, null, e);
        }
        Util.err.log(Level.FINE, "ignoredPrefixes={0}", ignoredPrefixes);
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startLoadBootModules", new Object[0]);
        try {
            this.bootModules = new HashSet<Module>(10);
            ClassLoader loader = ModuleSystem.class.getClassLoader();
            Enumeration<URL> e = loader.getResources("META-INF/MANIFEST.MF");
            this.ev.log("perfTick", new Object[]{"got all manifests"});
            HashSet<URL> checkedManifests = new HashSet<URL>();
            block15: while (e.hasMoreElements()) {
                InputStream is;
                URL manifestUrl = e.nextElement();
                if (!checkedManifests.add(manifestUrl)) continue;
                String manifestUrlS = manifestUrl.toExternalForm();
                for (String pref : ignoredPrefixes) {
                    if (!manifestUrlS.startsWith(pref)) continue;
                    Util.err.log(Level.FINE, "ignoring JDK/JRE manifest: {0}", manifestUrlS);
                    continue block15;
                }
                Util.err.log(Level.FINE, "Checking boot manifest: {0}", manifestUrlS);
                try {
                    is = manifestUrl.openStream();
                }
                catch (IOException ioe) {
                    Exceptions.attachMessage((Throwable)ioe, (String)("URL: " + manifestUrl));
                    throw ioe;
                }
                try {
                    Manifest mani = new Manifest(is);
                    Attributes attr = mani.getMainAttributes();
                    if (attr.getValue("OpenIDE-Module") == null) continue;
                    this.bootModules.add(this.mgr.createFixed(mani, (Object)manifestUrl, loader));
                }
                finally {
                    is.close();
                }
            }
            if (this.list == null) {
                this.mgr.enable(this.bootModules);
            }
            this.ev.log("perfTick", new Object[]{"added all classpath modules"});
        }
        catch (IOException ioe) {
            Util.err.log(Level.WARNING, null, ioe);
        }
        catch (DuplicateException de) {
            Util.err.log(Level.WARNING, null, de);
        }
        finally {
            this.ev.log("finishLoadBootModules", new Object[0]);
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readList() {
        this.ev.log("perfStart", new Object[]{"ModuleSystem.readList"});
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            this.list.readInitial();
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        this.ev.log("perfEnd", new Object[]{"ModuleSystem.readList"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        this.ev.log("perfStart", new Object[]{"ModuleSystem.restore"});
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            HashSet<Module> toTrigger = new HashSet<Module>(this.bootModules);
            this.list.trigger(toTrigger);
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        this.ev.log("perfEnd", new Object[]{"ModuleSystem.restore"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutDown(Runnable midHook) {
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            boolean bl = this.mgr.shutDown(midHook);
            return bl;
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deployTestModule(File jar) throws IOException {
        if (!jar.isAbsolute()) {
            throw new IOException("Absolute paths only please");
        }
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startDeployTestModule", new Object[]{jar});
        System.err.println("Deploying test module " + jar + "...");
        try {
            Module tm = null;
            HashSet<Module> toReenable = new HashSet<Module>();
            for (Module m : this.mgr.getModules()) {
                if (m.getJarFile() == null || !jar.equals(m.getJarFile())) continue;
                if (!m.isReloadable()) {
                    m.setReloadable(true);
                }
                this.turnOffModule(m, toReenable);
                this.mgr.reload(m);
                tm = m;
                break;
            }
            if (tm == null) {
                try {
                    tm = this.mgr.create(jar, (Object)new ModuleHistory(jar.getAbsolutePath()), true, false, false);
                }
                catch (DuplicateException dupe) {
                    Module old = dupe.getOldModule();
                    System.err.println("Replacing old module in " + old);
                    this.turnOffModule(old, toReenable);
                    this.mgr.delete(old);
                    try {
                        tm = this.mgr.create(jar, (Object)new ModuleHistory(jar.getAbsolutePath()), true, false, false);
                    }
                    catch (DuplicateException dupe2) {
                        throw (IOException)new IOException(dupe2.toString()).initCause(dupe2);
                    }
                }
            }
            System.err.println("Enabling " + tm + "...");
            if (!this.mgr.simulateEnable(Collections.singleton(tm)).contains(tm)) {
                throw new IOException("Cannot enable " + tm + "; problems: " + tm.getProblems());
            }
            this.mgr.enable(tm);
            if (!toReenable.isEmpty()) {
                System.err.println("Also re-enabling:");
                for (Module m : toReenable) {
                    System.err.println("\t" + m.getDisplayName());
                    if (!m.isReloadable()) continue;
                    m.reload();
                }
                try {
                    this.mgr.enable(toReenable);
                }
                catch (IllegalArgumentException iae) {
                    throw new IOException(iae.toString());
                }
            }
            System.err.println("Done.");
        }
        catch (Throwable throwable) {
            this.ev.log("finishDeployTestModule", new Object[]{jar});
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.ev.log("finishDeployTestModule", new Object[]{jar});
        this.mgr.mutexPrivileged().exitWriteAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnOffModule(Module m, Set<Module> toReenable) {
        if (!m.isEnabled()) {
            return;
        }
        for (Module m2 : this.mgr.simulateDisable(Collections.singleton(m))) {
            if (m2.isAutoload() || m2.isEager()) continue;
            toReenable.add(m2);
        }
        try {
            System.err.println("Disabling " + m + "...");
            this.mgr.disable(toReenable);
        }
        finally {
            toReenable.remove(m);
        }
    }

    public String getEffectiveClasspath(Module m) {
        return this.installer.getEffectiveClasspath(m);
    }

    private static final class QuietEvents
    extends Events {
        QuietEvents() {
        }

        protected void logged(String message, Object[] args) {
        }
    }
}

