/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.netbeans.core.startup.AutomaticDependencies;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ManifestSection;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.lookup.InstanceContent;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NbInstaller
extends ModuleInstaller {
    private final Map<Module, Set<ManifestSection>> sections = new HashMap<Module, Set<ManifestSection>>(100);
    private final Map<Module, Class<? extends ModuleInstall>> installs = new HashMap<Module, Class<? extends ModuleInstall>>(100);
    private final Map<Module, String> layers = new HashMap<Module, String>(100);
    private boolean initializedFolderLookup = false;
    private final Events ev;
    private ModuleList moduleList;
    private ModuleManager mgr;
    private final Map<Module, Set<String>> kosherPackages = new HashMap<Module, Set<String>>(100);
    private static String[] specialResourcePrefixes = null;
    private final InstanceContent.Convertor<ManifestSection, Object> convertor = new Convertor();
    private AutomaticDependencies autoDepsHandler = null;
    private static final String[] CLASSPATH_PACKAGES = new String[]{"org/netbeans/core/startup/", "com/sun/tools/javac/", "com/sun/tools/javadoc/", "com/sun/javadoc/", "com/sun/source/", "javax/annotation/", "javax/lang/model/", "javax/tools/", "javax/xml/bind/", "javax/xml/ws/", "javax/xml/stream/", "javax/jws/", "javax/xml/soap/"};
    private static boolean withoutOptimizations;
    private static final String[][] CLASSPATH_JARS;
    private File manifestCacheFile;
    private boolean usingManifestCache = Boolean.valueOf(System.getProperty("netbeans.cache.manifests", "true"));
    private Map<File, Object[]> manifestCache;
    private boolean manifestCacheDirty;

    public NbInstaller(Events ev) {
        if (this.usingManifestCache) {
            String userdir = System.getProperty("netbeans.user");
            if (userdir != null) {
                this.manifestCacheFile = new File(new File(new File(new File(userdir), "var"), "cache"), "all-manifests.dat");
                Util.err.fine("Using manifest cache in " + this.manifestCacheFile);
            } else {
                this.usingManifestCache = false;
                Util.err.fine("Not using any manifest cache; no user directory");
            }
        } else {
            Util.err.fine("Manifest cache disabled");
        }
        this.manifestCache = null;
        this.manifestCacheDirty = false;
        this.ev = ev;
    }

    void registerList(ModuleList list) {
        if (this.moduleList != null) {
            throw new IllegalStateException();
        }
        this.moduleList = list;
    }

    void registerManager(ModuleManager manager) {
        if (this.mgr != null) {
            throw new IllegalStateException();
        }
        this.mgr = manager;
    }

    public void prepare(Module m) throws InvalidException {
        URL layer;
        String layerResource;
        this.ev.log("prepare", new Object[]{m});
        HashSet<ManifestSection> mysections = null;
        Class<?> clazz = null;
        for (Map.Entry<String, Attributes> entry : m.getManifest().getEntries().entrySet()) {
            ManifestSection section = ManifestSection.create(entry.getKey(), entry.getValue(), m);
            if (section == null) continue;
            if (mysections == null) {
                mysections = new HashSet<ManifestSection>(25);
            }
            mysections.add(section);
        }
        String installClass = m.getManifest().getMainAttributes().getValue("OpenIDE-Module-Install");
        if (installClass != null) {
            String installClassName;
            try {
                installClassName = Util.createPackageName((String)installClass);
            }
            catch (IllegalArgumentException iae) {
                InvalidException ie = new InvalidException(m, iae.toString());
                ie.initCause((Throwable)iae);
                throw ie;
            }
            if (installClass.endsWith(".ser")) {
                throw new InvalidException(m, "Serialized module installs not supported: " + installClass);
            }
            try {
                Class<?> c;
                clazz = Class.forName(installClassName, false, m.getClassLoader());
                if (clazz.getClassLoader() != m.getClassLoader()) {
                    this.ev.log("wrongClassLoader", new Object[]{m, clazz, m.getClassLoader()});
                }
                for (c = clazz; c != ModuleInstall.class && c != Object.class; c = c.getSuperclass()) {
                    try {
                        c.getDeclaredMethod("validate", new Class[0]);
                        ModuleInstall install = (ModuleInstall)SharedClassObject.findObject(clazz.asSubclass(ModuleInstall.class), (boolean)true);
                        install.validate();
                        continue;
                    }
                    catch (NoSuchMethodException nsme) {
                        // empty catch block
                    }
                }
                if (c == Object.class) {
                    throw new ClassCastException("Should extend ModuleInstall: " + clazz.getName());
                }
            }
            catch (Exception t) {
                InvalidException ie = new InvalidException(m, t.toString());
                ie.initCause((Throwable)t);
                throw ie;
            }
            catch (LinkageError t) {
                InvalidException ie = new InvalidException(m, t.toString());
                ie.initCause((Throwable)t);
                throw ie;
            }
        }
        if ((layerResource = m.getManifest().getMainAttributes().getValue("OpenIDE-Module-Layer")) != null && (layer = m.getClassLoader().getResource(layerResource)) == null) {
            throw new InvalidException(m, "Layer not found: " + layerResource);
        }
        String helpSetName = m.getManifest().getMainAttributes().getValue("OpenIDE-Module-Description");
        if (helpSetName != null) {
            Util.err.warning("Use of OpenIDE-Module-Description in " + m.getCodeNameBase() + " is deprecated.");
            Util.err.warning("(Please install help using an XML layer instead.)");
        }
        if (mysections != null) {
            this.sections.put(m, mysections);
        }
        if (clazz != null) {
            this.installs.put(m, clazz.asSubclass(ModuleInstall.class));
        }
        if (layerResource != null) {
            this.layers.put(m, layerResource);
        }
    }

    public void dispose(Module m) {
        Util.err.fine("dispose: " + m);
        Set<ManifestSection> s = this.sections.remove(m);
        if (s != null) {
            for (ManifestSection sect : s) {
                sect.dispose();
            }
        }
        this.installs.remove(m);
        this.layers.remove(m);
        this.kosherPackages.remove(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(List<Module> modules) {
        this.ev.log("startLoad", new Object[]{modules});
        if (this.mgr != null) {
            MainLookup.systemClassLoaderChanged(this.mgr.getClassLoader());
        }
        this.ev.log("perfTick", new Object[]{"META-INF/services/ additions registered"});
        for (Module m : modules) {
            this.checkForDeprecations(m);
            NbInstaller.openideModuleEnabled(m);
        }
        this.loadLayers(modules, true);
        this.ev.log("perfTick", new Object[]{"layers loaded"});
        this.ev.log("perfStart", new Object[]{"NbInstaller.load - sections"});
        this.ev.log("loadSection", new Object[0]);
        CoreBridge.conditionallyLoaderPoolTransaction(true);
        try {
            for (Module m : modules) {
                try {
                    this.loadSections(m, true);
                }
                catch (Exception t) {
                    Util.err.log(Level.SEVERE, null, t);
                }
                catch (LinkageError le) {
                    Util.err.log(Level.SEVERE, null, le);
                }
                this.ev.log("perfTick", new Object[]{"sections for " + m.getCodeName() + " loaded"});
            }
        }
        finally {
            CoreBridge.conditionallyLoaderPoolTransaction(false);
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller.load - sections"});
        if (!this.initializedFolderLookup) {
            Util.err.fine("modulesClassPathInitialized");
            MainLookup.modulesClassPathInitialized();
            this.initializedFolderLookup = true;
        }
        Main.initUICustomizations();
        this.ev.log("perfStart", new Object[]{"NbInstaller.load - ModuleInstalls"});
        for (Module m : modules) {
            try {
                this.loadCode(m, true);
            }
            catch (Exception t) {
                Util.err.log(Level.SEVERE, null, t);
            }
            catch (LinkageError le) {
                Util.err.log(Level.SEVERE, null, le);
            }
            catch (AssertionError e) {
                Util.err.log(Level.SEVERE, null, (Throwable)((Object)e));
            }
            this.ev.log("perfTick", new Object[]{"ModuleInstall for " + m.getCodeName() + " called"});
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller.load - ModuleInstalls"});
        this.ev.log("finishLoad", new Object[]{modules});
        this.maybeSaveManifestCache();
        if (Boolean.getBoolean("netbeans.preresolve.classes")) {
            this.preresolveClasses(modules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(List<Module> modules) {
        this.ev.log("startUnload", new Object[]{modules});
        for (Module m : modules) {
            try {
                this.loadCode(m, false);
            }
            catch (Exception t) {
                Util.err.log(Level.SEVERE, null, t);
            }
            catch (LinkageError le) {
                Util.err.log(Level.SEVERE, null, le);
            }
        }
        CoreBridge.conditionallyLoaderPoolTransaction(true);
        try {
            for (Module m : modules) {
                try {
                    this.loadSections(m, false);
                }
                catch (Exception t) {
                    Util.err.log(Level.SEVERE, null, t);
                }
                catch (LinkageError le) {
                    Util.err.log(Level.SEVERE, null, le);
                }
            }
        }
        finally {
            try {
                CoreBridge.conditionallyLoaderPoolTransaction(false);
            }
            catch (RuntimeException e) {
                Util.err.log(Level.SEVERE, null, e);
            }
        }
        this.loadLayers(modules, false);
        this.ev.log("finishUnload", new Object[]{modules});
    }

    private void loadCode(Module m, boolean load) throws Exception {
        Class<? extends ModuleInstall> instClazz = this.installs.get(m);
        if (instClazz != null) {
            ModuleInstall inst = (ModuleInstall)SharedClassObject.findObject(instClazz, (boolean)true);
            if (load) {
                Object history;
                if (this.moduleList != null) {
                    this.moduleList.installPrepare(m, inst);
                }
                if ((history = m.getHistory()) instanceof ModuleHistory) {
                    ModuleHistory h = (ModuleHistory)history;
                    if (h.isPreviouslyInstalled()) {
                        SpecificationVersion oldSpec = h.getOldSpecificationVersion();
                        SpecificationVersion nueSpec = m.getSpecificationVersion();
                        if (m.getCodeNameRelease() != h.getOldMajorVersion() || oldSpec == null ^ nueSpec == null || oldSpec != null && nueSpec != null && oldSpec.compareTo((Object)nueSpec) != 0) {
                            this.ev.log("update", new Object[]{m});
                            inst.updated(h.getOldMajorVersion(), oldSpec == null ? null : oldSpec.toString());
                        } else {
                            this.ev.log("restore", new Object[]{m});
                            inst.restored();
                        }
                    } else {
                        this.ev.log("install", new Object[]{m});
                        inst.installed();
                    }
                } else {
                    this.ev.log("restore", new Object[]{m});
                    inst.restored();
                }
                if (this.moduleList != null) {
                    this.moduleList.installPostpare(m, inst);
                }
            } else {
                this.ev.log("uninstall", new Object[]{m});
                inst.uninstalled();
                if (m.getHistory() instanceof ModuleHistory) {
                    ((ModuleHistory)m.getHistory()).resetHistory();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSections(Module m, boolean load) throws Exception {
        Set<ManifestSection> s = this.sections.get(m);
        if (s == null) {
            return;
        }
        boolean attachedToMA = false;
        try {
            this.ev.log("loadSection", new Object[0]);
            for (ManifestSection sect : s) {
                if (sect instanceof ManifestSection.ActionSection) {
                    if (!attachedToMA) {
                        Object category = m.getLocalizedAttribute("OpenIDE-Module-Display-Category");
                        if (category == null) {
                            category = m.getCodeNameBase();
                        }
                        CoreBridge.getDefault().attachToCategory(category);
                        attachedToMA = true;
                    }
                    CoreBridge.getDefault().loadActionSection((ManifestSection.ActionSection)sect, load);
                    continue;
                }
                if (sect instanceof ManifestSection.ClipboardConvertorSection) {
                    this.loadGenericSection(sect, load);
                    continue;
                }
                if (sect instanceof ManifestSection.DebuggerSection) {
                    this.loadGenericSection(sect, load);
                    continue;
                }
                if (sect instanceof ManifestSection.LoaderSection) {
                    CoreBridge.getDefault().loadLoaderSection((ManifestSection.LoaderSection)sect, load);
                    continue;
                }
                assert (false) : sect;
            }
        }
        finally {
            if (attachedToMA) {
                CoreBridge.getDefault().attachToCategory(null);
            }
        }
    }

    private void loadGenericSection(ManifestSection s, boolean load) {
        CoreBridge.getDefault().loadDefaultSection(s, this.convertor, load);
    }

    private void loadLayers(List<Module> modules, boolean load) {
        this.ev.log(load ? "loadLayers" : "unloadLayers", new Object[]{modules});
        modules = new ArrayList<Module>(modules);
        Collections.reverse(modules);
        HashMap urls = new HashMap(5);
        for (Module module : modules) {
            String ext;
            String base;
            String s = this.layers.get(module);
            if (s == null) continue;
            Util.err.fine("loadLayer: " + s + " load=" + load);
            int idx = s.lastIndexOf(46);
            if (idx == -1) {
                base = s;
                ext = "";
            } else {
                base = s.substring(0, idx);
                ext = s.substring(idx);
            }
            ClassLoader cl = module.getClassLoader();
            ModuleLayeredFileSystem host = module.isReloadable() ? ModuleLayeredFileSystem.getUserModuleLayer() : ModuleLayeredFileSystem.getInstallationModuleLayer();
            ArrayList<URL> theseurls = (ArrayList<URL>)urls.get((Object)host);
            if (theseurls == null) {
                theseurls = new ArrayList<URL>(100);
                urls.put(host, theseurls);
            }
            boolean foundSomething = false;
            for (String suffix : NbCollections.iterable((Iterator)NbBundle.getLocalizingSuffixes())) {
                String resource = base + suffix + ext;
                URL u = cl.getResource(resource);
                if (u == null) continue;
                theseurls.add(u);
                foundSomething = true;
            }
            if (foundSomething) continue;
            Util.err.fine("Module layer not found: " + s);
        }
        for (Map.Entry entry : urls.entrySet()) {
            ModuleLayeredFileSystem host = (ModuleLayeredFileSystem)((Object)entry.getKey());
            List theseurls = (List)entry.getValue();
            Util.err.fine("Adding/removing layer URLs: host=" + (Object)((Object)host) + " urls=" + theseurls);
            try {
                if (load) {
                    host.addURLs(theseurls);
                    continue;
                }
                host.removeURLs(theseurls);
            }
            catch (Exception e) {
                Util.err.log(Level.WARNING, null, e);
            }
        }
    }

    private void checkForDeprecations(Module m) {
        if (!Boolean.valueOf((String)m.getAttribute("OpenIDE-Module-Deprecated")).booleanValue()) {
            for (Dependency dep : m.getDependencies()) {
                if (dep.getType() != 1) continue;
                String cnb = (String)Util.parseCodeName((String)dep.getName())[0];
                Module o = this.mgr.get(cnb);
                if (o == null) {
                    throw new IllegalStateException("No such module: " + cnb);
                }
                if (!Boolean.parseBoolean((String)o.getAttribute("OpenIDE-Module-Deprecated"))) continue;
                String message = (String)o.getLocalizedAttribute("OpenIDE-Module-Deprecation-Message");
                if (message != null) {
                    Util.err.warning("the module " + m.getCodeNameBase() + " uses " + cnb + " which is deprecated: " + message);
                    continue;
                }
                Util.err.warning("the module " + m.getCodeNameBase() + " uses " + cnb + " which is deprecated.");
            }
        }
    }

    public boolean closing(List<Module> modules) {
        Util.err.fine("closing: " + modules);
        for (Module m : modules) {
            Class<? extends ModuleInstall> instClazz = this.installs.get(m);
            if (instClazz == null) continue;
            try {
                ModuleInstall inst = (ModuleInstall)SharedClassObject.findObject(instClazz, (boolean)true);
                if (inst.closing()) continue;
                Util.err.fine("Module " + m + " refused to close");
                return false;
            }
            catch (RuntimeException re) {
                Util.err.log(Level.SEVERE, null, re);
            }
            catch (LinkageError le) {
                Util.err.log(Level.SEVERE, null, le);
            }
        }
        return true;
    }

    public void close(List<Module> modules) {
        Util.err.fine("close: " + modules);
        this.ev.log("close", new Object[0]);
        for (Module m : modules) {
            Class<? extends ModuleInstall> instClazz = this.installs.get(m);
            if (instClazz == null) continue;
            try {
                ModuleInstall inst = (ModuleInstall)SharedClassObject.findObject(instClazz, (boolean)true);
                if (inst == null) {
                    throw new IllegalStateException("Inconsistent state: " + instClazz);
                }
                inst.close();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                Util.err.log(Level.SEVERE, null, t);
            }
        }
    }

    public void refineDependencies(Module m, Set<Dependency> dependencies) {
        AutomaticDependencies.Report rep;
        if (Boolean.getBoolean("org.netbeans.core.modules.NbInstaller.noAutoDeps")) {
            return;
        }
        if (this.autoDepsHandler == null) {
            FileObject depsFolder = Repository.getDefault().getDefaultFileSystem().findResource("ModuleAutoDeps");
            if (depsFolder != null) {
                FileObject[] kids = depsFolder.getChildren();
                ArrayList<URL> urls = new ArrayList<URL>(Math.max(kids.length, 1));
                for (FileObject kid : kids) {
                    if (!kid.hasExt("xml")) continue;
                    try {
                        urls.add(kid.getURL());
                    }
                    catch (FileStateInvalidException e) {
                        Util.err.log(Level.WARNING, null, e);
                    }
                }
                try {
                    this.autoDepsHandler = AutomaticDependencies.parse(urls.toArray(new URL[urls.size()]));
                }
                catch (IOException e) {
                    Util.err.log(Level.WARNING, null, e);
                }
                catch (SAXException e) {
                    Util.err.log(Level.WARNING, null, e);
                }
            }
            if (this.autoDepsHandler == null) {
                this.autoDepsHandler = AutomaticDependencies.empty();
            }
            if (Util.err.isLoggable(Level.FINE)) {
                Util.err.fine("Auto deps: " + this.autoDepsHandler);
            }
        }
        if ((rep = this.autoDepsHandler.refineDependenciesAndReport(m.getCodeNameBase(), dependencies)).isModified()) {
            Util.err.warning("had to upgrade dependencies for module " + m.getCodeNameBase() + ": added = " + rep.getAdded() + " removed = " + rep.getRemoved() + "; details: " + rep.getMessages());
        }
    }

    public String[] refineProvides(Module m) {
        if (m.getCodeNameBase().equals("org.openide.modules")) {
            boolean isOS2;
            ArrayList<String> arr = new ArrayList<String>(4);
            boolean bl = isOS2 = (Utilities.getOperatingSystem() & 0x800) != 0;
            if (Utilities.isUnix()) {
                arr.add("org.openide.modules.os.Unix");
                if (!Utilities.isMac()) {
                    arr.add("org.openide.modules.os.PlainUnix");
                }
            }
            if (Utilities.isWindows()) {
                arr.add("org.openide.modules.os.Windows");
            }
            if (Utilities.isMac()) {
                arr.add("org.openide.modules.os.MacOSX");
            }
            if (isOS2) {
                arr.add("org.openide.modules.os.OS2");
            }
            arr.add("org.openide.modules.ModuleFormat1");
            return arr.toArray(new String[0]);
        }
        return null;
    }

    public boolean shouldDelegateResource(Module m, Module parent, String pkg) {
        if (parent == null) {
            for (String cppkg : CLASSPATH_PACKAGES) {
                if (!pkg.startsWith(cppkg) || this.findKosher(m).contains(cppkg)) continue;
                if (Util.err.isLoggable(Level.FINE)) {
                    Util.err.fine("Refusing to load classpath package " + pkg + " for " + m.getCodeNameBase() + " without a proper dependency");
                }
                return false;
            }
        }
        return true;
    }

    private Set<String> findKosher(Module m) {
        Set<String> s = this.kosherPackages.get(m);
        if (s == null) {
            s = new HashSet<String>();
            Set deps = m.getDependencies();
            SpecificationVersion openide = Util.getModuleDep((Set)deps, (String)"org.openide");
            boolean pre27853 = openide == null || openide.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
            for (Dependency dep : deps) {
                String req;
                if (dep.getType() == 1 && dep.getName().equals("org.netbeans.core.startup/1")) {
                    s.add("org/netbeans/core/startup/");
                    continue;
                }
                if (pre27853 && dep.getType() == 1) {
                    Module other;
                    String name = dep.getName();
                    int idx = name.indexOf(47);
                    if (idx != -1) {
                        name = name.substring(0, idx);
                    }
                    if ((other = this.mgr.get(name)) == null) {
                        throw new IllegalStateException("Should have found dep " + dep + " from " + m);
                    }
                    s.addAll(this.findKosher(other));
                    continue;
                }
                if (dep.getType() != 2) continue;
                String depname = dep.getName();
                int idx = depname.indexOf(91);
                if (idx == -1) {
                    req = depname.replace('.', '/').concat("/");
                } else if (idx == 0) {
                    int idx2 = depname.lastIndexOf(46);
                    req = depname.substring(1, idx2).replace('.', '/').concat("/");
                } else {
                    req = depname.substring(0, idx).replace('.', '/').concat("/");
                }
                for (String cppkg : CLASSPATH_PACKAGES) {
                    if (!req.startsWith(cppkg)) continue;
                    s.add(cppkg);
                }
            }
            if (s.isEmpty()) {
                s = Collections.emptySet();
            }
            this.kosherPackages.put(m, s);
        }
        return s;
    }

    static void openideModuleEnabled(Module module) {
        String m = module.getCodeNameBase();
        if (!m.startsWith("org.openide.")) {
            return;
        }
        if ("org.openide.util".equals(m)) {
            return;
        }
        if ("org.openide.actions".equals(m)) {
            return;
        }
        if ("org.openide.awt".equals(m)) {
            return;
        }
        if ("org.openide.modules".equals(m)) {
            return;
        }
        if ("org.openide.nodes".equals(m)) {
            return;
        }
        if ("org.openide.windows".equals(m)) {
            return;
        }
        if ("org.openide.explorer".equals(m)) {
            return;
        }
        if ("org.openide.util.enumerations".equals(m)) {
            return;
        }
        if ("org.openide.execution".equals(m)) {
            return;
        }
        if ("org.openide.options".equals(m)) {
            return;
        }
        if ("org.openide.execution".equals(m)) {
            return;
        }
        if ("org.openide.loaders".equals(m)) {
            return;
        }
        if ("org.openide.dialogs".equals(m)) {
            return;
        }
        if ("org.openide.filesystems".equals(m)) {
            return;
        }
        if ("org.openide.io".equals(m)) {
            return;
        }
        if ("org.openide.text".equals(m)) {
            return;
        }
        if ("org.openide.src".equals(m)) {
            return;
        }
        Util.err.warning("Disabling openide load optimizations due to use of " + m);
        withoutOptimizations = true;
    }

    public boolean isSpecialResource(String pkg) {
        if (pkg.startsWith("org/openide/")) {
            if ("org/openide/".equals(pkg)) {
                return true;
            }
            if ("org/openide/actions/".equals(pkg)) {
                return true;
            }
            if ("org/openide/awt/".equals(pkg)) {
                return true;
            }
            if ("org/openide/cookies/".equals(pkg)) {
                return true;
            }
            if ("org/openide/explorer/propertysheet/editors/".equals(pkg)) {
                return true;
            }
            if ("org/openide/windows/".equals(pkg)) {
                return true;
            }
            if ("org/openide/text/".equals(pkg)) {
                return true;
            }
            if ("org/openide/util/actions/".equals(pkg)) {
                return true;
            }
            if (withoutOptimizations) {
                if ("org/openide/explorer/".equals(pkg)) {
                    return true;
                }
                if ("org/openide/util/".equals(pkg)) {
                    return true;
                }
            }
        }
        if (this.isSpecialResourceFromSystemProperty(pkg)) {
            return true;
        }
        if (pkg.equals("org/w3c/dom/")) {
            return true;
        }
        if (pkg.equals("org/w3c/dom/ls/")) {
            return true;
        }
        return super.isSpecialResource(pkg);
    }

    private boolean isSpecialResourceFromSystemProperty(String pkg) {
        for (String prefix : NbInstaller.getSpecialResourcePrefixes()) {
            if (!pkg.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static String[] getSpecialResourcePrefixes() {
        if (specialResourcePrefixes == null) {
            String sysProp = System.getProperty("org.netbeans.core.startup.specialResource");
            specialResourcePrefixes = sysProp != null ? sysProp.split(",") : new String[0];
        }
        return specialResourcePrefixes;
    }

    String getEffectiveClasspath(Module m) {
        if (!m.isEnabled()) {
            return "";
        }
        ArrayList<String> l = new ArrayList<String>(100);
        NbInstaller.createBootClassPath(l);
        Set<String> kosher = m.isFixed() ? null : this.findKosher(m);
        StringTokenizer tok = new StringTokenizer(System.getProperty("java.class.path", ""), File.pathSeparator);
        while (tok.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(tok.nextToken()), l, kosher);
        }
        tok = new StringTokenizer(System.getProperty("netbeans.dynamic.classpath", ""), File.pathSeparator);
        while (tok.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(tok.nextToken()), l, kosher);
        }
        HashSet<Module> modulesConsidered = new HashSet<Module>(50);
        HashSet<String> implDeps = new HashSet<String>(10);
        for (Dependency dep : m.getDependencies()) {
            if (dep.getType() != 1 || dep.getComparison() != 2) continue;
            implDeps.add(dep.getName());
        }
        SpecificationVersion openide = Util.getModuleDep((Set)m.getDependencies(), (String)"org.openide");
        boolean pre27853 = openide == null || openide.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
        this.addModuleClasspathEntries(m, m, modulesConsidered, implDeps, l, pre27853 ? Integer.MAX_VALUE : 1);
        StringBuilder buf = new StringBuilder(l.size() * 100 + 1);
        for (String s : l) {
            if (buf.length() > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    private static void createBootClassPath(List<String> l) {
        String extensions;
        String boot = System.getProperty("sun.boot.class.path");
        if (boot != null) {
            StringTokenizer tok = new StringTokenizer(boot, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                l.add(tok.nextToken());
            }
        }
        if ((extensions = System.getProperty("java.ext.dirs")) != null) {
            StringTokenizer st = new StringTokenizer(extensions, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                File[] entries = dir.listFiles();
                if (entries == null) continue;
                for (File f : entries) {
                    String name = f.getName().toLowerCase(Locale.US);
                    if (!name.endsWith(".zip") && !name.endsWith(".jar")) continue;
                    l.add(f.getAbsolutePath());
                }
            }
        }
    }

    private static void addStartupClasspathEntry(File cpEntry, List<String> cp, Set<String> kosher) {
        if (cpEntry.isDirectory()) {
            cp.add(cpEntry.getAbsolutePath());
            return;
        }
        String name = cpEntry.getName();
        for (String[] cpjar : CLASSPATH_JARS) {
            if (kosher == null || !name.startsWith(cpjar[0])) continue;
            StringBuffer entry = null;
            for (int k = 1; k < cpjar.length; ++k) {
                String pkg = cpjar[k];
                if (!kosher.contains(pkg)) continue;
                if (entry == null) {
                    entry = new StringBuffer(100);
                    entry.append(cpEntry.getAbsolutePath());
                    entry.append('[');
                } else {
                    entry.append(',');
                }
                entry.append(pkg.replace('/', '.'));
                entry.append("**");
            }
            if (entry != null) {
                entry.append(']');
                cp.add(entry.toString());
            }
            return;
        }
        cp.add(cpEntry.getAbsolutePath());
    }

    private void addModuleClasspathEntries(Module m, Module orig, Set<Module> considered, Set<String> implDeps, List<String> cp, int depth) {
        if (!considered.add(m)) {
            return;
        }
        for (Dependency dep : m.getDependencies()) {
            if (dep.getType() != 1) continue;
            String cnb = (String)Util.parseCodeName((String)dep.getName())[0];
            Module next = this.mgr.get(cnb);
            if (next == null) {
                throw new IllegalStateException("No such module: " + cnb);
            }
            if (depth <= 0) continue;
            this.addModuleClasspathEntries(next, orig, considered, implDeps, cp, depth - 1);
        }
        boolean friend = m == orig || implDeps.contains(m.getCodeName());
        Module.PackageExport[] exports = friend ? null : m.getPublicPackages();
        String qualification = "";
        if (exports != null) {
            if (exports.length == 0) {
                return;
            }
            StringBuffer b = new StringBuffer(100);
            b.append('[');
            for (int i = 0; i < exports.length; ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(exports[i].pkg.replace('/', '.'));
                b.append(exports[i].recursive ? "**" : "*");
            }
            b.append(']');
            qualification = b.toString();
        }
        for (File jar : m.getAllJars()) {
            cp.add(jar.getAbsolutePath() + qualification);
        }
    }

    public Manifest loadManifest(File jar) throws IOException {
        Object[] entry;
        if (!this.usingManifestCache) {
            return super.loadManifest(jar);
        }
        if (this.manifestCache == null) {
            this.manifestCache = this.loadManifestCache(this.manifestCacheFile);
        }
        if ((entry = this.manifestCache.get(jar)) != null) {
            if (((Date)entry[0]).getTime() == jar.lastModified()) {
                Util.err.fine("Found manifest for " + jar + " in cache");
                return (Manifest)entry[1];
            }
            Util.err.fine("Wrong timestamp for " + jar + " in manifest cache");
        } else {
            Util.err.fine("No entry for " + jar + " in manifest cache");
        }
        Manifest m = super.loadManifest(jar);
        this.manifestCache.put(jar, new Object[]{new Date(jar.lastModified()), m});
        this.manifestCacheDirty = true;
        return m;
    }

    private void maybeSaveManifestCache() {
        if (this.usingManifestCache && this.manifestCacheDirty) {
            try {
                this.saveManifestCache(this.manifestCache, this.manifestCacheFile);
            }
            catch (IOException ioe) {
                Util.err.log(Level.WARNING, null, ioe);
            }
            this.usingManifestCache = false;
            this.manifestCacheDirty = false;
            this.manifestCache = null;
            this.manifestCacheFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveManifestCache(Map<File, Object[]> manifestCache, File manifestCacheFile) throws IOException {
        Util.err.fine("Saving manifest cache");
        manifestCacheFile.getParentFile().mkdirs();
        OutputStream os = new FileOutputStream(manifestCacheFile);
        try {
            try {
                os = new BufferedOutputStream(os);
                for (Map.Entry<File, Object[]> entry : manifestCache.entrySet()) {
                    File jar = entry.getKey();
                    Object[] v = entry.getValue();
                    long time = ((Date)v[0]).getTime();
                    Manifest m = (Manifest)v[1];
                    os.write(jar.getAbsolutePath().getBytes("UTF-8"));
                    os.write(0);
                    for (int i = 7; i >= 0; --i) {
                        os.write((int)(time >> i * 8 & 0xFFL));
                    }
                    m.write(os);
                    os.write(0);
                }
            }
            finally {
                os.close();
            }
        }
        catch (IOException ioe) {
            manifestCacheFile.delete();
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, Object[]> loadManifestCache(File manifestCacheFile) {
        HashMap<File, Object[]> hashMap;
        if (!manifestCacheFile.canRead()) {
            Util.err.fine("No manifest cache found at " + manifestCacheFile);
            return new HashMap<File, Object[]>(200);
        }
        this.ev.log("perfStart", new Object[]{"NbInstaller - loadManifestCache"});
        FileInputStream is = new FileInputStream(manifestCacheFile);
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            HashMap<File, Object[]> m = new HashMap<File, Object[]>(200);
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)manifestCacheFile.length());
            FileUtil.copy((InputStream)bis, (OutputStream)baos);
            byte[] data = baos.toByteArray();
            NbInstaller.readManifestCacheEntries(data, m);
            hashMap = m;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                this.ev.log("perfEnd", new Object[]{"NbInstaller - loadManifestCache"});
                throw throwable;
            }
            catch (IOException ioe) {
                Util.err.log(Level.WARNING, "While reading: " + manifestCacheFile, ioe);
                return new HashMap<File, Object[]>(200);
            }
        }
        ((InputStream)is).close();
        this.ev.log("perfEnd", new Object[]{"NbInstaller - loadManifestCache"});
        return hashMap;
    }

    private static int findNullByte(byte[] data, int start) {
        int len = data.length;
        for (int i = start; i < len; ++i) {
            if (data[i] != 0) continue;
            return i;
        }
        return -1;
    }

    private static void readManifestCacheEntries(byte[] data, Map<File, Object[]> m) throws IOException {
        int pos = 0;
        while (pos != data.length) {
            Manifest mani;
            int end = NbInstaller.findNullByte(data, pos);
            if (end == -1) {
                throw new IOException("Could not find next manifest JAR name from " + pos);
            }
            File jar = new File(new String(data, pos, end - pos, "UTF-8"));
            long time = 0L;
            if (end + 8 >= data.length) {
                throw new IOException("Ran out of space for timestamp for " + jar);
            }
            for (int i = 0; i < 8; ++i) {
                long b = data[end + i + 1];
                if (b < 0L) {
                    b += 256L;
                }
                int exponent = 7 - i;
                long addin = b << exponent * 8;
                time |= addin;
            }
            pos = end + 9;
            if ((end = NbInstaller.findNullByte(data, pos)) == -1) {
                throw new IOException("Could not find manifest body for " + jar);
            }
            try {
                mani = new Manifest(new ByteArrayInputStream(data, pos, end - pos));
            }
            catch (IOException ioe) {
                Exceptions.attachMessage((Throwable)ioe, (String)("While in entry for " + jar));
                throw ioe;
            }
            m.put(jar, new Object[]{new Date(time), mani});
            if (Util.err.isLoggable(Level.FINE)) {
                Util.err.fine("Manifest cache entry: jar=" + jar + " date=" + new Date(time) + " codename=" + mani.getMainAttributes().getValue("OpenIDE-Module"));
            }
            pos = end + 1;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preresolveClasses(List<Module> modules) {
        Util.err.info("Pre-resolving classes for all loaded modules...be sure you have not specified -J-Xverify:none in ide.cfg");
        for (Module m : modules) {
            if (m.isFixed() || m.getJarFile() == null) continue;
            File jar = m.getJarFile();
            try {
                JarFile j = new JarFile(jar, true);
                try {
                    for (JarEntry entry : NbCollections.iterable(j.entries())) {
                        String name = entry.getName();
                        if (!name.endsWith(".class")) continue;
                        String clazz = name.substring(0, name.length() - 6).replace('/', '.');
                        Throwable t = null;
                        try {
                            Class.forName(clazz, false, m.getClassLoader());
                        }
                        catch (ClassNotFoundException cnfe) {
                            t = cnfe;
                        }
                        catch (LinkageError le) {
                            t = le;
                        }
                        catch (RuntimeException re) {
                            t = re;
                        }
                        if (t == null) continue;
                        Util.err.log(Level.WARNING, "From " + clazz + " in " + m.getCodeNameBase() + " with effective classpath " + this.getEffectiveClasspath(m), t);
                    }
                }
                finally {
                    j.close();
                }
            }
            catch (IOException ioe) {
                Util.err.log(Level.WARNING, null, ioe);
            }
        }
    }

    static {
        CLASSPATH_JARS = new String[][]{{"core", "org/netbeans/core/", "org/netbeans/beaninfo/"}, {"boot"}};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Convertor
    implements InstanceContent.Convertor<ManifestSection, Object> {
        Convertor() {
        }

        public Object convert(ManifestSection s) {
            try {
                return s.getInstance();
            }
            catch (Exception e) {
                Util.err.log(Level.WARNING, null, e);
                NbInstaller.this.loadGenericSection(s, false);
                return null;
            }
        }

        public Class<?> type(ManifestSection s) {
            return s.getSuperclass();
        }

        public String id(ManifestSection obj) {
            return obj.toString();
        }

        public String displayName(ManifestSection obj) {
            return obj.toString();
        }
    }
}

