/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.IOException;
import java.text.Collator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NbProblemDisplayer {
    private NbProblemDisplayer() {
    }

    public static String messageForProblem(Module m, Object problem) {
        if (problem instanceof InvalidException) {
            return Util.findLocalizedMessage((Throwable)((InvalidException)((Object)problem)), (boolean)true);
        }
        Dependency dep = (Dependency)problem;
        switch (dep.getType()) {
            case 1: {
                Module other;
                String polite = (String)m.getLocalizedAttribute("OpenIDE-Module-Module-Dependency-Message");
                if (polite != null) {
                    return polite;
                }
                String name = dep.getName();
                int idx = name.lastIndexOf(47);
                if (idx != -1) {
                    name = name.substring(0, idx);
                }
                if ((other = m.getManager().get(name)) != null && other.getCodeName().equals(dep.getName())) {
                    switch (dep.getComparison()) {
                        case 3: {
                            return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_disabled", (Object)other.getDisplayName());
                        }
                        case 2: {
                            String actualI;
                            String requestedI = dep.getVersion();
                            String string = actualI = other.getImplementationVersion() != null ? other.getImplementationVersion() : NbBundle.getMessage(NbProblemDisplayer.class, (String)"LBL_no_impl_version");
                            if (requestedI.equals(actualI)) {
                                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_disabled", (Object)other.getDisplayName());
                            }
                            return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_wrong_version", (Object)other.getDisplayName(), (Object)requestedI, (Object)actualI);
                        }
                        case 1: {
                            SpecificationVersion actualS;
                            SpecificationVersion requestedS = new SpecificationVersion(dep.getVersion());
                            SpecificationVersion specificationVersion = actualS = other.getSpecificationVersion() != null ? other.getSpecificationVersion() : new SpecificationVersion("0");
                            if (actualS.compareTo((Object)requestedS) >= 0) {
                                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_disabled", (Object)other.getDisplayName());
                            }
                            return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_too_old", (Object)other.getDisplayName(), (Object)requestedS, (Object)actualS);
                        }
                    }
                    throw new IllegalStateException();
                }
                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_needed_not_found", (Object)dep.getName());
            }
            case 5: 
            case 6: {
                String polite = (String)m.getLocalizedAttribute("OpenIDE-Module-Requires-Message");
                if (polite != null) {
                    return polite;
                }
                Set others = m.getManager().getModules();
                for (Module other : others) {
                    if (!other.provides(dep.getName())) continue;
                    return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_require_disabled", (Object)dep.getName());
                }
                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_require_not_found", (Object)dep.getName());
            }
            case 2: {
                String polite = (String)m.getLocalizedAttribute("OpenIDE-Module-Package-Dependency-Message");
                if (polite != null) {
                    return polite;
                }
                String name = dep.getName();
                int idx = name.lastIndexOf(91);
                if (idx == 0) {
                    return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_class_not_loaded", (Object)name.substring(1, name.length() - 1));
                }
                if (idx != -1) {
                    return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_package_not_loaded_or_old", (Object)name.substring(0, idx));
                }
                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_package_not_loaded_or_old", (Object)name);
            }
            case 3: {
                if (dep.getName().equals("Java") && dep.getComparison() == 1) {
                    return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_java_too_old", (Object)dep.getVersion(), (Object)Dependency.JAVA_SPEC);
                }
                return dep.toString();
            }
        }
        throw new IllegalArgumentException(dep.toString());
    }

    static void problemMessagesForModules(Appendable writeTo, Set<? extends Module> modules, boolean justRootCause) {
        try {
            HashSet<String> names = new HashSet<String>();
            for (Module module : modules) {
                names.add(module.getCodeName());
            }
            HashSet<String> dependantModules = new HashSet<String>();
            for (Module module : modules) {
                TreeSet<Object> problemTexts = new TreeSet<Object>(Collator.getInstance());
                Iterator pit = module.getProblems().iterator();
                if (pit.hasNext()) {
                    while (pit.hasNext()) {
                        Dependency dependency;
                        Object problem = pit.next();
                        if (problem instanceof Dependency && justRootCause && (dependency = (Dependency)problem).getType() == 1 && names.contains(dependency.getName())) {
                            dependantModules.add(module.getCodeName());
                            continue;
                        }
                        problemTexts.add(module.getDisplayName() + " - " + NbProblemDisplayer.messageForProblem(module, problem));
                    }
                } else {
                    throw new IllegalStateException("Module " + module + " could not be installed but had no problems");
                }
                for (String string : problemTexts) {
                    writeTo.append("\n\t").append(string);
                }
            }
            if (!dependantModules.isEmpty()) {
                writeTo.append("\n\t").append(NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_also_dep_modules", (Object)dependantModules.size()));
            }
        }
        catch (IOException ex) {
            throw (IllegalStateException)new IllegalStateException().initCause(ex);
        }
    }
}

