/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

final class NbURLStreamHandlerFactory
implements URLStreamHandlerFactory,
LookupListener {
    private static Logger LOG = Logger.getLogger(NbURLStreamHandlerFactory.class.getName());
    private Lookup.Result<URLStreamHandlerFactory> r = null;
    private URLStreamHandlerFactory[] handlers = null;
    private URLStreamHandlerFactory delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandlerFactory[] _handlers;
        URLStreamHandler h;
        if (protocol.equals("jar") || protocol.equals("file") || protocol.equals("http") || protocol.equals("resource")) {
            return null;
        }
        if (protocol.equals("nbfs")) {
            return FileUtil.nbfsURLStreamHandler();
        }
        if (protocol.equals("nbres") || protocol.equals("nbresloc")) {
            return new NbResourceStreamHandler();
        }
        URLStreamHandlerFactory d = this.delegate;
        if (d != null && (h = d.createURLStreamHandler(protocol)) != null) {
            return h;
        }
        NbURLStreamHandlerFactory nbURLStreamHandlerFactory = this;
        synchronized (nbURLStreamHandlerFactory) {
            if (this.r == null) {
                this.r = Lookup.getDefault().lookupResult(URLStreamHandlerFactory.class);
                this.r.addLookupListener((LookupListener)this);
                this.resultChanged(null);
            }
            _handlers = this.handlers;
        }
        if (_handlers == null) {
            return null;
        }
        for (int i = 0; i < _handlers.length; ++i) {
            URLStreamHandler h2 = _handlers[i].createURLStreamHandler(protocol);
            if (h2 == null) continue;
            return h2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent ev) {
        Collection c = this.r.allInstances();
        NbURLStreamHandlerFactory nbURLStreamHandlerFactory = this;
        synchronized (nbURLStreamHandlerFactory) {
            this.handlers = c.toArray(new URLStreamHandlerFactory[0]);
        }
    }

    void registerUsingReflection(Error e) {
        LOG.log(Level.CONFIG, "Problems registering URLStreamHandlerFactory, trying reflection", e);
        try {
            URLStreamHandlerFactory prev = null;
            for (Field f : URL.class.getDeclaredFields()) {
                LOG.log(Level.FINEST, "Found field {0}", f);
                if (f.getType() != URLStreamHandlerFactory.class) continue;
                LOG.log(Level.FINEST, "Clearing field {0}");
                f.setAccessible(true);
                prev = (URLStreamHandlerFactory)f.get(null);
                LOG.log(Level.CONFIG, "Previous value was {0}", prev);
                f.set(null, null);
                LOG.config("Field is supposed to be empty");
                break;
            }
            URL.setURLStreamHandlerFactory(this);
            this.delegate = prev;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "No way to register URLStreamHandlerFactory; NetBeans is unlikely to work", t);
        }
    }

    private static final class NbResourceStreamHandler
    extends URLStreamHandler {
        public static final String PROTOCOL_SYSTEM_RESOURCE = "nbres";
        public static final String PROTOCOL_LOCALIZED_SYSTEM_RESOURCE = "nbresloc";

        public URLConnection openConnection(URL u) throws IOException {
            if (u.getProtocol().equals(PROTOCOL_SYSTEM_RESOURCE)) {
                return new Connection(u, false);
            }
            if (u.getProtocol().equals(PROTOCOL_LOCALIZED_SYSTEM_RESOURCE)) {
                return new Connection(u, true);
            }
            throw new IOException("Bad protocol: " + u.getProtocol());
        }

        private static class Connection
        extends URLConnection {
            private final boolean localized;
            private URLConnection real;
            private IOException exception = null;

            public Connection(URL u, boolean localized) {
                super(u);
                this.localized = localized;
            }

            public synchronized void connect() throws IOException {
                if (this.exception != null) {
                    IOException e = this.exception;
                    this.exception = null;
                    throw e;
                }
                if (!this.connected) {
                    URL target;
                    String resource = this.url.getPath();
                    if (resource.length() > 0 && resource.charAt(0) == '/') {
                        resource = resource.substring(1);
                    }
                    ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    URL t1 = loader.getResource(resource);
                    if (this.localized) {
                        String suffix;
                        String ext;
                        String base;
                        int dotIndex = resource.lastIndexOf(46);
                        if (dotIndex < resource.lastIndexOf(47)) {
                            dotIndex = -1;
                        }
                        if (dotIndex != -1) {
                            base = resource.substring(0, dotIndex);
                            ext = resource.substring(dotIndex);
                        } else {
                            base = resource;
                            ext = "";
                        }
                        target = null;
                        Iterator suffixes = NbBundle.getLocalizingSuffixes();
                        while (suffixes.hasNext() && (target = "".equals(suffix = (String)suffixes.next()) ? t1 : loader.getResource(base + suffix + ext)) == null) {
                        }
                    } else {
                        target = t1;
                    }
                    if (target == null) {
                        throw new IOException(NbBundle.getMessage(NbURLStreamHandlerFactory.class, (String)"EXC_nbres_cannot_connect", (Object)this.url));
                    }
                    this.real = target.openConnection();
                    this.real.connect();
                    this.connected = true;
                }
            }

            private void tryToConnect() {
                if (this.connected || this.exception != null) {
                    return;
                }
                try {
                    this.connect();
                }
                catch (IOException ioe) {
                    this.exception = ioe;
                }
            }

            public String getHeaderField(int n) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderField(n);
                }
                return null;
            }

            public String getHeaderFieldKey(int n) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderFieldKey(n);
                }
                return null;
            }

            public String getHeaderField(String key) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderField(key);
                }
                return null;
            }

            public InputStream getInputStream() throws IOException {
                this.connect();
                return this.real.getInputStream();
            }

            public OutputStream getOutputStream() throws IOException {
                this.connect();
                return this.real.getOutputStream();
            }

            public String getContentType() {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getContentType();
                }
                return "application/octet-stream";
            }

            public int getContentLength() {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getContentLength();
                }
                return 0;
            }
        }
    }
}

