/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.core.startup.DOMFactoryImpl;
import org.netbeans.core.startup.LazyIterator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXFactoryImpl
extends SAXParserFactory {
    private static Class first;
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    private static final String SAXParserFactory_PROP = "javax.xml.parsers.SAXParserFactory";

    public static void install() {
        System.getProperties().put(SAXParserFactory_PROP, SAXFactoryImpl.class.getName());
    }

    public boolean getFeature(String name) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.features.get(name);
    }

    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        SAXParser parser = this.tryCreate();
        return parser;
    }

    public void setFeature(String name, boolean value) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.features.put(name, value);
        this.tryCreate();
    }

    private SAXParser tryCreate() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        LazyIterator it = new LazyIterator(first, SAXParserFactory.class, SAXFactoryImpl.class);
        while (it.hasNext()) {
            try {
                SAXParser parser = this.tryCreate((Class)it.next());
                return parser;
            }
            catch (ParserConfigurationException e) {
                if (it.hasNext()) continue;
                throw e;
            }
            catch (SAXNotRecognizedException e) {
                if (it.hasNext()) continue;
                throw e;
            }
            catch (SAXNotSupportedException e) {
                if (it.hasNext()) continue;
                throw e;
            }
            catch (SAXException e) {
                if (it.hasNext()) continue;
                throw new ParserConfigurationException();
            }
        }
        throw new IllegalStateException("Can't get here!");
    }

    private SAXParser tryCreate(Class delClass) throws ParserConfigurationException, SAXException {
        ReflectiveOperationException ex = null;
        try {
            SAXParserFactory delegate = (SAXParserFactory)delClass.newInstance();
            delegate.setValidating(this.isValidating());
            delegate.setNamespaceAware(this.isNamespaceAware());
            for (Map.Entry<String, Boolean> entry : this.features.entrySet()) {
                delegate.setFeature(entry.getKey(), entry.getValue());
            }
            return delegate.newSAXParser();
        }
        catch (InstantiationException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        throw (ParserConfigurationException)new ParserConfigurationException("Broken factory").initCause(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader().getParent());
            first = SAXParserFactory.newInstance().getClass();
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
        DOMFactoryImpl.install();
        SAXFactoryImpl.install();
    }
}

