/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.Util;
import org.netbeans.core.startup.CLIOptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class Splash {
    private static Splash splash;
    private static boolean noBar;
    private static final String ICON_SMALL = "org/netbeans/core/startup/frame.gif";
    private static final String ICON_BIG = "org/netbeans/core/startup/frame32.gif";
    private Frame frame;
    private SplashComponent comp = new SplashComponent(false);

    public static Splash getInstance() {
        if (splash == null) {
            splash = new Splash();
        }
        return splash;
    }

    public static void showAboutDialog(Frame parent, JComponent info) {
        Splash.createAboutDialog(parent, info).setVisible(true);
    }

    private static JDialog createAboutDialog(Frame parent, JComponent info) {
        SplashDialog splashDialog = new SplashDialog(parent, info);
        return splashDialog;
    }

    private static Image createIDEImage() {
        return Utilities.loadImage((String)(Utilities.isLargeFrameIcons() ? ICON_BIG : ICON_SMALL), (boolean)true);
    }

    private Splash() {
    }

    public void setRunning(boolean running) {
        if (CLIOptions.isNoSplash()) {
            return;
        }
        if (running) {
            if (this.frame == null) {
                this.frame = new Frame(NbBundle.getMessage(Splash.class, (String)"LBL_splash_window_title"));
                this.frame.setIconImage(Splash.createIDEImage());
                this.frame.setUndecorated(true);
                this.frame.setLayout(new BorderLayout());
                this.frame.add((Component)this.comp, "Center");
                int width = Integer.parseInt(NbBundle.getMessage(Splash.class, (String)"SPLASH_WIDTH"));
                int height = Integer.parseInt(NbBundle.getMessage(Splash.class, (String)"SPLASH_HEIGHT"));
                this.frame.setPreferredSize(new Dimension(width, height));
                SwingUtilities.invokeLater(new SplashRunner(this.frame, true));
            }
        } else {
            SwingUtilities.invokeLater(new SplashRunner(this.frame, false));
        }
    }

    public void dispose() {
        this.setRunning(false);
        splash = null;
    }

    public void increment(int steps) {
        if (noBar || CLIOptions.isNoSplash()) {
            return;
        }
        if (this.comp != null) {
            this.comp.increment(steps);
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    public void print(String s) {
        if (CLIOptions.isNoSplash() || this.comp == null) {
            return;
        }
        this.comp.setText(s);
    }

    public void addToMaxSteps(int steps) {
        if (noBar || CLIOptions.isNoSplash()) {
            return;
        }
        if (this.comp != null) {
            this.comp.addToMaxSteps(steps);
        }
    }

    static final void center(Window c) {
        c.pack();
        c.setBounds(Utilities.findCenterBounds((Dimension)c.getSize()));
    }

    private static Image loadContent(boolean about) {
        Image img;
        if (about && (img = Utilities.loadImage((String)"org/netbeans/core/startup/about.gif", (boolean)true)) != null) {
            return img;
        }
        return Utilities.loadImage((String)"org/netbeans/core/startup/splash.gif", (boolean)true);
    }

    static {
        noBar = Boolean.getBoolean("netbeans.splash.nobar");
        ResourceBundle bundle = NbBundle.getBundle(Splash.class);
        noBar |= !Boolean.parseBoolean(bundle.getString("SplashShowProgressBar"));
    }

    private static class SplashComponent
    extends JComponent
    implements Accessible {
        Rectangle view;
        Color color_text;
        Color color_bar;
        Color color_edge;
        Color color_corner;
        private int size = 12;
        private Rectangle dirty = new Rectangle();
        private Rectangle rect = new Rectangle();
        private Rectangle bar = new Rectangle();
        private Rectangle bar_inc = new Rectangle();
        private int progress = 0;
        private int maxSteps = 140;
        private int tmpSteps = 0;
        private int barStart = 0;
        private int barLength = 0;
        private Image image;
        private String text;
        private FontMetrics fm;

        public SplashComponent(boolean about) {
            ResourceBundle bundle = NbBundle.getBundle(Splash.class);
            StringTokenizer st = new StringTokenizer(bundle.getString("SplashRunningTextBounds"), " ,");
            this.view = new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
            st = new StringTokenizer(bundle.getString("SplashProgressBarBounds"), " ,");
            try {
                this.bar = new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                Integer rgb = Integer.decode(bundle.getString("SplashRunningTextColor"));
                this.color_text = new Color(rgb);
                rgb = Integer.decode(bundle.getString("SplashProgressBarColor"));
                this.color_bar = new Color(rgb);
                rgb = Integer.decode(bundle.getString("SplashProgressBarEdgeColor"));
                this.color_edge = new Color(rgb);
                rgb = Integer.decode(bundle.getString("SplashProgressBarCornerColor"));
                this.color_corner = new Color(rgb);
            }
            catch (NumberFormatException nfe) {
                Util.err.warning("Number format exception loading splash screen parameters.");
                Logger.getLogger("global").log(Level.WARNING, null, nfe);
                this.color_text = Color.BLACK;
                this.color_bar = Color.ORANGE;
                this.color_edge = Color.BLUE;
                this.color_corner = Color.GREEN;
                this.bar = new Rectangle(0, 0, 80, 10);
            }
            try {
                String sizeStr = bundle.getString("SplashRunningTextFontSize");
                this.size = Integer.parseInt(sizeStr);
            }
            catch (MissingResourceException e) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.image = Splash.loadContent(about);
            Font font = new Font("Dialog", 0, this.size);
            this.setFont(font);
            this.fm = this.getFontMetrics(font);
        }

        public void setText(final String text) {
            if (text != null && text.equals(this.text)) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (text == null) {
                        SplashComponent.this.repaint(SplashComponent.this.dirty);
                        return;
                    }
                    if (SplashComponent.this.fm == null) {
                        return;
                    }
                    SplashComponent.this.adjustText(text);
                    SwingUtilities.layoutCompoundLabel(SplashComponent.this.fm, text, null, 3, 2, 3, 2, SplashComponent.this.view, new Rectangle(), SplashComponent.this.rect, 0);
                    SplashComponent.this.dirty = SplashComponent.this.dirty.union(SplashComponent.this.rect);
                    SplashComponent.this.repaint(SplashComponent.this.dirty);
                    SplashComponent.this.dirty = new Rectangle(SplashComponent.this.rect);
                }
            });
        }

        private void adjustText(String text) {
            String newText = null;
            if (text == null) {
                return;
            }
            if (this.fm == null) {
                return;
            }
            int width = this.fm.stringWidth(text);
            if (width > this.view.width) {
                String newString;
                StringTokenizer st = new StringTokenizer(text);
                while (st.hasMoreTokens()) {
                    String element = st.nextToken();
                    newString = newText == null ? element : newText + " " + element;
                    if (this.fm.stringWidth(newString + "...") > this.view.width) {
                        this.text = newText + "...";
                        break;
                    }
                    newText = newString;
                }
                if (newText == null) {
                    this.text = "";
                    newString = "";
                    newText = "";
                    for (int i = 0; i < text.length(); ++i) {
                        if (this.fm.stringWidth((newString = newString + text.charAt(i)) + "...") > this.view.width) {
                            this.text = newText + "...";
                            break;
                        }
                        newText = newString;
                    }
                }
            } else {
                this.text = text;
            }
        }

        public void increment(int steps) {
            int bl;
            this.progress += steps;
            if (this.progress > this.maxSteps) {
                this.progress = this.maxSteps;
            } else if (this.maxSteps > 0 && ((bl = this.bar.width * this.progress / this.maxSteps - this.barStart) > 1 || this.barStart % 2 == 0)) {
                this.barLength = bl;
                this.bar_inc = new Rectangle(this.bar.x + this.barStart, this.bar.y, this.barLength + 1, this.bar.height);
                this.repaint(this.bar_inc);
            }
        }

        private void addToMaxSteps(int steps) {
            int max = this.maxSteps + steps;
            int prog = this.progress / this.maxSteps * max;
            this.maxSteps = max;
            this.progress = prog;
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.color_text);
            graphics.drawImage(this.image, 0, 0, null);
            if (this.text != null) {
                if (this.fm == null) {
                    return;
                }
                SwingUtilities.layoutCompoundLabel(this.fm, this.text, null, 3, 2, 3, 2, this.view, new Rectangle(), this.rect, 0);
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics.drawString(this.text, this.rect.x, this.rect.y + this.fm.getAscent());
            }
            if (!noBar && this.maxSteps > 0) {
                graphics.setColor(this.color_bar);
                graphics.fillRect(this.bar.x, this.bar.y, this.barStart + this.barLength, this.bar.height);
                graphics.setColor(this.color_corner);
                graphics.drawLine(this.bar.x, this.bar.y, this.bar.x, this.bar.y + this.bar.height);
                graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height);
                graphics.setColor(this.color_edge);
                graphics.drawLine(this.bar.x, this.bar.y + this.bar.height / 2, this.bar.x, this.bar.y + this.bar.height / 2);
                graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2);
                this.barStart += this.barLength;
                this.barLength = 0;
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
        }

        public boolean isOpaque() {
            return true;
        }

        public String toString() {
            return "SplashComponent - progress: " + this.progress + "/" + this.maxSteps + " text: " + this.text;
        }
    }

    private static class SplashDialog
    extends JDialog
    implements ActionListener {
        static final long serialVersionUID = 5185644855500178404L;
        private final SplashComponent splashComponent = new SplashComponent(true);

        public SplashDialog(Frame parent, JComponent infoPanel) {
            super(parent, true);
            JPanel splashPanel = new JPanel();
            JTabbedPane tabbedPane = new JTabbedPane();
            this.setTitle(NbBundle.getMessage(Splash.class, (String)"CTL_About_Title"));
            splashPanel.add(this.splashComponent);
            tabbedPane.addTab(NbBundle.getMessage(Splash.class, (String)"CTL_About_Title"), splashPanel);
            tabbedPane.addTab(NbBundle.getMessage(Splash.class, (String)"CTL_About_Detail"), infoPanel);
            this.getContentPane().add((Component)tabbedPane, "Center");
            this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 1);
            tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Splash.class, (String)"ACSN_AboutTabs"));
            tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Splash.class, (String)"ACSD_AboutTabs"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Splash.class, (String)"ACSD_AboutDialog"));
            Splash.center(this);
            this.setDefaultCloseOperation(2);
        }

        public void actionPerformed(ActionEvent e) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class SplashRunner
    implements Runnable {
        private Window splashWindow;
        private boolean visible;

        public SplashRunner(Window splashWindow, boolean visible) {
            this.splashWindow = splashWindow;
            this.visible = visible;
        }

        public void run() {
            if (this.visible) {
                Splash.center(this.splashWindow);
                this.splashWindow.setVisible(true);
                this.splashWindow.toFront();
            } else {
                this.splashWindow.setVisible(false);
                this.splashWindow.dispose();
            }
        }
    }
}

