/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.Union2;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.NbObjectInputStream;

public class BinaryFS
extends FileSystem {
    static final byte[] MAGIC = "org.netbeans.core.projects.cache.BinaryV3".getBytes();
    static final SystemAction[] NO_ACTIONS = new SystemAction[0];
    static final FileObject[] NO_CHILDREN = new FileObject[0];
    String binaryFile;
    ByteBuffer content;
    private FileObject root;
    private List<Union2<String, Long>> modifications;
    private final Date lastModified = new Date();

    private void _setSystemName(String s) throws PropertyVetoException {
        this.setSystemName(s);
    }

    public BinaryFS(String binaryFile) throws IOException {
        try {
            this._setSystemName("BinaryFS" + binaryFile.replace('/', '-').replace(File.separatorChar, '-'));
        }
        catch (PropertyVetoException ex) {
            throw (IOException)new IOException().initCause(ex);
        }
        this.binaryFile = binaryFile;
        RandomAccessFile file = new RandomAccessFile(binaryFile, "r");
        long len = file.length();
        MappedByteBuffer buff = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, len);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        file.close();
        byte[] magic = new byte[MAGIC.length];
        buff.get(magic);
        if (!Arrays.equals(magic, MAGIC)) {
            throw new IOException("Bad magic header: " + new String(magic));
        }
        long storedLen = buff.getInt();
        if (len != storedLen) {
            throw new IOException("Corrupted image, correct length=" + storedLen);
        }
        int stop = buff.getInt() + 8 + MAGIC.length;
        this.modifications = new ArrayList<Union2<String, Long>>();
        while (buff.position() < stop) {
            this.modifications.add((Union2<String, Long>)Union2.createFirst((Object)BinaryFS.getString(buff)));
        }
        this.content = buff.slice().order(ByteOrder.LITTLE_ENDIAN);
        this.root = new BFSFolder("", null, 0);
    }

    public FileObject findResource(String name) {
        String next;
        FileObject fo;
        if (name.length() == 0) {
            return this.root;
        }
        StringTokenizer st = new StringTokenizer(name, "/");
        for (fo = this.root; fo != null && st.hasMoreTokens(); fo = fo.getFileObject(next, null)) {
            next = st.nextToken();
        }
        return fo;
    }

    public SystemAction[] getActions() {
        return NO_ACTIONS;
    }

    public String getDisplayName() {
        return "BinaryFS[" + this.binaryFile + "]";
    }

    public FileObject getRoot() {
        return this.root;
    }

    public boolean isReadOnly() {
        return true;
    }

    static String getString(ByteBuffer buffer) throws IOException {
        int len = buffer.getInt();
        byte[] arr = new byte[len];
        buffer.get(arr);
        return new String(arr, "UTF-8");
    }

    static final Map wrapToMap(FileObject fo) {
        return fo == null ? Collections.emptyMap() : new FileMap(fo);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AttrFileSet
    extends AbstractSet<Map.Entry<String, Object>> {
        private FileObject fo;

        private AttrFileSet(FileObject fo) {
            this.fo = fo;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Iter
            implements Iterator<Map.Entry<String, Object>> {
                Enumeration<String> attrs;

                Iter() {
                    this.attrs = AttrFileSet.this.fo.getAttributes();
                }

                @Override
                public boolean hasNext() {
                    return this.attrs.hasMoreElements();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    String s = this.attrs.nextElement();
                    return new FOEntry(AttrFileSet.this.fo, s);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new Iter();
        }

        @Override
        public int size() {
            Enumeration all = this.fo.getAttributes();
            int cnt = 0;
            while (all.hasMoreElements()) {
                ++cnt;
                all.nextElement();
            }
            return cnt;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    static final class AttrImpl {
        private int index;
        private String value;

        AttrImpl(int type, String textValue) {
            this.index = type;
            this.value = textValue;
        }

        public boolean equals(Object o) {
            if (o instanceof AttrImpl) {
                AttrImpl impl = (AttrImpl)o;
                return this.index == impl.index && this.value.equals(impl.value);
            }
            return false;
        }

        public int hashCode() {
            return 2343 + this.index + this.value.hashCode();
        }

        public Object getValue(BFSBase foProvider, String attrName) {
            try {
                switch (this.index) {
                    case 0: {
                        return Byte.valueOf(this.value);
                    }
                    case 1: {
                        return Short.valueOf(this.value);
                    }
                    case 2: {
                        return Integer.valueOf(this.value);
                    }
                    case 3: {
                        return Long.valueOf(this.value);
                    }
                    case 4: {
                        return Float.valueOf(this.value);
                    }
                    case 5: {
                        return Double.valueOf(this.value);
                    }
                    case 6: {
                        return Boolean.valueOf(this.value);
                    }
                    case 7: {
                        if (this.value.trim().length() != 1) break;
                        return new Character(this.value.charAt(0));
                    }
                    case 8: {
                        return this.value;
                    }
                    case 9: {
                        return new URL(this.value);
                    }
                    case 10: {
                        return this.methodValue(this.value, foProvider, attrName);
                    }
                    case 11: {
                        Class cls = this.findClass(this.value);
                        if (SharedClassObject.class.isAssignableFrom(cls)) {
                            return SharedClassObject.findObject(cls.asSubclass(SharedClassObject.class), (boolean)true);
                        }
                        return cls.newInstance();
                    }
                    case 12: {
                        return this.decodeValue(this.value);
                    }
                    default: {
                        throw new IllegalStateException("Bad index: " + this.index);
                    }
                }
            }
            catch (Exception exc) {
                Exceptions.attachLocalizedMessage((Throwable)exc, (String)("value = " + this.value));
                Logger.getLogger(BinaryFS.class.getName()).log(Level.WARNING, null, exc);
            }
            return null;
        }

        private Object methodValue(String method, BFSBase foProvider, String attr) throws Exception {
            int i = method.lastIndexOf(46);
            if (i != -1) {
                String methodName = this.value.substring(i + 1);
                String className = this.value.substring(0, i);
                Class cls = this.findClass(className);
                Object[][] objArray = new Object[][]{null, null, null};
                Method[] methArray = new Method[]{null, null, null};
                FileObject fo = null;
                Method[] allMethods = cls.getDeclaredMethods();
                for (int j = 0; j < allMethods.length; ++j) {
                    if (!allMethods[j].getName().equals(methodName)) continue;
                    Class<?>[] paramClss = allMethods[j].getParameterTypes();
                    if (paramClss.length == 0) {
                        if (methArray[0] != null) continue;
                        methArray[0] = allMethods[j];
                        objArray[0] = new Object[0];
                        continue;
                    }
                    if (paramClss.length == 2 && methArray[2] == null) {
                        if (paramClss[0].isAssignableFrom(FileObject.class) && paramClss[1].isAssignableFrom(String.class)) {
                            methArray[2] = allMethods[j];
                            if (fo == null) {
                                fo = foProvider.getFileObjectForAttr();
                            }
                            objArray[2] = new Object[]{fo, attr};
                            break;
                        }
                        if (paramClss[0].isAssignableFrom(Map.class) && paramClss[1].isAssignableFrom(String.class)) {
                            methArray[2] = allMethods[j];
                            if (fo == null) {
                                fo = foProvider.getFileObjectForAttr();
                            }
                            objArray[2] = new Object[]{BinaryFS.wrapToMap(fo), attr};
                        }
                        if (!paramClss[0].isAssignableFrom(String.class) || !paramClss[1].isAssignableFrom(FileObject.class)) continue;
                        methArray[2] = allMethods[j];
                        if (fo == null) {
                            fo = foProvider.getFileObjectForAttr();
                        }
                        objArray[2] = new Object[]{attr, fo};
                        break;
                    }
                    if (paramClss.length != 1 || methArray[1] != null) continue;
                    if (paramClss[0].isAssignableFrom(FileObject.class)) {
                        methArray[1] = allMethods[j];
                        if (fo == null) {
                            fo = foProvider.getFileObjectForAttr();
                        }
                        objArray[1] = new Object[]{fo};
                        continue;
                    }
                    if (paramClss[0].isAssignableFrom(Map.class)) {
                        methArray[2] = allMethods[j];
                        if (fo == null) {
                            fo = foProvider.getFileObjectForAttr();
                        }
                        objArray[2] = new Object[]{BinaryFS.wrapToMap(fo)};
                    }
                    if (!paramClss[0].isAssignableFrom(String.class)) continue;
                    methArray[1] = allMethods[j];
                    objArray[1] = new Object[]{attr};
                }
                for (int k = 2; k >= 0; --k) {
                    if (methArray[k] == null) continue;
                    methArray[k].setAccessible(true);
                    return methArray[k].invoke(null, objArray[k]);
                }
            }
            throw new InstantiationException(this.value);
        }

        private Object decodeValue(String value) throws Exception {
            if (value == null || value.length() == 0) {
                return null;
            }
            byte[] bytes = new byte[value.length() / 2];
            int count = 0;
            for (int i = 0; i < value.length(); i += 2) {
                int tempI = Integer.parseInt(value.substring(i, i + 2), 16);
                if (tempI > 127) {
                    tempI -= 256;
                }
                bytes[count++] = (byte)tempI;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
            return new NbObjectInputStream((InputStream)bis).readObject();
        }

        private Class findClass(String name) throws ClassNotFoundException {
            ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            String tname = Utilities.translate((String)name);
            try {
                if (c == null) {
                    return Class.forName(tname);
                }
                return Class.forName(tname, true, c);
            }
            catch (NoClassDefFoundError err) {
                throw new ClassNotFoundException("Cannot read " + name, err);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BFSBase
    extends FileObject {
        private final FileObject parent;
        protected final String name;
        protected final int offset;
        private boolean initialized = false;
        private Map<String, AttrImpl> attrs = Collections.emptyMap();

        public BFSBase(String name, FileObject parent, int offset) {
            this.name = name;
            this.parent = parent;
            this.offset = offset;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof BFSBase)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            BFSBase f = (BFSBase)((Object)o);
            return f.getPath().equals(this.getPath()) && this.specificEquals(f) && this.attributeEquals(f);
        }

        private final boolean attributeEquals(BFSBase base) {
            this.initialize();
            base.initialize();
            return ((Object)this.attrs).equals(base.attrs);
        }

        public final int hashCode() {
            return this.getPath().hashCode();
        }

        protected abstract boolean specificEquals(BFSBase var1);

        public void addFileChangeListener(FileChangeListener fcl) {
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
        }

        @Deprecated
        public boolean isReadOnly() {
            return true;
        }

        @Deprecated
        public void setImportant(boolean b) {
        }

        public FileObject createData(String name, String ext) throws IOException {
            throw new IOException();
        }

        public FileObject createFolder(String name) throws IOException {
            throw new IOException();
        }

        public void delete(FileLock lock) throws IOException {
            throw new IOException();
        }

        public OutputStream getOutputStream(FileLock lock) throws IOException {
            throw new IOException();
        }

        public FileLock lock() throws IOException {
            throw new IOException();
        }

        public void rename(FileLock lock, String name, String ext) throws IOException {
            throw new IOException();
        }

        public void setAttribute(String attrName, Object value) throws IOException {
            throw new IOException();
        }

        public FileSystem getFileSystem() {
            return BinaryFS.this;
        }

        public FileObject getParent() {
            return this.parent;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean isValid() {
            return true;
        }

        public Date lastModified() {
            return BinaryFS.this.lastModified;
        }

        public String getName() {
            int i = this.name.lastIndexOf(46);
            return i <= 0 ? this.name : this.name.substring(0, i);
        }

        public String getExt() {
            int i = this.name.lastIndexOf(46) + 1;
            return i <= 1 || i == this.name.length() ? "" : this.name.substring(i);
        }

        public String getNameExt() {
            return this.name;
        }

        public Object getAttribute(String attrName) {
            this.initialize();
            AttrImpl attr = this.attrs.get(attrName);
            return attr != null ? attr.getValue(this, attrName) : null;
        }

        public FileObject getFileObjectForAttr() {
            FileObject topFO = null;
            try {
                Class<?> mfoClass = Class.forName("org.openide.filesystems.MultiFileObject");
                Field field = mfoClass.getDeclaredField("attrAskedFileObject");
                field.setAccessible(true);
                ThreadLocal attrAskedFileObject = (ThreadLocal)ThreadLocal.class.cast(field.get(null));
                topFO = (FileObject)attrAskedFileObject.get();
                attrAskedFileObject.set(null);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            return topFO == null ? this : topFO;
        }

        public Enumeration<String> getAttributes() {
            this.initialize();
            if (this.attrs == null) {
                return Enumerations.empty();
            }
            return Collections.enumeration(this.attrs.keySet());
        }

        protected final void initialize() {
            if (this.initialized) {
                return;
            }
            try {
                ByteBuffer sub = (ByteBuffer)BinaryFS.this.content.duplicate().order(ByteOrder.LITTLE_ENDIAN).position(this.offset);
                int attrCount = sub.getInt();
                if (attrCount > 0) {
                    this.attrs = new HashMap<String, AttrImpl>(attrCount * 4 / 3 + 1);
                }
                for (int i = 0; i < attrCount; ++i) {
                    String name = BinaryFS.getString(sub).intern();
                    byte type = sub.get();
                    String value = BinaryFS.getString(sub).intern();
                    this.attrs.put(name, new AttrImpl(type, value));
                }
                this.doInitialize(sub);
            }
            catch (Exception e) {
                System.err.println("exception in initialize() on " + this.name + ": " + e);
            }
            this.initialized = true;
        }

        protected abstract void doInitialize(ByteBuffer var1) throws Exception;
    }

    final class BFSFile
    extends BFSBase {
        private int len;
        private int contentOffset;
        private String uri;
        private long lastModified;

        public BFSFile(String name, FileObject parent, int offset) {
            super(name, parent, offset);
            this.lastModified = -1L;
        }

        public FileObject[] getChildren() {
            return NO_CHILDREN;
        }

        public FileObject getFileObject(String name, String ext) {
            return null;
        }

        public boolean isData() {
            return true;
        }

        public boolean isFolder() {
            return false;
        }

        private byte[] data() throws IOException {
            if (this.len == -1) {
                throw new IllegalArgumentException();
            }
            byte[] data = new byte[this.len];
            ((ByteBuffer)BinaryFS.this.content.duplicate().position(this.contentOffset)).get(data);
            return data;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            this.initialize();
            try {
                return this.len == -1 ? new URL(this.uri).openConnection().getInputStream() : new ByteArrayInputStream(this.data());
            }
            catch (Exception e) {
                throw (FileNotFoundException)new FileNotFoundException(e.toString()).initCause(e);
            }
        }

        public long getSize() {
            this.initialize();
            try {
                return this.len == -1 ? (long)new URL(this.uri).openConnection().getContentLength() : (long)this.len;
            }
            catch (Exception e) {
                System.err.println("exception in getSize() on " + this.name + ": " + e);
                return 0L;
            }
        }

        protected void doInitialize(ByteBuffer sub) throws Exception {
            this.len = sub.getInt();
            this.contentOffset = sub.position();
            if (this.len == -1) {
                this.uri = BinaryFS.getString(sub);
            } else {
                sub.position(this.contentOffset + this.len);
            }
            int base = sub.getInt();
            this.lastModified = -10 - base;
        }

        protected boolean specificEquals(BFSBase _f) {
            if (!(_f instanceof BFSFile)) {
                return false;
            }
            BFSFile f = (BFSFile)_f;
            this.initialize();
            f.initialize();
            if (this.len == -1 && f.len == -1) {
                return this.uri.equals(f.uri);
            }
            if (this.len != -1 && f.len != -1) {
                byte[] fdata;
                byte[] data;
                try {
                    data = this.data();
                    fdata = f.data();
                }
                catch (IOException ioe) {
                    return false;
                }
                if (data.length != fdata.length) {
                    return false;
                }
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == fdata[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date lastModified() {
            this.initialize();
            List list = BinaryFS.this.modifications;
            synchronized (list) {
                if (this.lastModified >= 0L) {
                    return new Date(this.lastModified);
                }
                try {
                    long date;
                    int index = -1;
                    URLConnection conn = null;
                    if (this.len == -1) {
                        conn = new URL(this.uri).openConnection();
                    } else {
                        index = (int)(-this.lastModified) - 10;
                        Union2 obj = (Union2)BinaryFS.this.modifications.get(index);
                        if (obj.hasSecond()) {
                            return new Date((Long)obj.second());
                        }
                        conn = new URL((String)obj.first()).openConnection();
                    }
                    if (conn instanceof JarURLConnection) {
                        conn = ((JarURLConnection)conn).getJarFileURL().openConnection();
                    }
                    if (conn != null && (date = conn.getLastModified()) > 0L) {
                        this.lastModified = date;
                        if (index >= 0) {
                            BinaryFS.this.modifications.set(index, Union2.createSecond((Object)date));
                        }
                        return new Date(date);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(BinaryFS.class.getName()).log(Level.WARNING, null, e);
                }
            }
            return super.lastModified();
        }
    }

    private class BFSFolder
    extends BFSBase {
        Map<String, BFSBase> childrenMap;

        public BFSFolder(String name, FileObject parent, int offset) {
            super(name, parent, offset);
            this.childrenMap = Collections.emptyMap();
        }

        public boolean isData() {
            return false;
        }

        public boolean isFolder() {
            return true;
        }

        public long getSize() {
            return 0L;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            throw new FileNotFoundException("Is a directory: " + (Object)((Object)this));
        }

        public FileObject[] getChildren() {
            this.initialize();
            return this.childrenMap.values().toArray(NO_CHILDREN);
        }

        public FileObject getFileObject(String name, String ext) {
            this.initialize();
            String fullName = ext == null ? name : name + "." + ext;
            return this.childrenMap.get(fullName);
        }

        protected void doInitialize(ByteBuffer sub) throws Exception {
            int files = sub.getInt();
            if (files > 0) {
                this.childrenMap = new HashMap<String, BFSBase>(files * 4 / 3 + 1);
                for (int i = 0; i < files; ++i) {
                    String name = BinaryFS.getString(sub);
                    byte isFolder = sub.get();
                    int off = sub.getInt();
                    this.childrenMap.put(name, isFolder == 0 ? new BFSFile(name, this, off) : new BFSFolder(name, this, off));
                }
            }
        }

        protected boolean specificEquals(BFSBase _f) {
            if (!(_f instanceof BFSFolder)) {
                return false;
            }
            BFSFolder f = (BFSFolder)_f;
            this.initialize();
            return ((Object)this.childrenMap).equals(f.childrenMap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FOEntry
    implements Map.Entry<String, Object> {
        private FileObject fo;
        private String attr;

        private FOEntry(FileObject fo, String attr) {
            this.fo = fo;
            this.attr = attr;
        }

        @Override
        public String getKey() {
            return this.attr;
        }

        @Override
        public Object getValue() {
            return this.fo.getAttribute(this.attr);
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FileMap
    extends AbstractMap<String, Object> {
        private FileObject fo;

        private FileMap(FileObject fo) {
            this.fo = fo;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new AttrFileSet(this.fo);
        }

        public Object get(String key) {
            return this.fo.getAttribute(key);
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

