/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.List,
AbstractFileSystem.Change,
AbstractFileSystem.Attr,
AbstractFileSystem.Info {
    static FixedFileSystem deflt = null;
    private final Map<String, Instance> instances = new HashMap<String, Instance>();
    private String displayName;
    private transient long date = System.currentTimeMillis();
    private static final Instance autoFolder = new Instance(true, null, null, null, (String)null);

    public static FixedFileSystem getDefault() {
        return deflt;
    }

    private void _setSystemName(String s) throws PropertyVetoException {
        this.setSystemName(s);
    }

    public FixedFileSystem(String name, String displayName) {
        this.list = this;
        this.change = this;
        this.info = this;
        this.attr = this;
        try {
            this._setSystemName(name);
        }
        catch (PropertyVetoException pve) {
            throw new InternalError(pve.toString());
        }
        this.displayName = displayName;
    }

    public boolean isNonTrivial() {
        return !this.instances.isEmpty();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String path, Instance inst) {
        boolean nue;
        if (path.length() == 0) {
            return;
        }
        int idx = path.lastIndexOf(47);
        String folder = idx == -1 ? "" : path.substring(0, idx);
        this.add(folder, autoFolder);
        Map<String, Instance> map = this.instances;
        synchronized (map) {
            Instance old = this.instances.get(path);
            if (inst == old) {
                return;
            }
            boolean bl = nue = old == null;
            if (nue) {
                this.instances.put(path, inst);
            }
        }
        this.refreshResource(folder, false);
        if (!nue) {
            this.refreshResource(path, false);
        }
        this.date = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String path) {
        Map<String, Instance> map = this.instances;
        synchronized (map) {
            if (this.instances.remove(path) == null) {
                return;
            }
        }
        int idx = path.lastIndexOf(47);
        if (idx != -1) {
            this.refreshResource(path.substring(0, idx), false);
        } else {
            this.refreshResource("", false);
        }
    }

    public Instance get(String path) {
        return this.instances.get(path);
    }

    public void addDefault(String folder, String file) {
        Instance inst = this.instances.get(folder);
        if (inst == null) {
            inst = new Instance(true, null, null, null, (String)null);
            this.add(folder, inst);
        }
        String attrName = "OpenIDE-Folder-Order";
        String attrValue = null;
        Map<String, Object> attrs = inst.attributes;
        if (attrs != null) {
            attrValue = (String)attrs.get(attrName);
        }
        attrValue = attrValue == null ? file : attrValue + '/' + file;
        inst.writeAttribute(attrName, attrValue);
    }

    public String toString() {
        return "FixedFileSystem[" + this.getSystemName() + "]" + this.instances.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String annotateName(String resource) {
        Map<String, Instance> map = this.instances;
        synchronized (map) {
            Instance inst = this.instances.get(resource);
            return inst == null ? null : inst.displayName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Image annotateIcon(String resource) {
        Instance inst;
        Map<String, Instance> map = this.instances;
        synchronized (map) {
            inst = this.instances.get(resource);
        }
        if (inst == null) {
            return null;
        }
        if (inst.icon != null) {
            return Toolkit.getDefaultToolkit().getImage(inst.icon);
        }
        if (inst.beanName == null) {
            return null;
        }
        try {
            Class<?> clazz = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass(inst.beanName);
            return Utilities.getBeanInfo(clazz).getIcon(1);
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] children(String f) {
        Map<String, Instance> map = this.instances;
        synchronized (map) {
            ArrayList<String> l = new ArrayList<String>(10);
            for (String path : this.instances.keySet()) {
                if (f.length() == 0) {
                    if (path.lastIndexOf(47) != -1) continue;
                    l.add(path);
                    continue;
                }
                if (!path.startsWith(f + '/') || path.lastIndexOf(47) != f.length()) continue;
                l.add(path.substring(f.length() + 1));
            }
            return l.toArray(new String[l.size()]);
        }
    }

    public void createFolder(String name) throws IOException {
        throw new IOException("unsupported");
    }

    public void createData(String name) throws IOException {
        throw new IOException("unsupported");
    }

    public void rename(String oldName, String newName) throws IOException {
        throw new IOException("unsupported");
    }

    public void delete(String name) throws IOException {
        throw new IOException("unsupported");
    }

    public Object readAttribute(String name, String attrName) {
        if ("OpenIDE-Folder-SortMode".equals(attrName)) {
            return "O";
        }
        Instance inst = this.instances.get(name);
        if (inst == null) {
            return null;
        }
        Map<String, Object> m = inst.attributes;
        if (m == null) {
            return null;
        }
        Object ret = m.get(attrName);
        if (ret instanceof AttributeCreator) {
            return ((AttributeCreator)ret).createValue(this, name, attrName);
        }
        return ret;
    }

    public void writeAttribute(String name, String attrName, Object value) throws IOException {
        throw new IOException("unsupported");
    }

    public synchronized Enumeration<String> attributes(String name) {
        Instance inst = this.instances.get(name);
        if (inst == null) {
            return Enumerations.empty();
        }
        Map<String, Object> m = inst.attributes;
        if (m == null) {
            return Enumerations.empty();
        }
        return Collections.enumeration(m.keySet());
    }

    public void renameAttributes(String oldName, String newName) {
    }

    public void deleteAttributes(String name) {
    }

    public Date lastModified(String name) {
        return new Date(this.date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean folder(String name) {
        Map<String, Instance> map = this.instances;
        synchronized (map) {
            Instance inst = this.instances.get(name);
            if (inst == null) {
                return false;
            }
            return inst.folder;
        }
    }

    public boolean readOnly(String name) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String mimeType(String name) {
        Map<String, Instance> map = this.instances;
        synchronized (map) {
            Instance inst = this.instances.get(name);
            return inst == null ? null : inst.contentType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size(String name) {
        Map<String, Instance> map = this.instances;
        synchronized (map) {
            Instance inst = this.instances.get(name);
            if (inst == null) {
                return 0L;
            }
            if (inst.folder) {
                return 0L;
            }
            if (inst.contents == null) {
                return 0L;
            }
            return inst.contents.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream inputStream(String name) throws FileNotFoundException {
        Instance inst;
        Map<String, Instance> map = this.instances;
        synchronized (map) {
            inst = this.instances.get(name);
        }
        if (inst == null) {
            throw new FileNotFoundException(name);
        }
        if (inst.folder) {
            throw new FileNotFoundException(name);
        }
        byte[] contents = inst.contents;
        if (contents == null) {
            contents = new byte[]{};
        }
        return new ByteArrayInputStream(contents);
    }

    public OutputStream outputStream(String name) throws IOException {
        throw new IOException("unsupported");
    }

    public void lock(String name) throws IOException {
        throw new IOException("unsupported");
    }

    public void unlock(String name) {
    }

    public void markUnimportant(String name) {
    }

    public static interface AttributeCreator {
        public Object createValue(FixedFileSystem var1, String var2, String var3);
    }

    public static class Instance
    implements Serializable {
        final boolean folder;
        final String contentType;
        final byte[] contents;
        final String displayName;
        final URL icon;
        final String beanName;
        Map<String, Object> attributes;

        public Instance(boolean folder, String contentType, byte[] contents, String displayName, URL icon) {
            this.folder = folder;
            this.contentType = contentType;
            this.contents = contents;
            this.displayName = displayName;
            this.icon = icon;
            this.beanName = null;
        }

        public Instance(boolean folder, String contentType, byte[] contents, String displayName, String beanName) {
            this.folder = folder;
            this.contentType = contentType;
            this.contents = contents;
            this.displayName = displayName;
            this.beanName = beanName;
            this.icon = null;
        }

        public void writeAttribute(String name, Object value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(name, value);
        }
    }
}

