/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;

public final class LocalFileSystemEx
extends LocalFileSystem {
    private static HashMap<String, FileObject> allLocks = new HashMap(7);
    private static HashSet<String> pLocks = new HashSet(7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLocks() {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            LocalFileSystemEx.removeInvalid(pLocks);
            LinkedList<String> l = new LinkedList<String>();
            l.addAll(allLocks.keySet());
            l.addAll(pLocks);
            return l.toArray(new String[l.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLocks() {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            LocalFileSystemEx.removeInvalid(pLocks);
            return !allLocks.isEmpty() || !pLocks.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void potentialLock(String name) {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            pLocks.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void potentialLock(String o, String n) {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            if (pLocks.remove(o)) {
                pLocks.add(n);
            }
        }
    }

    private static void removeInvalid(Set names) {
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (null != sfs.findResource(name)) continue;
            i.remove();
        }
    }

    public LocalFileSystemEx() {
        this(false);
    }

    LocalFileSystemEx(boolean supportRemoveWritablesAttr) {
        if (supportRemoveWritablesAttr) {
            this.attr = new DelegatingAttributes(this.attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock(String name) throws IOException {
        super.lock(name);
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            FileObject fo = this.findResource(name);
            allLocks.put(name, fo);
            pLocks.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock(String name) {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            if (allLocks.containsKey(name)) {
                allLocks.remove(name);
            } else {
                FileObject fo = this.findResource(name);
                if (fo != null) {
                    for (Map.Entry<String, FileObject> entry : allLocks.entrySet()) {
                        if (!fo.equals(entry.getValue())) continue;
                        allLocks.remove(entry.getKey());
                        break;
                    }
                } else {
                    Logger.getLogger(LocalFileSystemEx.class.getName()).log(Level.WARNING, null, new Throwable("Can't unlock file " + name + ", it's lock was not found or it wasn't locked."));
                }
            }
        }
        super.unlock(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegatingAttributes
    implements AbstractFileSystem.Attr {
        private AbstractFileSystem.Attr a;

        public DelegatingAttributes(AbstractFileSystem.Attr a) {
            this.a = a;
        }

        public Object readAttribute(String name, String attrName) {
            if ("removeWritables".equals(attrName)) {
                return new WritableRemover(name);
            }
            return this.a.readAttribute(name, attrName);
        }

        public void writeAttribute(String name, String attrName, Object value) throws IOException {
            this.a.writeAttribute(name, attrName, value);
        }

        public Enumeration<String> attributes(String name) {
            return this.a.attributes(name);
        }

        public void renameAttributes(String oldName, String newName) {
            this.a.readAttribute(oldName, newName);
        }

        public void deleteAttributes(String name) {
            this.a.deleteAttributes(name);
        }
    }

    private class WritableRemover
    implements Callable {
        private String name;

        public WritableRemover(String name) {
            this.name = name;
        }

        public Object call() throws Exception {
            FileObject fo = LocalFileSystemEx.this.findResource(this.name);
            if (null != fo) {
                fo.delete();
            }
            return null;
        }
    }
}

